/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.core.impl;

import com.baidu.disconf.client.core.DisconfCoreMgr;
import com.baidu.disconf.client.core.processor.DisconfCoreProcessor;
import com.baidu.disconf.client.core.processor.DisconfCoreProcessorFactory;
import com.baidu.disconf.client.fetcher.FetcherMgr;
import com.baidu.disconf.client.support.registry.Registry;
import com.baidu.disconf.client.watch.WatchMgr;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconfCoreMgrImpl
implements DisconfCoreMgr {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DisconfCoreMgrImpl.class);
    private List<DisconfCoreProcessor> disconfCoreProcessorList = new ArrayList<DisconfCoreProcessor>();
    private WatchMgr watchMgr = null;
    private FetcherMgr fetcherMgr = null;
    private Registry registry = null;

    public DisconfCoreMgrImpl(WatchMgr watchMgr, FetcherMgr fetcherMgr, Registry registry) {
        this.watchMgr = watchMgr;
        this.fetcherMgr = fetcherMgr;
        this.registry = registry;
        DisconfCoreProcessor disconfCoreProcessorFile = DisconfCoreProcessorFactory.getDisconfCoreProcessorFile(watchMgr, fetcherMgr, registry);
        this.disconfCoreProcessorList.add(disconfCoreProcessorFile);
        DisconfCoreProcessor disconfCoreProcessorItem = DisconfCoreProcessorFactory.getDisconfCoreProcessorItem(watchMgr, fetcherMgr, registry);
        this.disconfCoreProcessorList.add(disconfCoreProcessorItem);
    }

    @Override
    public void process() {
        for (DisconfCoreProcessor disconfCoreProcessor : this.disconfCoreProcessorList) {
            disconfCoreProcessor.processAllItems();
        }
    }

    @Override
    public void processFile(String fileName) {
        DisconfCoreProcessor disconfCoreProcessorFile = DisconfCoreProcessorFactory.getDisconfCoreProcessorFile(this.watchMgr, this.fetcherMgr, this.registry);
        disconfCoreProcessorFile.processOneItem(fileName);
    }

    @Override
    public void inject2DisconfInstance() {
        for (DisconfCoreProcessor disconfCoreProcessor : this.disconfCoreProcessorList) {
            disconfCoreProcessor.inject2Conf();
        }
    }

    @Override
    public void release() {
        if (this.fetcherMgr != null) {
            this.fetcherMgr.release();
        }
        if (this.watchMgr != null) {
            this.watchMgr.release();
        }
    }
}

