/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.scan.inner.statically.impl;

import com.baidu.disconf.client.common.annotations.DisconfItem;
import com.baidu.disconf.client.common.model.DisConfCommonModel;
import com.baidu.disconf.client.common.model.DisconfCenterBaseModel;
import com.baidu.disconf.client.common.model.DisconfCenterItem;
import com.baidu.disconf.client.config.DisClientSysConfig;
import com.baidu.disconf.client.scan.inner.statically.StaticScannerMgr;
import com.baidu.disconf.client.scan.inner.statically.impl.StaticScannerMgrImplBase;
import com.baidu.disconf.client.scan.inner.statically.model.ScanStaticModel;
import com.baidu.disconf.client.store.DisconfStoreProcessorFactory;
import com.baidu.disconf.client.support.utils.MethodUtils;
import com.baidu.disconf.core.common.constants.DisConfigTypeEnum;
import com.baidu.disconf.core.common.path.DisconfWebPathMgr;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticScannerItemMgrImpl
extends StaticScannerMgrImplBase
implements StaticScannerMgr {
    protected static final Logger LOGGER = LoggerFactory.getLogger(StaticScannerItemMgrImpl.class);

    @Override
    public void scanData2Store(ScanStaticModel scanModel) {
        List<DisconfCenterBaseModel> disconfCenterItems = StaticScannerItemMgrImpl.getDisconfItems(scanModel);
        DisconfStoreProcessorFactory.getDisconfStoreItemProcessor().transformScanData(disconfCenterItems);
    }

    @Override
    public void exclude(Set<String> keySet) {
        DisconfStoreProcessorFactory.getDisconfStoreItemProcessor().exclude(keySet);
    }

    private static List<DisconfCenterBaseModel> getDisconfItems(ScanStaticModel scanModel) {
        ArrayList<DisconfCenterBaseModel> disconfCenterItems = new ArrayList<DisconfCenterBaseModel>();
        Set<Method> methods = scanModel.getDisconfItemMethodSet();
        for (Method method : methods) {
            DisconfCenterItem disconfCenterItem = StaticScannerItemMgrImpl.transformScanItem(method);
            if (disconfCenterItem == null) continue;
            disconfCenterItems.add(disconfCenterItem);
        }
        return disconfCenterItems;
    }

    private static DisconfCenterItem transformScanItem(Method method) {
        DisconfCenterItem disconfCenterItem = new DisconfCenterItem();
        Class<?> cls = method.getDeclaringClass();
        Field[] expectedFields = cls.getDeclaredFields();
        Field field = MethodUtils.getFieldFromMethod(method, expectedFields, DisConfigTypeEnum.ITEM);
        if (field == null) {
            return null;
        }
        DisconfItem disconfItem = method.getAnnotation(DisconfItem.class);
        String key = disconfItem.key().replace(" ", "");
        Method setterMethod = MethodUtils.getSetterMethodFromField(cls, field);
        disconfCenterItem.setSetMethod(setterMethod);
        disconfCenterItem.setField(field);
        disconfCenterItem.setKey(key);
        field.setAccessible(true);
        disconfCenterItem.setObject(null);
        if (Modifier.isStatic(field.getModifiers())) {
            try {
                disconfCenterItem.setValue(field.get(null));
            }
            catch (Exception e) {
                LOGGER.error(e.toString());
                disconfCenterItem.setValue(null);
            }
        } else {
            disconfCenterItem.setValue(null);
        }
        DisConfCommonModel disConfCommonModel = StaticScannerItemMgrImpl.makeDisConfCommonModel(disconfItem.app(), disconfItem.env(), disconfItem.version());
        disconfCenterItem.setDisConfCommonModel(disConfCommonModel);
        String url = DisconfWebPathMgr.getRemoteUrlParameter((String)DisClientSysConfig.getInstance().CONF_SERVER_STORE_ACTION, (String)disConfCommonModel.getApp(), (String)disConfCommonModel.getVersion(), (String)disConfCommonModel.getEnv(), (String)key, (DisConfigTypeEnum)DisConfigTypeEnum.ITEM);
        disconfCenterItem.setRemoteServerUrl(url);
        return disconfCenterItem;
    }
}

