/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.store.aspect;

import com.baidu.disconf.client.common.annotations.DisconfFile;
import com.baidu.disconf.client.common.annotations.DisconfFileItem;
import com.baidu.disconf.client.common.annotations.DisconfItem;
import com.baidu.disconf.client.config.DisClientConfig;
import com.baidu.disconf.client.store.DisconfStoreProcessor;
import com.baidu.disconf.client.store.DisconfStoreProcessorFactory;
import com.baidu.disconf.client.support.utils.MethodUtils;
import com.baidu.disconf.core.common.constants.DisConfigTypeEnum;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class DisconfAspectJ {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DisconfAspectJ.class);

    @Pointcut(value="execution(public * *(..))")
    public void anyPublicMethod() {
    }

    @Around(value="anyPublicMethod() && @annotation(disconfFileItem)")
    public Object decideAccess(ProceedingJoinPoint pjp, DisconfFileItem disconfFileItem) throws Throwable {
        Object rtnOb;
        if (DisClientConfig.getInstance().ENABLE_DISCONF) {
            DisconfStoreProcessor disconfStoreProcessor;
            Object ret;
            MethodSignature ms = (MethodSignature)pjp.getSignature();
            Method method = ms.getMethod();
            Class<?> cls = method.getDeclaringClass();
            DisconfFile disconfFile = cls.getAnnotation(DisconfFile.class);
            Field field = MethodUtils.getFieldFromMethod(method, cls.getDeclaredFields(), DisConfigTypeEnum.FILE);
            if (field != null && (ret = (disconfStoreProcessor = DisconfStoreProcessorFactory.getDisconfStoreFileProcessor()).getConfig(disconfFile.filename(), disconfFileItem.name())) != null) {
                LOGGER.debug("using disconf store value: " + disconfFile.filename() + " (" + disconfFileItem.name() + " , " + ret + ")");
                return ret;
            }
        }
        try {
            rtnOb = pjp.proceed();
        }
        catch (Throwable t) {
            LOGGER.info(t.getMessage());
            throw t;
        }
        return rtnOb;
    }

    @Around(value="anyPublicMethod() && @annotation(disconfItem)")
    public Object decideAccess(ProceedingJoinPoint pjp, DisconfItem disconfItem) throws Throwable {
        Object rtnOb;
        DisconfStoreProcessor disconfStoreProcessor;
        Object ret;
        if (DisClientConfig.getInstance().ENABLE_DISCONF && (ret = (disconfStoreProcessor = DisconfStoreProcessorFactory.getDisconfStoreItemProcessor()).getConfig(null, disconfItem.key())) != null) {
            LOGGER.debug("using disconf store value: (" + disconfItem.key() + " , " + ret + ")");
            return ret;
        }
        try {
            rtnOb = pjp.proceed();
        }
        catch (Throwable t) {
            LOGGER.info(t.getMessage());
            throw t;
        }
        return rtnOb;
    }
}

