/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.core.common.restful.impl;

import com.baidu.disconf.core.common.restful.RestfulMgr;
import com.baidu.disconf.core.common.restful.core.RemoteUrl;
import com.baidu.disconf.core.common.restful.retry.RetryStrategy;
import com.baidu.disconf.core.common.restful.type.FetchConfFile;
import com.baidu.disconf.core.common.restful.type.RestfulGet;
import com.baidu.disconf.core.common.utils.ClassLoaderUtil;
import com.baidu.disconf.core.common.utils.MyStringUtils;
import com.baidu.disconf.core.common.utils.OsUtil;
import com.baidu.disconf.core.common.utils.http.HttpClientUtil;
import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulMgrImpl
implements RestfulMgr {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RestfulMgrImpl.class);
    private RetryStrategy retryStrategy;

    public RestfulMgrImpl(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
        HttpClientUtil.init();
    }

    @Override
    public <T> T getJsonData(Class<T> clazz, RemoteUrl remoteUrl, int retryTimes, int retrySleepSeconds) throws Exception {
        Exception ex = null;
        for (URL url : remoteUrl.getUrls()) {
            RestfulGet<T> unreliableImpl = new RestfulGet<T>(clazz, url);
            try {
                Object t = this.retryStrategy.retry(unreliableImpl, retryTimes, retrySleepSeconds);
                return t;
            }
            catch (Exception e) {
                ex = e;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    LOGGER.info("pass");
                }
            }
        }
        throw new Exception("cannot get: " + remoteUrl, ex);
    }

    @Override
    public String downloadFromServer(RemoteUrl remoteUrl, String fileName, String localFileDir, String localFileDirTemp, String targetDirPath, boolean enableLocalDownloadDirInClassPath, int retryTimes, int retrySleepSeconds) throws Exception {
        File localFile = null;
        try {
            File tmpFilePathUniqueFile = this.retryDownload(localFileDirTemp, fileName, remoteUrl, retryTimes, retrySleepSeconds);
            localFile = this.transfer2SpecifyDir(tmpFilePathUniqueFile, localFileDir, fileName, false);
            if (targetDirPath != null && (enableLocalDownloadDirInClassPath || !targetDirPath.equals(ClassLoaderUtil.getClassPath()))) {
                localFile = this.transfer2SpecifyDir(tmpFilePathUniqueFile, targetDirPath, fileName, true);
            }
            LOGGER.debug("Move to: " + localFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOGGER.warn("download file failed, using previous download file.", (Throwable)e);
        }
        if (localFile == null || !localFile.exists()) {
            throw new Exception("target file cannot be found! " + fileName);
        }
        String relativePathString = OsUtil.getRelativePath(localFile, new File(localFileDir));
        if (relativePathString != null && new File(relativePathString).isFile()) {
            return relativePathString;
        }
        return localFile.getAbsolutePath();
    }

    @Override
    public void close() {
        HttpClientUtil.close();
    }

    private File retryDownload(String localFileDirTemp, String fileName, RemoteUrl remoteUrl, int retryTimes, int retrySleepSeconds) throws Exception {
        if (localFileDirTemp == null) {
            localFileDirTemp = "./disconf/download";
        }
        String tmpFilePath = OsUtil.pathJoin(localFileDirTemp, fileName);
        String tmpFilePathUnique = MyStringUtils.getRandomName(tmpFilePath);
        File tmpFilePathUniqueFile = new File(tmpFilePathUnique);
        this.retry4ConfDownload(remoteUrl, tmpFilePathUniqueFile, retryTimes, retrySleepSeconds);
        return tmpFilePathUniqueFile;
    }

    private File transfer2SpecifyDir(File srcFile, String targetDirPath, String fileName, boolean isMove) throws Exception {
        OsUtil.makeDirs(targetDirPath);
        File targetPath = new File(OsUtil.pathJoin(targetDirPath, fileName));
        OsUtil.transferFileAtom(srcFile, targetPath, isMove);
        return targetPath;
    }

    private Object retry4ConfDownload(RemoteUrl remoteUrl, File localTmpFile, int retryTimes, int sleepSeconds) throws Exception {
        Exception ex = null;
        for (URL url : remoteUrl.getUrls()) {
            FetchConfFile unreliableImpl = new FetchConfFile(url, localTmpFile);
            try {
                return this.retryStrategy.retry(unreliableImpl, retryTimes, sleepSeconds);
            }
            catch (Exception e) {
                ex = e;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    LOGGER.info("pass");
                }
            }
        }
        throw new Exception("download failed.", ex);
    }
}

