/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.core.common.utils.http;

import com.baidu.disconf.core.common.utils.http.HttpClientKeepAliveStrategy;
import com.baidu.disconf.core.common.utils.http.HttpResponseCallbackHandler;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUtil.class);
    protected static CloseableHttpClient httpclient;

    private static void buildHttpClient() {
        CloseableHttpClient httpclient;
        RequestConfig globalConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).build();
        HttpClientUtil.httpclient = httpclient = HttpClients.custom().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new HttpClientKeepAliveStrategy()).setDefaultRequestConfig(globalConfig).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T execute(HttpRequestBase request, HttpResponseCallbackHandler<T> responseHandler) throws Exception {
        CloseableHttpResponse httpclientResponse = null;
        try {
            HttpEntity requestEntity;
            if (LOGGER.isDebugEnabled()) {
                Header[] headers;
                for (Header header : headers = request.getAllHeaders()) {
                    LOGGER.debug("request: " + header.getName() + "\t" + header.getValue());
                }
            }
            httpclientResponse = httpclient.execute((HttpUriRequest)request);
            if (LOGGER.isDebugEnabled()) {
                for (Header header : httpclientResponse.getAllHeaders()) {
                    LOGGER.debug("response header: {}\t{}", (Object)header.getName(), (Object)header.getValue());
                }
            }
            int statusCode = httpclientResponse.getStatusLine().getStatusCode();
            String requestBody = null;
            if (request instanceof HttpEntityEnclosingRequestBase && (requestEntity = ((HttpEntityEnclosingRequestBase)request).getEntity()) != null) {
                requestBody = EntityUtils.toString((HttpEntity)requestEntity);
            }
            LOGGER.info("execute http request [{}], status code [{}]", requestBody, (Object)statusCode);
            if (statusCode != 200) {
                throw new Exception("execute  request failed [" + requestBody + "], statusCode [" + statusCode + "]");
            }
            HttpEntity entity = httpclientResponse.getEntity();
            if (entity != null && responseHandler != null) {
                T t = responseHandler.handleResponse(requestBody, entity);
                return t;
            }
            LOGGER.info("execute response [{}], response empty", (Object)requestBody);
            T t = null;
            return t;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (httpclientResponse != null) {
                try {
                    httpclientResponse.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void close() {
        if (httpclient != null) {
            try {
                httpclient.close();
                httpclient = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void init() {
        HttpClientUtil.buildHttpClient();
    }
}

