/*
 * Copyright 2020 Baidu, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.as.model.asgroup;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for adjusting the asGroup.
 */
public class AdjustAsGroupRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     * The request will be idempotent if client token is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The auto scaling group ID of the nodes to be adjusted
     */
    @JsonIgnore
    private String groupId;

    /**
     * Number of nodes to be adjusted
     */
    private int actionNum;

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public int getActionNum() {
        return actionNum;
    }

    public void setActionNum(int actionNum) {
        this.actionNum = actionNum;
    }

    @Override
    public String toString() {
        return "AdjustAsGroupRequest{" +
                "clientToken='" + clientToken + '\'' +
                ", groupId='" + groupId + '\'' +
                ", actionNum=" + actionNum +
                '}';
    }

    public AdjustAsGroupRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public AdjustAsGroupRequest withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public AdjustAsGroupRequest withActionNum(int actionNum) {
        this.actionNum = actionNum;
        return this;
    }

    @Override
    public AdjustAsGroupRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
