/*
 * Copyright (C) 2020 Baidu, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.iotdmp.model.fm;

import com.baidubce.model.AbstractBceResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.hadoop.mapred.TaskStatus;

@Data
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class ConfigTaskResponse extends AbstractBceResponse {
    private String taskId;
    private TaskType taskType;
    private TaskStatus taskStatus;
    private String createTime;
    private String updateTime;

    public ConfigTaskResponse(ProductConfigTask task) {
        taskId = task.getTaskId();
        taskType = task.getTargetSize() == 1 ? TaskType.SINGLE : TaskType.BATCH;
        taskStatus = task.getTaskStatus();
        createTime = task.getCreateTime();
        updateTime = task.getUpdateTime();
    }

    private enum TaskType {
        SINGLE, BATCH
    }
}
