/*
 * Copyright 2015 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package com.baidubce.services.lss.model;

import java.io.Serializable;
import java.util.List;

public class Refer implements Serializable {
    private List<String> whitelist = null;

    private List<String> blacklist = null;

    public List<String> getWhitelist() {
        return whitelist;
    }

    public void setWhitelist(List<String> whitelist) {
        this.whitelist = whitelist;
    }

    public Refer withWhitelist(List<String> whitelist) {
        this.whitelist = whitelist;
        return this;
    }

    public List<String> getBlacklist() {
        return blacklist;
    }

    public void setBlacklist(List<String> blacklist) {
        this.blacklist = blacklist;
    }

    public Refer withBlacklist(List<String> blacklist) {
        this.blacklist = blacklist;
        return this;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("class Refer {\n");
        sb.append("    whitelist: ").append(whitelist).append("\n");
        sb.append("    blacklist: ").append(blacklist).append("\n");
        sb.append("}\n");
        return sb.toString();
    }
}
