/*
 * Copyright (c) 2014 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.nat.model;

import java.util.List;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bcc.model.Billing;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for creating a nat.
 */
public class CreateNatRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The name of nat that will be created.
     */
    private String name;

    /**
     * The vpcId of nat that will be created.
     */
    private String vpcId;

    /**
     * The spec of nat that will be created.
     */
    private String spec;

    /**
     * The eips of nat that will be created.
     */
    private List<String> eips;

    /**
     * The billing of nat that will be created.
     */
    private Billing billing;

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    /**
     * Configure name for the request.
     *
     * @param name The name of CreateNatRequest
     * @return CreateNatRequest with specific name
     */
    public CreateNatRequest withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Configure vpcId for the request.
     *
     * @param vpcId The vpcId of CreateNatRequest
     * @return CreateNatRequest with specific vpcId
     */
    public CreateNatRequest withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    /**
     * Configure spec for the request.
     *
     * @param spec The spec of CreateNatRequest
     * @return CreateNatRequest with specific spec
     */
    public CreateNatRequest withSpec(String spec) {
        this.spec = spec;
        return this;
    }

    /**
     * Configure eips for the request.
     *
     * @param eips The spec of CreateNatRequest
     * @return CreateNatRequest with specific eips
     */
    public CreateNatRequest withEips(List<String> eips) {
        this.eips = eips;
        return this;
    }

    /**
     * Configure billing for the request.
     *
     * @param billing The spec of CreateNatRequest
     * @return CreateNatRequest with specific billing
     */
    public CreateNatRequest withBilling(Billing billing) {
        this.billing = billing;
        return this;
    }

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVpcId() {
        return vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public List<String> getEips() {
        return eips;
    }

    public void setEips(List<String> eips) {
        this.eips = eips;
    }

    public Billing getBilling() {
        return billing;
    }

    public void setBilling(Billing billing) {
        this.billing = billing;
    }
}
