/*
 * Copyright (c) 2014 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.peerconn.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The peer conn id request.
 */
public class SyncDnsRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The peerConnId of peer conn.
     */
    @JsonIgnore
    private String peerConnId;

    /**
     * The role, initiator or acceptor.
     */
    private String role;

    /**
     * Configure bandwidthInMbps for the request.
     *
     * @param peerConnId The bandwidthInMbps of SyncDnsRequest.
     * @return SyncDnsRequest with specific bandwidthInMbps.
     */
    public SyncDnsRequest withPeerConnId(String peerConnId) {
        this.peerConnId = peerConnId;
        return this;
    }

    /**
     * Configure role for the request.
     *
     * @param role The role of SyncDnsRequest.
     * @return SyncDnsRequest with specific bandwidthInMbps.
     */
    public SyncDnsRequest withRole(String role) {
        this.role = role;
        return this;
    }

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getPeerConnId() {
        return peerConnId;
    }

    public void setPeerConnId(String peerConnId) {
        this.peerConnId = peerConnId;
    }
}
