package com.baidubce.services.vpn.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.eip.model.Billing;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

/**
 * The request for creating a newly vpn.
 */
@Data
public class CreateVpnRequest extends AbstractBceRequest {

    /*********************** Required **************************/
    /**vpc id*/
    private String vpcId;
    /**VPN The name, uppercase and lowercase letters, numbers and -_/. special characters, must start with a letter, length 1-65 */
    private String vpnName;
    /** Billing information, support prepaid and postpaid methods */
    private Billing billing;


    /************************ Not required **********************/
    /**VPN description*/
    private String description;
    /**the eip of vpn*/
    private String eip;
    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
