/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.BceClientException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.services.bos.model.GenericObjectRequest;
import com.baidubce.services.bos.model.InputSerialization;
import com.baidubce.services.bos.model.OutputSerialization;
import com.baidubce.util.Base64Utils;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.io.UnsupportedEncodingException;

@JsonRootName(value="selectRequest")
@JsonPropertyOrder(value={"expression", "expressionType", "inputSerialization", "outputSerialization", "requestProgress"})
public class SelectObjectRequest
extends GenericObjectRequest {
    @JsonIgnore
    private String key;
    @JsonIgnore
    private String selectType;
    private String expression;
    private ExpressionType expressionType = ExpressionType.SQL;
    private InputSerialization inputSerialization;
    private OutputSerialization outputSerialization;
    private RequestProgress requestProgress = new RequestProgress();

    public SelectObjectRequest(String bucketName, String key) {
        super(bucketName, key);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public void setSelectType(String selectType) {
        this.selectType = selectType.toLowerCase();
    }

    public String getSelectType() {
        return this.selectType;
    }

    public SelectObjectRequest withSelectType(String selectType) {
        this.setSelectType(selectType);
        return this;
    }

    @Override
    public SelectObjectRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    @Override
    public SelectObjectRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    @Override
    public GenericObjectRequest withKey(String key) {
        this.setKey(key);
        return this;
    }

    public void setExpression(String expression) {
        this.expression = Base64Utils.encode(expression);
    }

    public String getExpression() {
        return this.expression;
    }

    public SelectObjectRequest withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public void setInputSerialization(InputSerialization inputSerialization) {
        this.inputSerialization = inputSerialization;
    }

    public InputSerialization getInputSerialization() {
        return this.inputSerialization;
    }

    public SelectObjectRequest withInputSerialization(InputSerialization inputSerialization) {
        this.setInputSerialization(inputSerialization);
        return this;
    }

    public OutputSerialization getOutputSerialization() {
        return this.outputSerialization;
    }

    public void setOutputSerialization(OutputSerialization outputSerialization) {
        this.outputSerialization = outputSerialization;
    }

    public SelectObjectRequest withOutputSerialization(OutputSerialization outputSerialization) {
        this.setOutputSerialization(outputSerialization);
        return this;
    }

    public void setRequestProgress(boolean enabled) {
        this.requestProgress.setEnabled(enabled);
    }

    public RequestProgress getRequestProgress() {
        return this.requestProgress;
    }

    public SelectObjectRequest withRequestProgress(boolean enabled) {
        this.setRequestProgress(enabled);
        return this;
    }

    public void setExpressionType(ExpressionType expressionType) {
        this.expressionType = expressionType;
    }

    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public SelectObjectRequest withExpressionType(ExpressionType expressionType) {
        this.setExpressionType(expressionType);
        return this;
    }

    public String getOutputValue(String key) {
        return this.outputSerialization.getValue(key);
    }

    public byte[] buildBody() {
        byte[] requestBody = null;
        if (this.selectType.equals("csv")) {
            this.inputSerialization.setCsvParams(this.inputSerialization.getParams());
            this.outputSerialization.setCsvParams(this.outputSerialization.getParams());
        } else if (this.selectType.equals("json")) {
            this.inputSerialization.setJsonParams(this.inputSerialization.getParams());
            this.outputSerialization.setJsonParams(this.outputSerialization.getParams());
        } else {
            throw new IllegalArgumentException("selectType should be csv or json");
        }
        String writer = JsonUtils.toJsonStringWithRootName(this);
        try {
            requestBody = writer.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        return requestBody;
    }

    public class RequestProgress {
        private boolean enabled = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static enum ExpressionType {
        SQL;

    }
}

