/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model;

import com.baidubce.BceClientException;
import com.baidubce.services.tablestorage.model.AbstractTableStorageRequest;
import com.baidubce.services.tablestorage.model.BatchDeleteRowRequest;
import com.baidubce.services.tablestorage.model.BatchGetRowRequest;
import com.baidubce.services.tablestorage.model.BatchPutRowRequest;
import com.baidubce.services.tablestorage.model.TableStorageRow;
import java.util.ArrayList;
import java.util.List;

public class BatchRowRequest<T extends TableStorageRow>
extends AbstractTableStorageRequest {
    private int maxVersions = 1;
    protected List<T> rows = new ArrayList<T>();

    BatchRowRequest(String tableName) {
        super(tableName);
    }

    public static void checkBatchRequest(BatchRowRequest batchRowRequest) {
        if (batchRowRequest == null) {
            return;
        }
        if ((batchRowRequest instanceof BatchPutRowRequest || batchRowRequest instanceof BatchDeleteRowRequest) && batchRowRequest.rows.size() > 200) {
            throw new BceClientException("The row's size should not exceed the limit 200 in Put and Delete operations. rowSize=" + batchRowRequest.rows.size() + ".");
        }
        if (batchRowRequest instanceof BatchGetRowRequest && batchRowRequest.rows.size() > 100) {
            throw new BceClientException("The row's size should not exceed the limit 100 in Get operation. rowSize=" + batchRowRequest.rows.size() + ".");
        }
        for (Object row : batchRowRequest.rows) {
            TableStorageRow.checkRow((TableStorageRow)row);
        }
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public void setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
    }

    @Override
    public String toJsonString() {
        BatchRowRequest.checkBatchRequest(this);
        StringBuffer buffer = new StringBuffer("{");
        buffer.append("\"maxVersions\":" + this.maxVersions);
        buffer.append(",");
        buffer.append("\"rows\":[");
        for (int i = 0; i < this.rows.size(); ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            TableStorageRow row = (TableStorageRow)this.rows.get(i);
            buffer.append(row.toJsonString());
        }
        buffer.append("]}");
        return buffer.toString();
    }
}

