/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bes;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bes.model.BesCreateAutoRenewRuleRequest;
import com.baidubce.services.bes.model.BesCreateAutoRenewRuleResponse;
import com.baidubce.services.bes.model.BesCreateClusterRequest;
import com.baidubce.services.bes.model.BesCreateClusterResponse;
import com.baidubce.services.bes.model.BesDeleteAutoRenewRuleRequest;
import com.baidubce.services.bes.model.BesDeleteAutoRenewRuleResponse;
import com.baidubce.services.bes.model.BesDeleteClusterRequest;
import com.baidubce.services.bes.model.BesDeleteClusterResponse;
import com.baidubce.services.bes.model.BesGetAutoRenewRuleListRequest;
import com.baidubce.services.bes.model.BesGetAutoRenewRuleListResponse;
import com.baidubce.services.bes.model.BesGetClusterDetailRequest;
import com.baidubce.services.bes.model.BesGetClusterDetailResponse;
import com.baidubce.services.bes.model.BesGetClusterListRequest;
import com.baidubce.services.bes.model.BesGetClusterListResponse;
import com.baidubce.services.bes.model.BesGetRenewListRequest;
import com.baidubce.services.bes.model.BesGetRenewListResponse;
import com.baidubce.services.bes.model.BesRenewClusterRequest;
import com.baidubce.services.bes.model.BesRenewClusterResponse;
import com.baidubce.services.bes.model.BesResizeClusterRequest;
import com.baidubce.services.bes.model.BesStartClusterRequest;
import com.baidubce.services.bes.model.BesStartClusterResponse;
import com.baidubce.services.bes.model.BesStartInstanceRequest;
import com.baidubce.services.bes.model.BesStartInstanceResponse;
import com.baidubce.services.bes.model.BesStopClusterRequest;
import com.baidubce.services.bes.model.BesStopClusterResponse;
import com.baidubce.services.bes.model.BesStopInstanceRequest;
import com.baidubce.services.bes.model.BesStopInstanceResponse;
import com.baidubce.services.bes.model.BesUpdateAutoRenewRuleRequest;
import com.baidubce.services.bes.model.BesUpdateAutoRenewRuleResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class BesClient
extends AbstractBceClient {
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final String BASE_PATH = "/api/bes/cluster";
    private static final String STOP = "/stop";
    private static final String START = "/start";
    private static final String DELETE = "/delete";
    private static final String LIST = "/list";
    private static final String DETAIL = "/detail";
    private static final String CREATE = "/create";
    private static final String RESIZE = "/resize";
    private static final String UPDATE = "/update";
    private static final String INSTANCE = "/instance";
    private static final String RENEW = "/renew";
    private static final String AUTO_RENEW_RULE = "/auto_renew_rule";
    private static final String X_REGION = "X-Region";
    private static final String BES_SERVICE_TYPE = "BES";
    private String region;
    private static final HttpResponseHandler[] BES_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public BesClient() {
        this(new BceClientConfiguration());
    }

    public BesClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, BES_HANDLERS);
    }

    public BesClient(BceClientConfiguration clientConfiguration, String region) {
        super(clientConfiguration, BES_HANDLERS);
        this.region = region;
    }

    public BesStopClusterResponse stopCluster(BesStopClusterRequest besStopClusterRequest) {
        Preconditions.checkNotNull((Object)besStopClusterRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(besStopClusterRequest.getClusterId(), "The parameter clusterId should not be null or empty string.");
        String json = null;
        try {
            json = besStopClusterRequest.toJson();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(besStopClusterRequest, HttpMethodName.POST, BASE_PATH, STOP);
        this.addCommonHeader(internalRequest, json);
        BesStopClusterResponse besStopClusterResponse = this.invokeHttpClient(internalRequest, BesStopClusterResponse.class);
        return besStopClusterResponse;
    }

    public BesStartClusterResponse startCluster(BesStartClusterRequest besStartClusterRequest) {
        Preconditions.checkNotNull((Object)besStartClusterRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(besStartClusterRequest.getClusterId(), "The parameter clusterId should not be null or empty string.");
        String json = null;
        try {
            json = besStartClusterRequest.toJson();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(besStartClusterRequest, HttpMethodName.POST, BASE_PATH, START);
        this.addCommonHeader(internalRequest, json);
        BesStartClusterResponse besStartClusterResponse = this.invokeHttpClient(internalRequest, BesStartClusterResponse.class);
        return besStartClusterResponse;
    }

    public BesDeleteClusterResponse deleteCluster(BesDeleteClusterRequest besDeleteClusterRequest) {
        Preconditions.checkNotNull((Object)besDeleteClusterRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(besDeleteClusterRequest.getClusterId(), "The parameter clusterId should not be null or empty string.");
        String json = null;
        try {
            json = besDeleteClusterRequest.toJson();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(besDeleteClusterRequest, HttpMethodName.POST, BASE_PATH, DELETE);
        this.addCommonHeader(internalRequest, json);
        BesDeleteClusterResponse besDeleteClusterResponse = this.invokeHttpClient(internalRequest, BesDeleteClusterResponse.class);
        return besDeleteClusterResponse;
    }

    public BesGetClusterListResponse getClusterList(BesGetClusterListRequest besGetClusterListRequest) {
        Preconditions.checkNotNull((Object)besGetClusterListRequest, (Object)"request should not be null.");
        String json = null;
        try {
            json = besGetClusterListRequest.toJson();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(besGetClusterListRequest, HttpMethodName.POST, BASE_PATH, LIST);
        this.addCommonHeader(internalRequest, json);
        BesGetClusterListResponse besGetClusterListResponse = this.invokeHttpClient(internalRequest, BesGetClusterListResponse.class);
        return besGetClusterListResponse;
    }

    public BesGetClusterDetailResponse getClusterDetail(BesGetClusterDetailRequest besGetClusterDetailRequest) {
        Preconditions.checkNotNull((Object)besGetClusterDetailRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(besGetClusterDetailRequest.getClusterId(), "The parameter clusterId should not be null or empty string.");
        String json = null;
        try {
            json = besGetClusterDetailRequest.toJson();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(besGetClusterDetailRequest, HttpMethodName.POST, BASE_PATH, DETAIL);
        this.addCommonHeader(internalRequest, json);
        BesGetClusterDetailResponse besGetClusterDetailResponse = this.invokeHttpClient(internalRequest, BesGetClusterDetailResponse.class);
        return besGetClusterDetailResponse;
    }

    public BesCreateClusterResponse createCluster(BesCreateClusterRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        String json = null;
        try {
            json = request.toJson();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BASE_PATH, CREATE);
        this.addCommonHeader(internalRequest, json);
        BesCreateClusterResponse deployResponse = this.invokeHttpClient(internalRequest, BesCreateClusterResponse.class);
        return deployResponse;
    }

    public BesCreateClusterResponse resizeCluster(BesResizeClusterRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        String json = null;
        try {
            json = request.toJson(this.region);
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BASE_PATH, RESIZE);
        internalRequest.addParameter("orderType", "RESIZE");
        this.addCommonHeader(internalRequest, json);
        BesCreateClusterResponse deployResponse = this.invokeHttpClient(internalRequest, BesCreateClusterResponse.class);
        return deployResponse;
    }

    public BesStartInstanceResponse startClusterInstance(BesStartInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterId should not be null or empty string.");
        String json = null;
        try {
            json = request.toJson();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BASE_PATH, INSTANCE, START);
        this.addCommonHeader(internalRequest, json);
        BesStartInstanceResponse besStartInstanceResponse = this.invokeHttpClient(internalRequest, BesStartInstanceResponse.class);
        return besStartInstanceResponse;
    }

    public BesStopInstanceResponse stopClusterInstance(BesStopInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterId should not be null or empty string.");
        String json = null;
        try {
            json = request.toJson();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BASE_PATH, INSTANCE, STOP);
        this.addCommonHeader(internalRequest, json);
        BesStopInstanceResponse besStopInstanceResponse = this.invokeHttpClient(internalRequest, BesStopInstanceResponse.class);
        return besStopInstanceResponse;
    }

    public BesGetRenewListResponse getRenewList(BesGetRenewListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        String json = null;
        try {
            json = request.toJson();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BASE_PATH, RENEW, LIST);
        this.addCommonHeader(internalRequest, json);
        BesGetRenewListResponse besGetRenewListResponse = this.invokeHttpClient(internalRequest, BesGetRenewListResponse.class);
        return besGetRenewListResponse;
    }

    public BesRenewClusterResponse renewCluster(BesRenewClusterRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterId should not be null or empty string.");
        String json = null;
        try {
            json = request.toJson();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BASE_PATH, RENEW);
        internalRequest.addParameter("orderType", "RENEW");
        this.addCommonHeader(internalRequest, json);
        BesRenewClusterResponse besRenewClusterResponse = this.invokeHttpClient(internalRequest, BesRenewClusterResponse.class);
        return besRenewClusterResponse;
    }

    public BesGetAutoRenewRuleListResponse getAutoRenewRuleList() {
        BesGetAutoRenewRuleListRequest besGetAutoRenewRuleListRequest = new BesGetAutoRenewRuleListRequest();
        besGetAutoRenewRuleListRequest.setServiceType(BES_SERVICE_TYPE);
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("serviceType", BES_SERVICE_TYPE);
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(besGetAutoRenewRuleListRequest, HttpMethodName.POST, BASE_PATH, AUTO_RENEW_RULE, LIST);
        this.addCommonHeader(internalRequest, writer.toString());
        BesGetAutoRenewRuleListResponse besGetAutoRenewRuleResponse = this.invokeHttpClient(internalRequest, BesGetAutoRenewRuleListResponse.class);
        return besGetAutoRenewRuleResponse;
    }

    public BesCreateAutoRenewRuleResponse createAutoRenewRule(BesCreateAutoRenewRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull(request.getClusterIds(), (Object)"The parameter clusterIds should not be null or empty string.");
        String json = null;
        try {
            json = request.toJson(this.region);
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BASE_PATH, AUTO_RENEW_RULE, CREATE);
        this.addCommonHeader(internalRequest, json);
        BesCreateAutoRenewRuleResponse besCreateAutoRenewRuleResponse = this.invokeHttpClient(internalRequest, BesCreateAutoRenewRuleResponse.class);
        return besCreateAutoRenewRuleResponse;
    }

    public BesUpdateAutoRenewRuleResponse updateAutoRenewRule(BesUpdateAutoRenewRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterIds should not be null or empty string.");
        String json = null;
        try {
            json = request.toJson();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BASE_PATH, AUTO_RENEW_RULE, UPDATE);
        this.addCommonHeader(internalRequest, json);
        BesUpdateAutoRenewRuleResponse besUpdateAutoRenewRuleResponse = this.invokeHttpClient(internalRequest, BesUpdateAutoRenewRuleResponse.class);
        return besUpdateAutoRenewRuleResponse;
    }

    public BesDeleteAutoRenewRuleResponse deleteAutoRenewRule(BesDeleteAutoRenewRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "The parameter clusterIds should not be null or empty string.");
        String json = null;
        try {
            json = request.toJson();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BASE_PATH, AUTO_RENEW_RULE, DELETE);
        this.addCommonHeader(internalRequest, json);
        BesDeleteAutoRenewRuleResponse besDeleteAutoRenewRuleResponse = this.invokeHttpClient(internalRequest, BesDeleteAutoRenewRuleResponse.class);
        return besDeleteAutoRenewRuleResponse;
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private String aes128EncryptWithFirst16Char(String content, String privateKey) throws GeneralSecurityException {
        if (privateKey == null || privateKey.length() < 16) {
            throw new GeneralSecurityException("account secretKey is wrong");
        }
        byte[] crypted = null;
        SecretKeySpec skey = new SecretKeySpec(privateKey.substring(0, 16).getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, skey);
        crypted = cipher.doFinal(content.getBytes());
        return new String(Hex.encodeHex((byte[])crypted));
    }

    private void addCommonHeader(InternalRequest internalRequest, String json) {
        byte[] bytes = null;
        try {
            bytes = json.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(bytes.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.addHeader(X_REGION, this.region);
        internalRequest.setContent(RestartableInputStream.wrap(bytes));
    }
}

