/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cdn;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.cdn.model.CdnRequest;
import com.baidubce.services.cdn.model.CdnResponse;
import com.baidubce.services.cdn.model.DescribeIpRequest;
import com.baidubce.services.cdn.model.DescribeIpResponse;
import com.baidubce.services.cdn.model.DescribeIpsResponse;
import com.baidubce.services.cdn.model.GetCacheQuotaResponse;
import com.baidubce.services.cdn.model.GetPrefetchStatusRequest;
import com.baidubce.services.cdn.model.GetPurgeStatusRequest;
import com.baidubce.services.cdn.model.GetPurgeStatusResponse;
import com.baidubce.services.cdn.model.ListDomainsRequest;
import com.baidubce.services.cdn.model.ListDomainsResponse;
import com.baidubce.services.cdn.model.PrefetchRequest;
import com.baidubce.services.cdn.model.PrefetchResponse;
import com.baidubce.services.cdn.model.PurgeRequest;
import com.baidubce.services.cdn.model.PurgeResponse;
import com.baidubce.services.cdn.model.PurgeTask;
import com.baidubce.services.cdn.model.SetDomainHttpsConfigRequest;
import com.baidubce.services.cdn.model.SetDomainOriginRequest;
import com.baidubce.services.cdn.model.cache.GetPrefetchStatusResponse;
import com.baidubce.services.cdn.model.cache.PrefetchTask;
import com.baidubce.services.cdn.model.certificate.BatchUploadCertRequest;
import com.baidubce.services.cdn.model.certificate.GetDomainCertResponse;
import com.baidubce.services.cdn.model.certificate.GetHttpsDomainRequest;
import com.baidubce.services.cdn.model.certificate.GetHttpsDomainResponse;
import com.baidubce.services.cdn.model.certificate.SetDomainCertRequest;
import com.baidubce.services.cdn.model.certificate.SetDomainCertResponse;
import com.baidubce.services.cdn.model.domain.CheckDomainValidResponse;
import com.baidubce.services.cdn.model.domain.CommonResponse;
import com.baidubce.services.cdn.model.domain.CopyDomainTaskRequest;
import com.baidubce.services.cdn.model.domain.CopyDomainTaskResponse;
import com.baidubce.services.cdn.model.domain.CopyDomainTaskStatusResponse;
import com.baidubce.services.cdn.model.domain.CreateDomainRequest;
import com.baidubce.services.cdn.model.domain.CreateDomainResponse;
import com.baidubce.services.cdn.model.domain.DisableDomainResponse;
import com.baidubce.services.cdn.model.domain.DomainConfigKeysResponse;
import com.baidubce.services.cdn.model.domain.EnableDomainResponse;
import com.baidubce.services.cdn.model.domain.GetDomainAccessLimitResponse;
import com.baidubce.services.cdn.model.domain.GetDomainCacheFullUrlResponse;
import com.baidubce.services.cdn.model.domain.GetDomainCacheShareResponse;
import com.baidubce.services.cdn.model.domain.GetDomainCacheTTLRequest;
import com.baidubce.services.cdn.model.domain.GetDomainCacheTTLResponse;
import com.baidubce.services.cdn.model.domain.GetDomainClientIpResponse;
import com.baidubce.services.cdn.model.domain.GetDomainCompressResponse;
import com.baidubce.services.cdn.model.domain.GetDomainConfigResponse;
import com.baidubce.services.cdn.model.domain.GetDomainCorsResponse;
import com.baidubce.services.cdn.model.domain.GetDomainErrorPageResponse;
import com.baidubce.services.cdn.model.domain.GetDomainFileTrimResponse;
import com.baidubce.services.cdn.model.domain.GetDomainHSTSResponse;
import com.baidubce.services.cdn.model.domain.GetDomainHttpHeaderResponse;
import com.baidubce.services.cdn.model.domain.GetDomainIPv6DispatchResponse;
import com.baidubce.services.cdn.model.domain.GetDomainIpACLResponse;
import com.baidubce.services.cdn.model.domain.GetDomainLimitBandwidthResponse;
import com.baidubce.services.cdn.model.domain.GetDomainLogResponse;
import com.baidubce.services.cdn.model.domain.GetDomainMediaDragResponse;
import com.baidubce.services.cdn.model.domain.GetDomainMobileAccessResponse;
import com.baidubce.services.cdn.model.domain.GetDomainOCSPSwitchResponse;
import com.baidubce.services.cdn.model.domain.GetDomainOfflineModeSwitchResponse;
import com.baidubce.services.cdn.model.domain.GetDomainOriginFixedIspResponse;
import com.baidubce.services.cdn.model.domain.GetDomainOriginProtocolResponse;
import com.baidubce.services.cdn.model.domain.GetDomainOriginResponse;
import com.baidubce.services.cdn.model.domain.GetDomainOriginTimeoutResponse;
import com.baidubce.services.cdn.model.domain.GetDomainQUICSwitchResponse;
import com.baidubce.services.cdn.model.domain.GetDomainRangeSwitchResponse;
import com.baidubce.services.cdn.model.domain.GetDomainRefererACLResponse;
import com.baidubce.services.cdn.model.domain.GetDomainRetryOriginResponse;
import com.baidubce.services.cdn.model.domain.GetDomainSeoSwitchResponse;
import com.baidubce.services.cdn.model.domain.GetDomainTrafficLimitResponse;
import com.baidubce.services.cdn.model.domain.GetDomainUaAclResponse;
import com.baidubce.services.cdn.model.domain.GetDomainUrlRulesResponse;
import com.baidubce.services.cdn.model.domain.GetIcpResponse;
import com.baidubce.services.cdn.model.domain.GetUserDomainResponse;
import com.baidubce.services.cdn.model.domain.GetUserDomainsRequest;
import com.baidubce.services.cdn.model.domain.SetDomainAccessLimitRequest;
import com.baidubce.services.cdn.model.domain.SetDomainCacheFullUrlRequest;
import com.baidubce.services.cdn.model.domain.SetDomainCacheShareRequest;
import com.baidubce.services.cdn.model.domain.SetDomainCacheTTLRequest;
import com.baidubce.services.cdn.model.domain.SetDomainClientIpRequest;
import com.baidubce.services.cdn.model.domain.SetDomainCompressRequest;
import com.baidubce.services.cdn.model.domain.SetDomainCorsRequest;
import com.baidubce.services.cdn.model.domain.SetDomainErrorPageRequest;
import com.baidubce.services.cdn.model.domain.SetDomainFileTrimRequest;
import com.baidubce.services.cdn.model.domain.SetDomainHSTSRequest;
import com.baidubce.services.cdn.model.domain.SetDomainHttpHeaderRequest;
import com.baidubce.services.cdn.model.domain.SetDomainIPv6DispatchRequest;
import com.baidubce.services.cdn.model.domain.SetDomainIpACLRequest;
import com.baidubce.services.cdn.model.domain.SetDomainLimitBandwidthRequest;
import com.baidubce.services.cdn.model.domain.SetDomainMediaDragRequest;
import com.baidubce.services.cdn.model.domain.SetDomainMobileAccessRequest;
import com.baidubce.services.cdn.model.domain.SetDomainOCSPRequest;
import com.baidubce.services.cdn.model.domain.SetDomainOfflineModeRequest;
import com.baidubce.services.cdn.model.domain.SetDomainOriginFixedIspRequest;
import com.baidubce.services.cdn.model.domain.SetDomainOriginProtocolRequest;
import com.baidubce.services.cdn.model.domain.SetDomainOriginTimeoutRequest;
import com.baidubce.services.cdn.model.domain.SetDomainQUICRequest;
import com.baidubce.services.cdn.model.domain.SetDomainRangeSwitchRequest;
import com.baidubce.services.cdn.model.domain.SetDomainRefererACLRequest;
import com.baidubce.services.cdn.model.domain.SetDomainRetryOriginRequest;
import com.baidubce.services.cdn.model.domain.SetDomainSeoSwitchRequest;
import com.baidubce.services.cdn.model.domain.SetDomainTrafficLimitRequest;
import com.baidubce.services.cdn.model.domain.SetDomainUaAclRequest;
import com.baidubce.services.cdn.model.domain.SetDomainUrlRulesRequest;
import com.baidubce.services.cdn.model.domain.SetRequestAuthRequest;
import com.baidubce.services.cdn.model.dsa.GetDsaDomainListResponse;
import com.baidubce.services.cdn.model.dsa.SetDomainDsaRequest;
import com.baidubce.services.cdn.model.dsa.SetDsaRequest;
import com.baidubce.services.cdn.model.handler.CdnJsonResponseHandler;
import com.baidubce.services.cdn.model.logmodel.GetDomainListLogRequest;
import com.baidubce.services.cdn.model.logmodel.GetDomainListLogResponse;
import com.baidubce.services.cdn.model.stat.GetErrorCodeStatResponse;
import com.baidubce.services.cdn.model.stat.GetIpv6RegionStatResponse;
import com.baidubce.services.cdn.model.stat.GetIpv6StatRequest;
import com.baidubce.services.cdn.model.stat.GetIpv6StatResponse;
import com.baidubce.services.cdn.model.stat.GetMetricStatResponse;
import com.baidubce.services.cdn.model.stat.GetMonth95Request;
import com.baidubce.services.cdn.model.stat.GetMonth95Response;
import com.baidubce.services.cdn.model.stat.GetPackageUsageListRequest;
import com.baidubce.services.cdn.model.stat.GetPackageUsageListResponse;
import com.baidubce.services.cdn.model.stat.GetStatMetricRequest;
import com.baidubce.services.cdn.model.stat.GetStatMetricResponse;
import com.baidubce.services.cdn.model.stat.GetTopStatResponse;
import com.baidubce.services.cdn.model.stat.GetUploadStatRequest;
import com.baidubce.services.cdn.model.stat.GetUploadStatResponse;
import com.baidubce.services.cdn.model.stat.GetXcdnStatMetricRequest;
import com.baidubce.services.cdn.model.stat.GetXcdnStatMetricResponse;
import com.baidubce.services.cdn.model.util.GetForbiddenOperateHistoriesRequest;
import com.baidubce.services.cdn.model.util.GetForbiddenOperateHistoriesResponse;
import com.baidubce.services.cdn.model.util.GetForbiddenQuota;
import com.baidubce.services.cdn.model.util.GetForbiddenUrlsRequest;
import com.baidubce.services.cdn.model.util.GetForbiddenUrlsResponse;
import com.baidubce.services.cdn.model.util.GetNodeListResponse;
import com.baidubce.services.cdn.model.util.SetForbiddenUrlsRequest;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class CdnClient
extends AbstractBceClient {
    private static final String VERSION = "v2";
    private static final String DOMAIN = "domain";
    private static final String STAT = "stat";
    private static final String CACHE = "cache";
    private static final String LOG = "log";
    private static final String UTILS = "utils";
    private static final String USER = "user";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] cdnHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new CdnJsonResponseHandler()};

    public CdnClient() {
        this(new BceClientConfiguration());
    }

    public CdnClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, cdnHandlers);
    }

    public CreateDomainResponse createDomain(CreateDomainRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain());
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CreateDomainResponse.class);
    }

    public EnableDomainResponse enableDomain(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.POST, DOMAIN, domain);
        internalRequest.addParameter("enable", "");
        return this.invokeHttpClient(internalRequest, EnableDomainResponse.class);
    }

    public DisableDomainResponse disableDomain(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.POST, DOMAIN, domain);
        internalRequest.addParameter("disable", "");
        return this.invokeHttpClient(internalRequest, DisableDomainResponse.class);
    }

    public CommonResponse deleteDomain(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.DELETE, DOMAIN, domain);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public ListDomainsResponse listDomains() {
        return this.listDomains(new ListDomainsRequest());
    }

    public ListDomainsResponse listDomains(ListDomainsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN);
        return this.invokeHttpClient(internalRequest, ListDomainsResponse.class);
    }

    public GetUserDomainResponse getUserDomains(String status) {
        return this.getUserDomains(new GetUserDomainsRequest().withStatus(status));
    }

    public GetUserDomainResponse getUserDomains(GetUserDomainsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, USER, "domains");
        internalRequest.addParameter("status", request.getStatus());
        if (request.getRule() != null) {
            internalRequest.addParameter("rule", request.getRule());
        }
        return this.invokeHttpClient(internalRequest, GetUserDomainResponse.class);
    }

    public CheckDomainValidResponse checkDomainValid(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "valid");
        return this.invokeHttpClient(internalRequest, CheckDomainValidResponse.class);
    }

    public GetIcpResponse getIcpStatus(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "icp");
        return this.invokeHttpClient(internalRequest, GetIcpResponse.class);
    }

    public DomainConfigKeysResponse getDomainConfigKeys(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, "config_copy", "list");
        internalRequest.addParameter(DOMAIN, domain);
        return this.invokeHttpClient(internalRequest, DomainConfigKeysResponse.class);
    }

    public CopyDomainTaskResponse copyDomainConfig(String originDomain, List<String> domains, List<String> configNames) {
        return this.copyDomainConfig(new CopyDomainTaskRequest().withOriginDomain(originDomain).withDomains(domains).withConfigs(configNames));
    }

    public CopyDomainTaskResponse copyDomainConfig(CopyDomainTaskRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "config_copy", "submit");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CopyDomainTaskResponse.class);
    }

    public CopyDomainTaskStatusResponse getCopyDomainStatus(String taskId) {
        Validate.checkStringNotEmpty(taskId, "TaskId should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, "config_copy", "status");
        internalRequest.addParameter("taskId", taskId);
        return this.invokeHttpClient(internalRequest, CopyDomainTaskStatusResponse.class);
    }

    public GetDomainConfigResponse getDomainConfig(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        return this.invokeHttpClient(internalRequest, GetDomainConfigResponse.class);
    }

    public CommonResponse setDomainOrigin(SetDomainOriginRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getOrigin(), "Origin should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("origin", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainOriginResponse getDomainOrigin(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("origin", "");
        return this.invokeHttpClient(internalRequest, GetDomainOriginResponse.class);
    }

    public CommonResponse setDomainRangeSwitch(String domain, boolean rangeSwitch) {
        return this.setDomainRangeSwitch(new SetDomainRangeSwitchRequest().withDomain(domain).withRangeSwitch(rangeSwitch));
    }

    public CommonResponse setDomainRangeSwitch(SetDomainRangeSwitchRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("rangeSwitch", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainRangeSwitchResponse getDomainRangeSwitch(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("rangeSwitch", "");
        return this.invokeHttpClient(internalRequest, GetDomainRangeSwitchResponse.class);
    }

    public CommonResponse setDomainClientIp(SetDomainClientIpRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getClientIp(), "ClientIp should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("clientIp", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainClientIpResponse getDomainClientIp(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("clientIp", "");
        return this.invokeHttpClient(internalRequest, GetDomainClientIpResponse.class);
    }

    public CommonResponse setDomainOriginProtocol(SetDomainOriginProtocolRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getOriginProtocol(), "OriginProtocol should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("originProtocol", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainOriginProtocolResponse getDomainOriginProtocol(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("originProtocol", "");
        return this.invokeHttpClient(internalRequest, GetDomainOriginProtocolResponse.class);
    }

    public CommonResponse setDomainRetryOrigin(SetDomainRetryOriginRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        request.setDomain(null);
        internalRequest.addParameter("retryOrigin", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainRetryOriginResponse getDomainRetryOrigin(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("retryOrigin", "");
        return this.invokeHttpClient(internalRequest, GetDomainRetryOriginResponse.class);
    }

    public CommonResponse setDomainOriginTimeout(SetDomainOriginTimeoutRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getOriginTimeout(), "OriginTimeout should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        request.setDomain(null);
        internalRequest.addParameter("originTimeout", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainOriginTimeoutResponse getDomainOriginTimeout(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("originTimeout", "");
        return this.invokeHttpClient(internalRequest, GetDomainOriginTimeoutResponse.class);
    }

    public CommonResponse setDomainOriginFixedISP(SetDomainOriginFixedIspRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getOriginFixedISP(), "OriginFixedISP should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("originFixedISP", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainOriginFixedIspResponse getDomainOriginFixedISP(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("originFixedISP", "");
        return this.invokeHttpClient(internalRequest, GetDomainOriginFixedIspResponse.class);
    }

    public CommonResponse setDomainRefererACL(SetDomainRefererACLRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getRefererACL(), "RefererACL should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("refererACL", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainRefererACLResponse getDomainRefererACL(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("refererACL", "");
        return this.invokeHttpClient(internalRequest, GetDomainRefererACLResponse.class);
    }

    public CommonResponse setDomainIpACL(SetDomainIpACLRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getIpACL(), "IpACL should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("ipACL", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainIpACLResponse getDomainIpACL(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("ipACL", "");
        return this.invokeHttpClient(internalRequest, GetDomainIpACLResponse.class);
    }

    public CommonResponse setDomainCors(SetDomainCorsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getCors(), "Cors should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cors", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainCorsResponse getDomainCors(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("cors", "");
        return this.invokeHttpClient(internalRequest, GetDomainCorsResponse.class);
    }

    public CommonResponse setDomainTrafficLimit(SetDomainTrafficLimitRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getTrafficLimit(), "TrafficLimit should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("trafficLimit", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainTrafficLimitResponse getDomainTrafficLimit(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("trafficLimit", "");
        return this.invokeHttpClient(internalRequest, GetDomainTrafficLimitResponse.class);
    }

    public CommonResponse setDomainRequestAuth(SetRequestAuthRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getRequestAuth(), "RequestAuth should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("requestAuth", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public CommonResponse setDomainAccessLimit(SetDomainAccessLimitRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getAccessLimit(), "AccessLimit should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("accessLimit", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainAccessLimitResponse getDomainAccessLimit(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("accessLimit", "");
        return this.invokeHttpClient(internalRequest, GetDomainAccessLimitResponse.class);
    }

    public CommonResponse setDomainUaAcl(SetDomainUaAclRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getUaAcl(), "UaAcl should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("uaAcl", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainUaAclResponse getDomainUaAcl(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("uaAcl", "");
        return this.invokeHttpClient(internalRequest, GetDomainUaAclResponse.class);
    }

    public CdnResponse setDomainCacheTTL(SetDomainCacheTTLRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getCacheTTL(), "CacheTTL should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cacheTTL", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CdnResponse.class);
    }

    public GetDomainCacheTTLResponse getDomainCacheTTL(String domain) {
        GetDomainCacheTTLRequest request = new GetDomainCacheTTLRequest().withDomain(domain);
        return this.getDomainCacheTTL(request);
    }

    public GetDomainCacheTTLResponse getDomainCacheTTL(GetDomainCacheTTLRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cacheTTL", "");
        return this.invokeHttpClient(internalRequest, GetDomainCacheTTLResponse.class);
    }

    public CommonResponse setDomainCacheFullUrl(SetDomainCacheFullUrlRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getCacheFullUrl(), "CacheFullUrl should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cacheFullUrl", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainCacheFullUrlResponse getDomainCacheFullUrl(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("cacheFullUrl", "");
        return this.invokeHttpClient(internalRequest, GetDomainCacheFullUrlResponse.class);
    }

    public CommonResponse setDomainErrorPage(SetDomainErrorPageRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getErrorPage(), "ErrorPage should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("errorPage", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainErrorPageResponse getDomainErrorPage(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("errorPage", "");
        return this.invokeHttpClient(internalRequest, GetDomainErrorPageResponse.class);
    }

    public CommonResponse setDomainMobileAccess(SetDomainMobileAccessRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be null.");
        Validate.checkNotNull(request.getMobileAccess(), "MobileAccess should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("mobileAccess", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainMobileAccessResponse getDomainMobileAccess(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("mobileAccess", "");
        return this.invokeHttpClient(internalRequest, GetDomainMobileAccessResponse.class);
    }

    public CommonResponse setDomainCacheShare(SetDomainCacheShareRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkNotNull(request.getCacheShare(), "CacheShare should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cacheShare", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainCacheShareResponse getDomainCacheShare(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("cacheShare", "");
        return this.invokeHttpClient(internalRequest, GetDomainCacheShareResponse.class);
    }

    public CommonResponse setDomainUrlRules(SetDomainUrlRulesRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkNotNull(request.getUrlRules(), "UrlRules should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        request.setDomain(null);
        internalRequest.addParameter("urlRules", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainUrlRulesResponse getDomainUrlRules(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("urlRules", "");
        return this.invokeHttpClient(internalRequest, GetDomainUrlRulesResponse.class);
    }

    public CommonResponse setDomainHttpHeader(SetDomainHttpHeaderRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkNotNull(request.getHttpHeader(), "HttpHeader should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("httpHeader", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainHttpHeaderResponse getDomainHttpHeader(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("httpHeader", "");
        return this.invokeHttpClient(internalRequest, GetDomainHttpHeaderResponse.class);
    }

    public CommonResponse setDomainSeoSwitch(SetDomainSeoSwitchRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkNotNull(request.getSeoSwitch(), "SeoSwitch should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("seoSwitch", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainSeoSwitchResponse getDomainSeoSwitch(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("seoSwitch", "");
        return this.invokeHttpClient(internalRequest, GetDomainSeoSwitchResponse.class);
    }

    public CommonResponse setDomainMediaDrag(SetDomainMediaDragRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkNotNull(request.getMediaDragConf(), "MediaDragConf should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("mediaDrag", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainMediaDragResponse getDomainMediaDrag(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("mediaDrag", "");
        return this.invokeHttpClient(internalRequest, GetDomainMediaDragResponse.class);
    }

    public void setDomainFileTrim(String domain, boolean fileTrim) {
        this.setDomainFileTrim(new SetDomainFileTrimRequest().withDomain(domain).withFileTrim(fileTrim));
    }

    public CommonResponse setDomainFileTrim(SetDomainFileTrimRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("fileTrim", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainFileTrimResponse getDomainFileTrim(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("fileTrim", "");
        return this.invokeHttpClient(internalRequest, GetDomainFileTrimResponse.class);
    }

    public CommonResponse setDomainCompress(SetDomainCompressRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkNotNull(request.getCompress(), "Compress should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("compress", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainCompressResponse getDomainCompress(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("compress", "");
        return this.invokeHttpClient(internalRequest, GetDomainCompressResponse.class);
    }

    public CommonResponse setDomainQUICSwitch(String domain, boolean quic) {
        return this.setDomainQUICSwitch(new SetDomainQUICRequest().withDomain(domain).withQuic(quic));
    }

    public CommonResponse setDomainQUICSwitch(SetDomainQUICRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("quic", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainQUICSwitchResponse getDomainQUICSwitch(String domain) {
        Validate.checkNotNull(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("quic", "");
        return this.invokeHttpClient(internalRequest, GetDomainQUICSwitchResponse.class);
    }

    public CommonResponse setDomainIPv6Dispatch(SetDomainIPv6DispatchRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("ipv6Dispatch", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainIPv6DispatchResponse getDomainIPv6Dispatch(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("ipv6Dispatch", "");
        return this.invokeHttpClient(internalRequest, GetDomainIPv6DispatchResponse.class);
    }

    public CommonResponse setDomainOfflineModeSwitch(String domain, boolean offlineMode) {
        return this.setDomainOfflineModeSwitch(new SetDomainOfflineModeRequest().withDomain(domain).withOfflineMode(offlineMode));
    }

    public CommonResponse setDomainOfflineModeSwitch(SetDomainOfflineModeRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("offlineMode", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainOfflineModeSwitchResponse getDomainOfflineModeSwitch(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("offlineMode", "");
        return this.invokeHttpClient(internalRequest, GetDomainOfflineModeSwitchResponse.class);
    }

    public CommonResponse setDomainLimitBandwidth(SetDomainLimitBandwidthRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkNotNull(request.getLimitBandwidth(), "LimitBandwidth should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("limitBandwidth", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainLimitBandwidthResponse getDomainLimitBandwidth(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("limitBandwidth", "");
        return this.invokeHttpClient(internalRequest, GetDomainLimitBandwidthResponse.class);
    }

    public CommonResponse setDomainHttpsConfig(SetDomainHttpsConfigRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("https", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public CommonResponse setDomainHSTS(SetDomainHSTSRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkNotNull(request.getHSTS(), "HSTS should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        request.setDomain(null);
        internalRequest.addParameter("hsts", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainHSTSResponse getDomainHSTS(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("hsts", "");
        return this.invokeHttpClient(internalRequest, GetDomainHSTSResponse.class);
    }

    public CommonResponse setDomainOCSPSwitch(String domain, boolean ocsp) {
        return this.setDomainOCSPSwitch(new SetDomainOCSPRequest().withDomain(domain).withOcsp(ocsp));
    }

    public CommonResponse setDomainOCSPSwitch(SetDomainOCSPRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("ocsp", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainOCSPSwitchResponse getDomainOCSPSwitch(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, DOMAIN, domain, "config");
        internalRequest.addParameter("ocsp", "");
        return this.invokeHttpClient(internalRequest, GetDomainOCSPSwitchResponse.class);
    }

    public SetDomainCertResponse setDomainCert(SetDomainCertRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getCertificate(), "Certificate should NOT be null.");
        Validate.checkStringNotEmpty(request.getHttpsEnable(), "HttpsEnable should NOT be empty.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getDomain(), "certificates");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, SetDomainCertResponse.class);
    }

    public GetDomainCertResponse getDomainCert(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, domain, "certificates");
        return this.invokeHttpClient(internalRequest, GetDomainCertResponse.class);
    }

    public CdnResponse deleteDomainCert(String domain) {
        Validate.checkStringNotEmpty(domain, "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.DELETE, domain, "certificates");
        return this.invokeHttpClient(internalRequest, CdnResponse.class);
    }

    public GetHttpsDomainResponse getHttpsDomains(GetHttpsDomainRequest request) {
        if (request == null) {
            request = new GetHttpsDomainRequest();
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "httpsDomains");
        if (request.getCertCommonName() != null) {
            internalRequest.addParameter("certCommonName", request.getCertCommonName());
        }
        if (request.getCertId() != null) {
            internalRequest.addParameter("certId", request.getCertId());
        }
        if (request.getCertName() != null) {
            internalRequest.addParameter("certName", request.getCertName());
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", request.getPageNo().toString());
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", request.getPageSize().toString());
        }
        if (request.getStatus() != null) {
            internalRequest.addParameter("status", request.getStatus().toString());
        }
        return this.invokeHttpClient(internalRequest, GetHttpsDomainResponse.class);
    }

    public SetDomainCertResponse bathUploadDomainCert(BatchUploadCertRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getCertificate(), "Certificate should NOT be null.");
        Validate.checkNotNull(request.getDomains(), "Domains should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DOMAIN, "certificate");
        internalRequest.addParameter("action", "put");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, SetDomainCertResponse.class);
    }

    public PurgeResponse purge(String url) {
        return this.purge(new PurgeRequest().addTask(new PurgeTask().withUrl(url)));
    }

    public PurgeResponse purgeDirectory(String directory) {
        return this.purge(new PurgeRequest().addTask(new PurgeTask().withDirectory(directory)));
    }

    public PurgeResponse purge(PurgeRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getTasks(), "Task should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CACHE, "purge");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, PurgeResponse.class);
    }

    public GetPurgeStatusResponse getPurgeStatus(GetPurgeStatusRequest request) {
        if (request == null) {
            request = new GetPurgeStatusRequest();
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CACHE, "purge");
        if (request.getId() != null) {
            internalRequest.addParameter("id", request.getId());
        }
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getUrl() != null) {
            internalRequest.addParameter("url", request.getUrl());
        }
        return this.invokeHttpClient(internalRequest, GetPurgeStatusResponse.class);
    }

    public GetCacheQuotaResponse getCacheQuota() {
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, CACHE, "quota");
        return this.invokeHttpClient(internalRequest, GetCacheQuotaResponse.class);
    }

    public PrefetchResponse prefetch(String url) {
        return this.prefetch(new PrefetchRequest().addTask(new PrefetchTask().withUrl(url)));
    }

    public PrefetchResponse prefetch(PrefetchRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getTasks(), "Task should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CACHE, "prefetch");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, PrefetchResponse.class);
    }

    public GetPrefetchStatusResponse getPrefetchStatus(GetPrefetchStatusRequest request) {
        if (request == null) {
            request = new GetPrefetchStatusRequest();
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CACHE, "prefetch");
        if (request.getId() != null) {
            internalRequest.addParameter("id", request.getId());
        }
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getUrl() != null) {
            internalRequest.addParameter("url", request.getUrl());
        }
        return this.invokeHttpClient(internalRequest, GetPrefetchStatusResponse.class);
    }

    public GetDomainLogResponse getDomainLog(String domain, Date startTime, Date endTime) {
        Validate.checkNotNull(domain, "The parameter request should NOT be null.");
        Validate.checkNotNull(startTime, "StartTime should NOT be null.");
        Validate.checkNotNull(endTime, "EndTime should NOT be null.");
        CdnRequest request = new CdnRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, LOG, domain, LOG);
        internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(startTime));
        internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(endTime));
        return this.invokeHttpClient(internalRequest, GetDomainLogResponse.class);
    }

    public GetDomainLogResponse getDomainLog(String domain, String startTime, String endTime) {
        Validate.checkNotNull(domain, "The parameter request should NOT be null.");
        Validate.checkNotNull(startTime, "StartTime should NOT be null.");
        Validate.checkNotNull(endTime, "EndTime should NOT be null.");
        CdnRequest request = new CdnRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, LOG, domain, LOG);
        internalRequest.addParameter("startTime", startTime);
        internalRequest.addParameter("endTime", endTime);
        return this.invokeHttpClient(internalRequest, GetDomainLogResponse.class);
    }

    public GetDomainListLogResponse getDomainListLog(GetDomainListLogRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getStartTime(), "StartTime should NOT be null.");
        Validate.checkNotNull(request.getEndTime(), "EndTime should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, LOG, "list");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, GetDomainListLogResponse.class);
    }

    public GetMetricStatResponse getStatMetricData(GetStatMetricRequest request) {
        GetStatMetricResponse statMetricData = this.getStatMetricDefaultData(request);
        return JsonUtils.fromJsonString(JsonUtils.toJsonString(statMetricData), GetMetricStatResponse.class);
    }

    public GetStatMetricResponse getStatMetricDefaultData(GetStatMetricRequest request) {
        byte[] content;
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getMetric(), "Metric should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, STAT, "query");
        try {
            content = JsonUtils.toJsonString(request).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("utf-8 encoding not supported!", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(content.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(content));
        return this.invokeHttpClient(internalRequest, GetStatMetricResponse.class);
    }

    public GetMonth95Response getMonth95Data(GetMonth95Request request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getType(), "Type should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "billing");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, GetMonth95Response.class);
    }

    public GetTopStatResponse getTopStatData(GetStatMetricRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getMetric(), "Metric should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, STAT, "query");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, GetTopStatResponse.class);
    }

    public GetIpv6StatResponse getStatIpv6Data(GetIpv6StatRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, STAT, "ipv6");
        internalRequest.addParameter("stat_type", request.getStatType() == null ? "all" : request.getStatType());
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, GetIpv6StatResponse.class);
    }

    public GetIpv6RegionStatResponse getStatRegionIpv6Data(GetIpv6StatRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, STAT, "ipv6");
        internalRequest.addParameter("stat_type", "region");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, GetIpv6RegionStatResponse.class);
    }

    public GetErrorCodeStatResponse getErrorCodeStatData(GetStatMetricRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        GetStatMetricResponse statMetricData = this.getStatMetricDefaultData(request.withMetric("error"));
        return JsonUtils.fromJsonString(JsonUtils.toJsonString(statMetricData), GetErrorCodeStatResponse.class);
    }

    public GetUploadStatResponse getUploadStatData(GetUploadStatRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, STAT, "upload_detail");
        internalRequest.addParameter("type", request.getType() == null ? "all" : request.getType());
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, GetUploadStatResponse.class);
    }

    public GetUploadStatResponse getUploadPeakStatData(GetUploadStatRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        if (!(request.getType() == null || "peak".equals(request.getType()) || "95_peak".equals(request.getType()) || "day_peak".equals(request.getType()))) {
            throw new IllegalArgumentException("Type Error");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, STAT, "upload_peak");
        if (request.getType() != null) {
            internalRequest.addParameter("type", request.getType() == null ? "peak" : request.getType());
        }
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, GetUploadStatResponse.class);
    }

    public GetXcdnStatMetricResponse getXcdnStatData(GetXcdnStatMetricRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getMetric(), "Metric should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "xcdn", STAT, "query");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, GetXcdnStatMetricResponse.class);
    }

    public DescribeIpResponse describeIp(String ip) {
        return this.describeIp(new DescribeIpRequest().withIp(ip));
    }

    public DescribeIpResponse describeIp(DescribeIpRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getIp(), "IP should NOT be null.");
        Validate.checkStringNotEmpty(request.getAction(), "ACTION should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, UTILS);
        internalRequest.addParameter("action", request.getAction());
        internalRequest.addParameter("ip", request.getIp());
        return this.invokeHttpClient(internalRequest, DescribeIpResponse.class);
    }

    public DescribeIpsResponse describeIps(DescribeIpRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkMultyParamsNotBothEmpty(request.getIps(), "IPs should NOT be null.");
        Validate.checkStringNotEmpty(request.getAction(), "ACTION should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, UTILS, "ips");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, DescribeIpsResponse.class);
    }

    public GetNodeListResponse getNodeList() {
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, "nodes", "list");
        return this.invokeHttpClient(internalRequest, GetNodeListResponse.class);
    }

    public GetForbiddenQuota getForbiddenQuota() {
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, "firewalls", "forbidden", "quota");
        return this.invokeHttpClient(internalRequest, GetForbiddenQuota.class);
    }

    public GetForbiddenUrlsResponse getForbiddenUrls(GetForbiddenUrlsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, "firewalls", "forbidden", "urls");
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        internalRequest.addParameter("orderBy", request.getOrderBy());
        if (request.getUrl() != null) {
            internalRequest.addParameter("url", request.getUrl());
        }
        return this.invokeHttpClient(internalRequest, GetForbiddenUrlsResponse.class);
    }

    public GetForbiddenOperateHistoriesResponse getForbiddenOperateHistories(GetForbiddenOperateHistoriesRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(new CdnRequest(), HttpMethodName.GET, "firewalls", "forbidden", "operateHistories");
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        internalRequest.addParameter("orderBy", request.getOrderBy());
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", request.getStartTime());
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", request.getEndTime());
        }
        if (request.getUrl() != null) {
            internalRequest.addParameter("url", request.getUrl());
        }
        return this.invokeHttpClient(internalRequest, GetForbiddenOperateHistoriesResponse.class);
    }

    public CdnResponse setForbiddenBan(SetForbiddenUrlsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getUrls(), "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "firewalls", "forbidden", "ban");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CdnResponse.class);
    }

    public CdnResponse setForbiddenUnBan(SetForbiddenUrlsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getUrls(), "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "firewalls", "forbidden", "unban");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CdnResponse.class);
    }

    public GetPackageUsageListResponse getPackageUsageList(GetPackageUsageListRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "package", "usagelist");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, GetPackageUsageListResponse.class);
    }

    public CdnResponse setDsa(SetDsaRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getAction(), "Action should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "dsa");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CdnResponse.class);
    }

    public GetDsaDomainListResponse getDsaDomainList() {
        CdnRequest request = new CdnRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "dsa", DOMAIN);
        return this.invokeHttpClient(internalRequest, GetDsaDomainListResponse.class);
    }

    public void setDomainDsa(SetDomainDsaRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("dsa", "");
        this.attachRequestToBody(request, internalRequest);
        this.invokeHttpClient(internalRequest, CdnResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void attachRequestToBody(AbstractBceRequest request, InternalRequest httpRequest) {
        byte[] content;
        try {
            content = JsonUtils.toJsonString(request).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("utf-8 encoding not supported!", e);
        }
        httpRequest.addHeader("Content-Length", String.valueOf(content.length));
        httpRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setContent(RestartableInputStream.wrap(content));
    }

    private void validateAndFillRequestUrl(InternalRequest internalRequest, String type, Date startTime, Date endTime, String url, String marker) {
        if (type != null) {
            internalRequest.addParameter("type", type);
        }
        if (startTime != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(startTime));
        }
        if (endTime != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(endTime));
        }
        if (url != null) {
            internalRequest.addParameter("url", url);
        }
        if (marker != null) {
            internalRequest.addParameter("marker", String.valueOf(marker));
        }
    }
}

