/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotdm;

import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

class IotDmClientHelper {
    private static final String VERSION = "v1";
    private static final String VERSION_V2 = "v2";
    private static final String VERSION_V3 = "v3";
    private static final String IOT = "iot";
    private static final String MANAGEMENT = "management";
    private static final String ENDPOINT = "endpoint";
    private static final String RULES = "rules";
    private static final String[] HEADERS_TO_SIGN = new String[]{"Host", "x-bce-date"};
    private static final String CONTENT_TYPE = "application/json;charset=UTF-8";
    static final HttpResponseHandler[] IOT_DM_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    IotDmClientHelper() {
    }

    static InternalRequest createRequestForV1(AbstractBceRequest bceRequest, HttpMethodName httpMethod, URI endpoint, SignOptions signOptions, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.addAll(Arrays.asList(VERSION, IOT, MANAGEMENT));
        return IotDmClientHelper.createRequest(bceRequest, httpMethod, endpoint, signOptions, path, pathVariables);
    }

    static InternalRequest createRequestForV2(AbstractBceRequest bceRequest, HttpMethodName httpMethod, URI endpoint, SignOptions signOptions, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.addAll(Arrays.asList(VERSION_V2, IOT, MANAGEMENT, ENDPOINT));
        return IotDmClientHelper.createRequest(bceRequest, httpMethod, endpoint, signOptions, path, pathVariables);
    }

    static InternalRequest createRequestForV3(AbstractBceRequest bceRequest, HttpMethodName httpMethod, URI endpoint, SignOptions signOptions, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.addAll(Arrays.asList(VERSION_V3, IOT, MANAGEMENT));
        return IotDmClientHelper.createRequest(bceRequest, httpMethod, endpoint, signOptions, path, pathVariables);
    }

    static InternalRequest createRequestForRules(AbstractBceRequest bceRequest, HttpMethodName httpMethod, URI endpoint, SignOptions signOptions, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.addAll(Arrays.asList(VERSION_V3, IOT, RULES));
        return IotDmClientHelper.createRequest(bceRequest, httpMethod, endpoint, signOptions, path, pathVariables);
    }

    private static InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, URI endpoint, SignOptions signOptions, List<String> path, String ... pathVariables) {
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        if (signOptions == null) {
            signOptions = SignOptions.DEFAULT;
            signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        }
        URI uri = HttpUtils.appendUri(endpoint, path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        if (httpMethod == HttpMethodName.PUT || httpMethod == HttpMethodName.POST) {
            IotDmClientHelper.fillInHeaderAndBody(bceRequest, request);
        }
        return request;
    }

    private static void fillInHeaderAndBody(AbstractBceRequest bceRequest, InternalRequest request) {
        byte[] content = IotDmClientHelper.toJson(bceRequest);
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", CONTENT_TYPE);
        request.setContent(RestartableInputStream.wrap(content));
    }

    private static byte[] toJson(AbstractBceRequest request) {
        String jsonStr = JsonUtils.toJsonString(request);
        try {
            return jsonStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
    }
}

