/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothisk.model;

import com.baidubce.services.iothisk.model.IotPkiManageRequest;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;

public class BatchCreateClientCertRequest
extends IotPkiManageRequest {
    private String groupId;
    private List<String> deviceIds;
    private int duration;
    private String csrs;

    public static BatchCreateClientCertRequest create(String groupId, int duration, Map<String, String> deviceIdAndCsr) throws Exception {
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull(deviceIdAndCsr);
        BatchCreateClientCertRequest request = new BatchCreateClientCertRequest().withGroupId(groupId).withDuration(duration);
        ArrayList<String> deviceIds = new ArrayList<String>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        for (Map.Entry<String, String> deviceIdAndCsrEntry : deviceIdAndCsr.entrySet()) {
            deviceIds.add(deviceIdAndCsrEntry.getKey());
            byte[] certContent = deviceIdAndCsrEntry.getValue().getBytes();
            zipOutputStream.putNextEntry(new ZipEntry(deviceIdAndCsrEntry.getKey()));
            zipOutputStream.write(certContent, 0, certContent.length);
            zipOutputStream.closeEntry();
        }
        zipOutputStream.finish();
        zipOutputStream.close();
        request.setCsrs(Base64.encodeBase64String((byte[])byteArrayOutputStream.toByteArray()));
        request.setDeviceIds(deviceIds);
        return request;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public BatchCreateClientCertRequest withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public List<String> getDeviceIds() {
        return this.deviceIds;
    }

    public void setDeviceIds(List<String> deviceIds) {
        this.deviceIds = deviceIds;
    }

    public BatchCreateClientCertRequest withDeviceIds(List<String> deviceIds) {
        this.deviceIds = deviceIds;
        return this;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public BatchCreateClientCertRequest withDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public String getCsrs() {
        return this.csrs;
    }

    public void setCsrs(String csrs) {
        this.csrs = csrs;
    }

    public BatchCreateClientCertRequest withCsrs(String csrs) {
        this.csrs = csrs;
        return this;
    }
}

