/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.tablestorage.model.ListKeyRangesResponse;
import com.baidubce.services.tablestorage.model.transform.Unmarshaller;
import com.baidubce.services.tablestorage.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ListKeyRangesResponseUnmarshaller
implements Unmarshaller<ListKeyRangesResponse, InputStream> {
    private ListKeyRangesResponse result;

    public ListKeyRangesResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (ListKeyRangesResponse)response;
    }

    @Override
    public ListKeyRangesResponse unmarshall(InputStream in) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(in);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (!root.isObject()) {
            throw new BceClientException("The input json object:" + root.toString() + " is not an object.");
        }
        JsonNode keyRangesObj = root.get("keyRanges");
        ArrayList<Pair<String, String>> keyRanges = new ArrayList<Pair<String, String>>();
        if (keyRangesObj != null) {
            Iterator keyRangeList = keyRangesObj.elements();
            while (keyRangeList.hasNext()) {
                JsonNode table = (JsonNode)keyRangeList.next();
                String startKey = table.get("startKey").asText();
                String stopKey = table.get("endKey").asText();
                keyRanges.add((Pair<String, String>)new ImmutablePair((Object)startKey, (Object)stopKey));
            }
        }
        this.result.setKeyRanges(keyRanges);
        return this.result;
    }
}

