/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bes.model;

import com.baidubce.services.bes.model.AbstractBesRequest;
import com.baidubce.services.bes.model.DiskSlotInfo;
import com.baidubce.services.bes.model.ModuleType;
import com.baidubce.services.bes.model.PaymentType;
import com.baidubce.services.bes.model.SlotType;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;

public class BesCreateClusterRequest
extends AbstractBesRequest {
    @JsonProperty
    private String name;
    @JsonProperty
    private String password;
    @JsonProperty
    private List<ModuleInfo> modules;
    @JsonProperty
    private String version;
    @JsonProperty
    private String availableZone;
    @JsonProperty
    private String securityGroupId;
    @JsonProperty
    private String subnetUuid;
    @JsonProperty
    private String vpcId;
    @JsonProperty
    private ClusterBilling billing;
    @JsonProperty
    private boolean isOldPackage;

    public boolean isOldPackage() {
        return this.isOldPackage;
    }

    public void setOldPackage(boolean oldPackage) {
        this.isOldPackage = oldPackage;
    }

    public ClusterBilling getBilling() {
        return this.billing;
    }

    public void setBilling(ClusterBilling billing) {
        this.billing = billing;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<ModuleInfo> getModules() {
        return this.modules;
    }

    public void setModules(List<ModuleInfo> modules) {
        this.modules = modules;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAvailableZone() {
        return this.availableZone;
    }

    public void setAvailableZone(String availableZone) {
        this.availableZone = availableZone;
    }

    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    public void setSecurityGroupId(String securityGroupId) {
        this.securityGroupId = securityGroupId;
    }

    public String getSubnetUuid() {
        return this.subnetUuid;
    }

    public void setSubnetUuid(String subnetUuid) {
        this.subnetUuid = subnetUuid;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String toJson() throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(stringWriter);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("name", this.name);
        jsonGenerator.writeStringField("password", this.password);
        jsonGenerator.writeArrayFieldStart("modules");
        for (ModuleInfo module : this.modules) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("type", module.getType());
            jsonGenerator.writeNumberField("instanceNum", module.getInstanceNum());
            jsonGenerator.writeStringField("slotType", module.getSlotType());
            if (module.getDiskSlotInfo() != null) {
                jsonGenerator.writeObjectFieldStart("diskSlotInfo");
                jsonGenerator.writeStringField("type", module.getDiskSlotInfo().getType());
                jsonGenerator.writeNumberField("size", module.getDiskSlotInfo().getSize());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeObjectFieldStart("billing");
        jsonGenerator.writeStringField("paymentType", this.billing.getPaymentType());
        jsonGenerator.writeNumberField("time", this.billing.getTime());
        jsonGenerator.writeEndObject();
        jsonGenerator.writeStringField("version", this.version);
        jsonGenerator.writeBooleanField("isOpenService", false);
        jsonGenerator.writeBooleanField("isOldPackage", this.isOldPackage);
        jsonGenerator.writeStringField("availableZone", this.availableZone);
        jsonGenerator.writeStringField("securityGroupId", this.securityGroupId);
        jsonGenerator.writeStringField("subnetUuid", this.subnetUuid);
        jsonGenerator.writeStringField("vpcId", this.vpcId);
        jsonGenerator.writeStringField("serviceType", "BES");
        jsonGenerator.writeEndObject();
        jsonGenerator.close();
        return stringWriter.toString();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ClusterBilling {
        @JsonProperty
        private String paymentType;
        @JsonProperty
        private int time;

        public String getPaymentType() {
            return this.paymentType;
        }

        public void setPaymentType(PaymentType paymentType) {
            this.setPaymentType(paymentType.getPaymentType());
        }

        public void setPaymentType(String paymentType) {
            this.paymentType = paymentType;
        }

        public int getTime() {
            return this.time;
        }

        public void setTime(int time) {
            this.time = time;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModuleInfo {
        @JsonProperty
        private String type;
        @JsonProperty
        private int instanceNum;
        @JsonProperty
        private String slotType;
        @JsonProperty
        private DiskSlotInfo diskSlotInfo;

        public String getSlotType() {
            return this.slotType;
        }

        public void setSlotType(SlotType slotType) {
            this.setSlotType(slotType.getSlotType());
        }

        public void setSlotType(String slotType) {
            this.slotType = slotType;
        }

        public DiskSlotInfo getDiskSlotInfo() {
            return this.diskSlotInfo;
        }

        public void setDiskSlotInfo(DiskSlotInfo diskSlotInfo) {
            this.diskSlotInfo = diskSlotInfo;
        }

        public int getInstanceNum() {
            return this.instanceNum;
        }

        public void setInstanceNum(int instanceNum) {
            this.instanceNum = instanceNum;
        }

        public String getType() {
            return this.type;
        }

        public void setType(ModuleType type) {
            this.setType(type.getModuleType());
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

