/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.eni;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.eni.EniClientConfiguration;
import com.baidubce.services.eni.model.CreateEniRequest;
import com.baidubce.services.eni.model.CreateEniResponse;
import com.baidubce.services.eni.model.DeleteEniRequest;
import com.baidubce.services.eni.model.EniAction;
import com.baidubce.services.eni.model.EniBindEipRequest;
import com.baidubce.services.eni.model.EniDetail;
import com.baidubce.services.eni.model.EniInstanceOperateRequest;
import com.baidubce.services.eni.model.EniPrivateIpBatchAddRequest;
import com.baidubce.services.eni.model.EniPrivateIpBatchOperateRequest;
import com.baidubce.services.eni.model.EniPrivateIpOperateRequest;
import com.baidubce.services.eni.model.EniUnBindEipRequest;
import com.baidubce.services.eni.model.EniUpdateEnterpriseSecurityGroupRequest;
import com.baidubce.services.eni.model.EniUpdateRequest;
import com.baidubce.services.eni.model.EniUpdateSecurityGroupRequest;
import com.baidubce.services.eni.model.GetEniDetailRequest;
import com.baidubce.services.eni.model.ListEniRequest;
import com.baidubce.services.eni.model.ListEniResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EniClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EniClient.class);
    private static final String VERSION = "v1";
    private static final String ENI_PREFIX = "eni";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String MARKER = "marker";
    private static final String MAX_KEYS = "maxKeys";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String NAME_MESSAGE_KEY = "name";
    private static final String SUBNET_ID_MESSAGE_KEY = "subnetId";
    private static final String ENI_ID_MESSAGE_KEY = "eniId";
    private static final String SG_AND_ESG_IDS_EMPTY_MESSAGE = "securityGroupIds and enterpriseSecurityGroupIds cannot be empty at the same time";
    private static final String SG_AND_ESG_IDS_BOTH_HAVE_VALUES_MESSAGE = "securityGroupIds and enterpriseSecurityGroupIds cannot have values at the same time";
    private static final String SECURITY_GROUP_IDS_MESSAGE = "request securityGroupIds should not be null or empty.";
    private static final String ENTERPRISE_SECURITY_GROUP_IDS_MESSAGE = "request enterpriseSecurityGroupIds should not be null or empty.";
    private static final String PRIVATE_IP_SET_MESSAGE = "request privateIpSet should not be null or empty.";
    private static final String PRIVATE_IP_ADDRESSES_AND_COUNT_MESSAGE = "request privateIpAddresses and privateIpAddressCount should not be neither null or empty.";
    private static final String PRIVATE_IP_ADDRESSES_MESSAGE = "request privateIpAddresses should not be null or empty.";
    private static final String VPC_ID_MESSAGE_KEY = "vpcId";
    private static final String INSTANCE_ID_MESSAGE_KEY = "instanceId";
    private static final String PRIVATE_IP_ADDRESS_MESSAGE_KEY = "privateIpAddress";
    private static final String PUBLIC_IP_ADDRESS_MESSAGE_KEY = "publicIpAddress";
    private static final HttpResponseHandler[] ENI_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public EniClient() {
        this(new EniClientConfiguration());
    }

    public EniClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, ENI_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    public CreateEniResponse createEni(CreateEniRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSubnetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SUBNET_ID_MESSAGE_KEY));
        if (CollectionUtils.isEmpty(request.getSecurityGroupIds()) && CollectionUtils.isEmpty(request.getEnterpriseSecurityGroupIds())) {
            throw new IllegalArgumentException(SG_AND_ESG_IDS_EMPTY_MESSAGE);
        }
        if (!CollectionUtils.isEmpty(request.getSecurityGroupIds()) && !CollectionUtils.isEmpty(request.getEnterpriseSecurityGroupIds())) {
            throw new IllegalArgumentException(SG_AND_ESG_IDS_BOTH_HAVE_VALUES_MESSAGE);
        }
        if (CollectionUtils.isEmpty(request.getPrivateIpSet())) {
            throw new IllegalArgumentException(PRIVATE_IP_SET_MESSAGE);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ENI_PREFIX);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateEniResponse.class);
    }

    public void updateEni(EniUpdateRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (Strings.isNullOrEmpty((String)request.getAction())) {
            request.setAction("modifyAttribute");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ENI_PREFIX, request.getEniId());
        internalRequest.addParameter(EniAction.modifyAttribute.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteEni(DeleteEniRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, ENI_PREFIX, request.getEniId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteEni(String eniId) {
        this.deleteEni(DeleteEniRequest.builder().eniId(eniId).build());
    }

    public ListEniResponse listEni(ListEniRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVpcId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VPC_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ENI_PREFIX);
        internalRequest.addParameter(VPC_ID_MESSAGE_KEY, request.getVpcId());
        if (!Strings.isNullOrEmpty((String)request.getInstanceId())) {
            internalRequest.addParameter(INSTANCE_ID_MESSAGE_KEY, request.getInstanceId());
        }
        if (!Strings.isNullOrEmpty((String)request.getName())) {
            internalRequest.addParameter(NAME_MESSAGE_KEY, request.getName());
        }
        if (!CollectionUtils.isEmpty(request.getPrivateIpAddress())) {
            List<String> privateIpAddress = request.getPrivateIpAddress();
            StringBuilder sb = new StringBuilder();
            sb.append(privateIpAddress.get(0));
            for (int i = 1; i < privateIpAddress.size(); ++i) {
                sb.append(",");
                sb.append(privateIpAddress.get(i));
            }
            internalRequest.addParameter(PRIVATE_IP_ADDRESS_MESSAGE_KEY, sb.toString());
        }
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        } else if (request.getMaxKeys() <= 0) {
            internalRequest.addParameter(MAX_KEYS, "1000");
        }
        return this.invokeHttpClient(internalRequest, ListEniResponse.class);
    }

    public EniDetail getEniDetail(GetEniDetailRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ENI_PREFIX, request.getEniId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, EniDetail.class);
    }

    public void addPrivateIp(EniPrivateIpOperateRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)request.getPrivateIpAddress(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(PRIVATE_IP_ADDRESS_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ENI_PREFIX, request.getEniId(), "privateIp");
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deletePrivateIp(EniPrivateIpOperateRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getPrivateIpAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat(PRIVATE_IP_ADDRESS_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, ENI_PREFIX, request.getEniId(), "privateIp", request.getPrivateIpAddress());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void batchAddPrivateIp(EniPrivateIpBatchAddRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (request.getPrivateIpAddressCount() == null && CollectionUtils.isEmpty(request.getPrivateIpAddresses())) {
            throw new IllegalArgumentException(PRIVATE_IP_ADDRESSES_AND_COUNT_MESSAGE);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ENI_PREFIX, request.getEniId(), "privateIp/batchAdd");
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void batchDeletePrivateIp(EniPrivateIpBatchOperateRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (CollectionUtils.isEmpty(request.getPrivateIpAddresses())) {
            throw new IllegalArgumentException(PRIVATE_IP_ADDRESSES_MESSAGE);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ENI_PREFIX, request.getEniId(), "privateIp/batchDel");
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void attachEniInstance(EniInstanceOperateRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCE_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (Strings.isNullOrEmpty((String)request.getAction())) {
            request.setAction(EniAction.attach.name());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ENI_PREFIX, request.getEniId());
        internalRequest.addParameter(request.getAction(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void detachEniInstance(EniInstanceOperateRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCE_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (Strings.isNullOrEmpty((String)request.getAction())) {
            request.setAction(EniAction.detach.name());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ENI_PREFIX, request.getEniId());
        internalRequest.addParameter(request.getAction(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void bindEniPublicIp(EniBindEipRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getPrivateIpAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat(PRIVATE_IP_ADDRESS_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getPublicIpAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat(PUBLIC_IP_ADDRESS_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (Strings.isNullOrEmpty((String)request.getAction())) {
            request.setAction(EniAction.bind.name());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ENI_PREFIX, request.getEniId());
        internalRequest.addParameter(request.getAction(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unBindEniPublicIp(EniUnBindEipRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getPublicIpAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat(PUBLIC_IP_ADDRESS_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (Strings.isNullOrEmpty((String)request.getAction())) {
            request.setAction(EniAction.unbind.name());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ENI_PREFIX, request.getEniId());
        internalRequest.addParameter(request.getAction(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateEniSecurityGroup(EniUpdateSecurityGroupRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        if (CollectionUtils.isEmpty(request.getSecurityGroupIds())) {
            throw new IllegalArgumentException(SECURITY_GROUP_IDS_MESSAGE);
        }
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (Strings.isNullOrEmpty((String)request.getAction())) {
            request.setAction(EniAction.bindSg.name());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ENI_PREFIX, request.getEniId());
        internalRequest.addParameter(request.getAction(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateEniEnterpriseSecurityGroup(EniUpdateEnterpriseSecurityGroupRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEniId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENI_ID_MESSAGE_KEY));
        if (CollectionUtils.isEmpty(request.getEnterpriseSecurityGroupIds())) {
            throw new IllegalArgumentException(ENTERPRISE_SECURITY_GROUP_IDS_MESSAGE);
        }
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (Strings.isNullOrEmpty((String)request.getAction())) {
            request.setAction(EniAction.bindEsg.name());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ENI_PREFIX, request.getEniId());
        internalRequest.addParameter(request.getAction(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }
}

