/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.internal;

import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

public class BaseRequest {
    private static final String DEFAULT_PROTOCOL_PREFIX = "http://";
    private HttpMethodName httpMethod;
    private String path;
    private Map<String, String> parameters = Maps.newHashMap();
    private Map<String, String> headers = Maps.newHashMap();

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public HttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethodName httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public BaseRequest(HttpMethodName httpMethod, String path, Map<String, String> parameters, Map<String, String> headers) {
        this.httpMethod = httpMethod;
        this.path = path;
        this.parameters = parameters;
        this.headers = headers;
    }

    public static InternalRequest toInternalRequest(BaseRequest request) {
        String host;
        Map<String, String> headers = request.getHeaders();
        if (headers.containsKey("Host")) {
            host = headers.get("Host");
        } else {
            host = headers.get("Host".toLowerCase());
            headers.remove("Host".toLowerCase());
        }
        URI uri = URI.create(DEFAULT_PROTOCOL_PREFIX + host + request.getPath());
        InternalRequest res = new InternalRequest(request.getHttpMethod(), uri);
        res.setParameters(request.getParameters());
        res.setHeaders(headers);
        return res;
    }
}

