/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.blb;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.blb.BlbClientConfiguration;
import com.baidubce.services.blb.model.AddBackendServersRequest;
import com.baidubce.services.blb.model.BSAction;
import com.baidubce.services.blb.model.BackendServer;
import com.baidubce.services.blb.model.BlbListenerAction;
import com.baidubce.services.blb.model.BlbListenerRequest;
import com.baidubce.services.blb.model.CreateBlbRequest;
import com.baidubce.services.blb.model.CreateBlbResponse;
import com.baidubce.services.blb.model.DeleteBSRequest;
import com.baidubce.services.blb.model.DeleteBlbRequest;
import com.baidubce.services.blb.model.DeleteListenerRequest;
import com.baidubce.services.blb.model.HttpListener;
import com.baidubce.services.blb.model.HttpsListener;
import com.baidubce.services.blb.model.ListBackendServerRequest;
import com.baidubce.services.blb.model.ListBackendServerResponse;
import com.baidubce.services.blb.model.ListBackendServerStatusRequest;
import com.baidubce.services.blb.model.ListBackendServerStatusResponse;
import com.baidubce.services.blb.model.ListBlbRequest;
import com.baidubce.services.blb.model.ListBlbResponse;
import com.baidubce.services.blb.model.ListListenerRequest;
import com.baidubce.services.blb.model.ListListenerResponse;
import com.baidubce.services.blb.model.ListenerConstant;
import com.baidubce.services.blb.model.ModifyBSAttributesRequest;
import com.baidubce.services.blb.model.ModifyBlbAttributesRequest;
import com.baidubce.services.blb.model.TcpListener;
import com.baidubce.services.blb.model.UdpListener;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class BlbClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String PREFIX = "blb";
    private static final String CLIENT_TOKEN_IDENTIFY = "clientToken";
    private static final HttpResponseHandler[] blbHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public BlbClient() {
        this(new BlbClientConfiguration());
    }

    public BlbClient(BlbClientConfiguration clientConfiguration) {
        super(clientConfiguration, blbHandlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreateBlbResponse createBlb(String name, String desc, String vpcId, String subnetId) {
        return this.createBlb(new CreateBlbRequest().withName(name).withDesc(desc).withVpcId(vpcId).withSubnetId(subnetId));
    }

    public CreateBlbResponse createBlb(CreateBlbRequest createBlbRequest) {
        Preconditions.checkNotNull((Object)createBlbRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)createBlbRequest.getClientToken())) {
            createBlbRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(createBlbRequest, HttpMethodName.POST, PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, createBlbRequest.getClientToken());
        this.fillPayload(internalRequest, createBlbRequest);
        return this.invokeHttpClient(internalRequest, CreateBlbResponse.class);
    }

    public ListBlbResponse listBlbs(String address, String name, String blbId, String bccId) {
        return this.listBlbs(new ListBlbRequest().withAddress(address).withName(name).withBlbId(blbId).withBccId(bccId));
    }

    public ListBlbResponse listBlbs(ListBlbRequest listBlbRequest) {
        Preconditions.checkNotNull((Object)listBlbRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(listBlbRequest, HttpMethodName.GET, PREFIX);
        if (StringUtils.isNotEmpty((CharSequence)listBlbRequest.getAddress())) {
            internalRequest.addParameter("address", listBlbRequest.getAddress());
        }
        if (StringUtils.isNotEmpty((CharSequence)listBlbRequest.getName())) {
            internalRequest.addParameter("name", listBlbRequest.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)listBlbRequest.getBlbId())) {
            internalRequest.addParameter("blbId", listBlbRequest.getBlbId());
        }
        if (StringUtils.isNotEmpty((CharSequence)listBlbRequest.getBccId())) {
            internalRequest.addParameter("bccId", listBlbRequest.getBccId());
        }
        if (listBlbRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listBlbRequest.getMarker());
        }
        if (listBlbRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listBlbRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListBlbResponse.class);
    }

    public void modifyBlbAttributes(String blbId, String name, String desc) {
        this.modifyBlbAttributes(new ModifyBlbAttributesRequest(blbId, name, desc));
    }

    public void modifyBlbAttributes(ModifyBlbAttributesRequest modifyBlbAttributesRequest) {
        Preconditions.checkNotNull((Object)modifyBlbAttributesRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(modifyBlbAttributesRequest.getBlbId(), "request blbId should not be null.");
        if (Strings.isNullOrEmpty((String)modifyBlbAttributesRequest.getClientToken())) {
            modifyBlbAttributesRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(modifyBlbAttributesRequest, HttpMethodName.PUT, PREFIX, modifyBlbAttributesRequest.getBlbId());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, modifyBlbAttributesRequest.getClientToken());
        this.fillPayload(internalRequest, modifyBlbAttributesRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteBlb(String blbId) {
        this.deleteBlb(new DeleteBlbRequest(blbId));
    }

    public void deleteBlb(DeleteBlbRequest deleteBlbRequest) {
        Preconditions.checkNotNull((Object)deleteBlbRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)deleteBlbRequest.getClientToken())) {
            deleteBlbRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(deleteBlbRequest, HttpMethodName.DELETE, PREFIX, deleteBlbRequest.getBlbId());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, deleteBlbRequest.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void createListener(BlbListenerRequest blbListenerRequest) {
        Preconditions.checkNotNull((Object)blbListenerRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)blbListenerRequest.getClientToken())) {
            blbListenerRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)blbListenerRequest.getType(), (Object)"listener type should not be null.");
        if (!ListenerConstant.LISTENER_SET.contains(blbListenerRequest.getType())) {
            throw new IllegalArgumentException("listener type is illegal.");
        }
        InternalRequest internalRequest = this.createRequest(blbListenerRequest, HttpMethodName.POST, PREFIX, blbListenerRequest.getBlbId(), blbListenerRequest.getType() + "listener");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, blbListenerRequest.getClientToken());
        this.fillPayload(internalRequest, blbListenerRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListListenerResponse<TcpListener> listTcpListener(String blbId) {
        return this.listListener(new ListListenerRequest().withBlbId(blbId).withType("TCP"));
    }

    public ListListenerResponse<UdpListener> listUdpListener(String blbId) {
        return this.listListener(new ListListenerRequest().withBlbId(blbId).withType("UDP"));
    }

    public ListListenerResponse<HttpListener> listHttpListener(String blbId) {
        return this.listListener(new ListListenerRequest().withBlbId(blbId).withType("HTTP"));
    }

    public ListListenerResponse<HttpsListener> listHttpsListener(String blbId) {
        return this.listListener(new ListListenerRequest().withBlbId(blbId).withType("HTTPS"));
    }

    public ListListenerResponse listListener(ListListenerRequest listListenerRequest) {
        Preconditions.checkNotNull((Object)listListenerRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)listListenerRequest.getType(), (Object)"listener type should not be null.");
        if (!ListenerConstant.LISTENER_SET.contains(listListenerRequest.getType())) {
            throw new IllegalArgumentException("listener type is illegal.");
        }
        InternalRequest internalRequest = this.createRequest(listListenerRequest, HttpMethodName.GET, PREFIX, listListenerRequest.getBlbId(), listListenerRequest.getType() + "listener");
        if (listListenerRequest.getListenerPort() != 0) {
            internalRequest.addParameter("listenerPort", String.valueOf(listListenerRequest.getListenerPort()));
        }
        if (listListenerRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listListenerRequest.getMarker());
        }
        if (listListenerRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listListenerRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListListenerResponse.class);
    }

    public void modifyListenerAttributes(BlbListenerRequest modifyListenerAttributesRequest) {
        Preconditions.checkNotNull((Object)modifyListenerAttributesRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)modifyListenerAttributesRequest.getClientToken())) {
            modifyListenerAttributesRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)modifyListenerAttributesRequest.getType(), (Object)"listener type should not be null.");
        if (!ListenerConstant.LISTENER_SET.contains(modifyListenerAttributesRequest.getType())) {
            throw new IllegalArgumentException("listener type is illegal.");
        }
        InternalRequest internalRequest = this.createRequest(modifyListenerAttributesRequest, HttpMethodName.PUT, PREFIX, modifyListenerAttributesRequest.getBlbId(), modifyListenerAttributesRequest.getType() + "listener");
        internalRequest.addParameter("listenerPort", String.valueOf(modifyListenerAttributesRequest.getListenerPort()));
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, modifyListenerAttributesRequest.getClientToken());
        this.fillPayload(internalRequest, modifyListenerAttributesRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteListener(String blbId, List<Integer> portList) {
        this.deleteListener(new DeleteListenerRequest(blbId, portList));
    }

    public void deleteListener(DeleteListenerRequest deleteListenerRequest) {
        Preconditions.checkNotNull((Object)deleteListenerRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)deleteListenerRequest.getClientToken())) {
            deleteListenerRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(deleteListenerRequest, HttpMethodName.PUT, PREFIX, deleteListenerRequest.getBlbId(), "listener");
        internalRequest.addParameter(BlbListenerAction.batchdelete.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, deleteListenerRequest.getClientToken());
        this.fillPayload(internalRequest, deleteListenerRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void addBackendServers(String blbId, List<BackendServer> backendServerList) {
        this.addBackendServers(new AddBackendServersRequest(blbId, backendServerList));
    }

    public void addBackendServers(AddBackendServersRequest addBackendServersRequest) {
        Preconditions.checkNotNull((Object)addBackendServersRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)addBackendServersRequest.getClientToken())) {
            addBackendServersRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(addBackendServersRequest, HttpMethodName.POST, PREFIX, addBackendServersRequest.getBlbId(), "backendserver");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, addBackendServersRequest.getClientToken());
        this.fillPayload(internalRequest, addBackendServersRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListBackendServerStatusResponse listBackendServerStatus(String blbId, int listenerPort) {
        return this.listBackendServerStatus(new ListBackendServerStatusRequest(blbId, listenerPort));
    }

    public ListBackendServerStatusResponse listBackendServerStatus(ListBackendServerStatusRequest listBackendServerStatusRequest) {
        Preconditions.checkNotNull((Object)listBackendServerStatusRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(listBackendServerStatusRequest, HttpMethodName.GET, PREFIX, listBackendServerStatusRequest.getBlbId(), "backendserver");
        internalRequest.addParameter("listenerPort", String.valueOf(listBackendServerStatusRequest.getListenerPort()));
        if (listBackendServerStatusRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listBackendServerStatusRequest.getMarker());
        }
        if (listBackendServerStatusRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listBackendServerStatusRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListBackendServerStatusResponse.class);
    }

    public ListBackendServerResponse listBackendServers(String blbId) {
        return this.listBackendServers(new ListBackendServerRequest(blbId));
    }

    public ListBackendServerResponse listBackendServers(ListBackendServerRequest listBackendServerRequest) {
        Preconditions.checkNotNull((Object)listBackendServerRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(listBackendServerRequest, HttpMethodName.GET, PREFIX, listBackendServerRequest.getBlbId(), "backendserver");
        if (listBackendServerRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listBackendServerRequest.getMarker());
        }
        if (listBackendServerRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listBackendServerRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListBackendServerResponse.class);
    }

    public void modifyBackendServerAttributes(String blbId, List<BackendServer> backendServerList) {
        this.modifyBackendServerAttributes(new ModifyBSAttributesRequest(blbId, backendServerList));
    }

    public void modifyBackendServerAttributes(ModifyBSAttributesRequest modifyBSAttributesRequest) {
        Preconditions.checkNotNull((Object)modifyBSAttributesRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)modifyBSAttributesRequest.getClientToken())) {
            modifyBSAttributesRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(modifyBSAttributesRequest, HttpMethodName.PUT, PREFIX, modifyBSAttributesRequest.getBlbId(), "backendserver");
        internalRequest.addParameter(BSAction.update.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, modifyBSAttributesRequest.getClientToken());
        this.fillPayload(internalRequest, modifyBSAttributesRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteBackendServers(String blbId, List<String> backendServerList) {
        this.deleteBackendServers(new DeleteBSRequest(blbId, backendServerList));
    }

    public void deleteBackendServers(DeleteBSRequest deleteBSRequest) {
        Preconditions.checkNotNull((Object)deleteBSRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)deleteBSRequest.getClientToken())) {
            deleteBSRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(deleteBSRequest, HttpMethodName.PUT, PREFIX, deleteBSRequest.getBlbId(), "backendserver");
        this.fillPayload(internalRequest, deleteBSRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }
}

