/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotdmp.model.device;

import com.baidubce.model.GenericAccountRequest;
import com.baidubce.services.iotdmp.model.device.AlgorithmType;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuthRequest
extends GenericAccountRequest {
    @NonNull
    private String signature;
    @NonNull
    private Long expiryTime;
    private AlgorithmType algorithmType;

    public static AuthRequestBuilder builder() {
        return new AuthRequestBuilder();
    }

    @NonNull
    public String getSignature() {
        return this.signature;
    }

    @NonNull
    public Long getExpiryTime() {
        return this.expiryTime;
    }

    public AlgorithmType getAlgorithmType() {
        return this.algorithmType;
    }

    public void setSignature(@NonNull String signature) {
        if (signature == null) {
            throw new NullPointerException("signature is marked @NonNull but is null");
        }
        this.signature = signature;
    }

    public void setExpiryTime(@NonNull Long expiryTime) {
        if (expiryTime == null) {
            throw new NullPointerException("expiryTime is marked @NonNull but is null");
        }
        this.expiryTime = expiryTime;
    }

    public void setAlgorithmType(AlgorithmType algorithmType) {
        this.algorithmType = algorithmType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthRequest)) {
            return false;
        }
        AuthRequest other = (AuthRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        Long this$expiryTime = this.getExpiryTime();
        Long other$expiryTime = other.getExpiryTime();
        if (this$expiryTime == null ? other$expiryTime != null : !((Object)this$expiryTime).equals(other$expiryTime)) {
            return false;
        }
        AlgorithmType this$algorithmType = this.getAlgorithmType();
        AlgorithmType other$algorithmType = other.getAlgorithmType();
        return !(this$algorithmType == null ? other$algorithmType != null : !((Object)((Object)this$algorithmType)).equals((Object)other$algorithmType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        Long $expiryTime = this.getExpiryTime();
        result = result * 59 + ($expiryTime == null ? 43 : ((Object)$expiryTime).hashCode());
        AlgorithmType $algorithmType = this.getAlgorithmType();
        result = result * 59 + ($algorithmType == null ? 43 : ((Object)((Object)$algorithmType)).hashCode());
        return result;
    }

    public String toString() {
        return "AuthRequest(signature=" + this.getSignature() + ", expiryTime=" + this.getExpiryTime() + ", algorithmType=" + (Object)((Object)this.getAlgorithmType()) + ")";
    }

    public AuthRequest(@NonNull String signature, @NonNull Long expiryTime, AlgorithmType algorithmType) {
        if (signature == null) {
            throw new NullPointerException("signature is marked @NonNull but is null");
        }
        if (expiryTime == null) {
            throw new NullPointerException("expiryTime is marked @NonNull but is null");
        }
        this.signature = signature;
        this.expiryTime = expiryTime;
        this.algorithmType = algorithmType;
    }

    public AuthRequest(@NonNull String signature, @NonNull Long expiryTime) {
        if (signature == null) {
            throw new NullPointerException("signature is marked @NonNull but is null");
        }
        if (expiryTime == null) {
            throw new NullPointerException("expiryTime is marked @NonNull but is null");
        }
        this.signature = signature;
        this.expiryTime = expiryTime;
    }

    public static class AuthRequestBuilder {
        private String signature;
        private Long expiryTime;
        private AlgorithmType algorithmType;

        AuthRequestBuilder() {
        }

        public AuthRequestBuilder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public AuthRequestBuilder expiryTime(Long expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public AuthRequestBuilder algorithmType(AlgorithmType algorithmType) {
            this.algorithmType = algorithmType;
            return this;
        }

        public AuthRequest build() {
            return new AuthRequest(this.signature, this.expiryTime, this.algorithmType);
        }

        public String toString() {
            return "AuthRequest.AuthRequestBuilder(signature=" + this.signature + ", expiryTime=" + this.expiryTime + ", algorithmType=" + (Object)((Object)this.algorithmType) + ")";
        }
    }
}

