/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.localdns;

import com.baidubce.BceClientConfiguration;
import com.baidubce.common.ApiInfo;
import com.baidubce.common.BaseBceClient;
import com.baidubce.common.BaseBceResponse;
import com.baidubce.common.BceRegion;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.localdns.api.LdApi;
import com.baidubce.services.localdns.model.AddRecordRequest;
import com.baidubce.services.localdns.model.AddRecordResponse;
import com.baidubce.services.localdns.model.BindVpcRequest;
import com.baidubce.services.localdns.model.CreatePrivateZoneRequest;
import com.baidubce.services.localdns.model.CreatePrivateZoneResponse;
import com.baidubce.services.localdns.model.GetPrivateZoneResponse;
import com.baidubce.services.localdns.model.ListPrivateZoneResponse;
import com.baidubce.services.localdns.model.ListRecordResponse;
import com.baidubce.services.localdns.model.UnbindVpcRequest;
import com.baidubce.services.localdns.model.UpdateRecordRequest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class LdClient
extends BaseBceClient {
    private static final Map<BceRegion, String> ENDPOINTS = ImmutableMap.builder().put((Object)BceRegion.BJ, (Object)"http://privatezone.baidubce.com").build();
    private static final String SERVICE_ID = "Ld";
    private static final Map<String, ApiInfo> LD_APIS = LdApi.getApis();

    public LdClient(String ak, String sk, BceRegion region) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get((Object)region));
    }

    public LdClient(String ak, String sk) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get((Object)BceRegion.DEFAULT));
    }

    public LdClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    public AddRecordResponse addRecord(String zoneId, AddRecordRequest body, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LD_APIS.get("addRecord"));
        String apiPath = apiInfo.getPath().withPathParameter("zoneId", zoneId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, AddRecordResponse.class);
    }

    public void bindVpc(String zoneId, BindVpcRequest body, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LD_APIS.get("bindVpc"));
        String apiPath = apiInfo.getPath().withPathParameter("zoneId", zoneId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public CreatePrivateZoneResponse createPrivateZone(CreatePrivateZoneRequest body, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LD_APIS.get("createPrivateZone"));
        String apiPath = apiInfo.getPath().get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, CreatePrivateZoneResponse.class);
    }

    public void deletePrivateZone(String zoneId, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LD_APIS.get("deletePrivateZone"));
        String apiPath = apiInfo.getPath().withPathParameter("zoneId", zoneId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void deleteRecord(String recordId, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LD_APIS.get("deleteRecord"));
        String apiPath = apiInfo.getPath().withPathParameter("recordId", recordId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void disableRecord(String recordId, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LD_APIS.get("disableRecord"));
        String apiPath = apiInfo.getPath().withPathParameter("recordId", recordId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void enableRecord(String recordId, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LD_APIS.get("enableRecord"));
        String apiPath = apiInfo.getPath().withPathParameter("recordId", recordId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public GetPrivateZoneResponse getPrivateZone(String zoneId) {
        ApiInfo apiInfo = new ApiInfo(LD_APIS.get("getPrivateZone"));
        String apiPath = apiInfo.getPath().withPathParameter("zoneId", zoneId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, GetPrivateZoneResponse.class);
    }

    public ListPrivateZoneResponse listPrivateZone(String marker, Integer maxKeys) {
        ApiInfo apiInfo = new ApiInfo(LD_APIS.get("listPrivateZone"));
        String apiPath = apiInfo.getPath().get();
        apiInfo.getQueries().put("marker", marker);
        apiInfo.getQueries().put("maxKeys", String.valueOf(maxKeys));
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListPrivateZoneResponse.class);
    }

    public ListRecordResponse listRecord(String zoneId) {
        ApiInfo apiInfo = new ApiInfo(LD_APIS.get("listRecord"));
        String apiPath = apiInfo.getPath().withPathParameter("zoneId", zoneId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListRecordResponse.class);
    }

    public void unbindVpc(String zoneId, UnbindVpcRequest body, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LD_APIS.get("unbindVpc"));
        String apiPath = apiInfo.getPath().withPathParameter("zoneId", zoneId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void updateRecord(String recordId, UpdateRecordRequest body, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(LD_APIS.get("updateRecord"));
        String apiPath = apiInfo.getPath().withPathParameter("recordId", recordId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }
}

