/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tsdb.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.tsdb.model.RenewTimeUnit;
import com.baidubce.services.tsdb.utils.QuotaCalculator;
import com.baidubce.util.Validate;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;

public class CreateDatabaseRequest
extends AbstractBceRequest {
    @NonNull
    private String databaseName;
    private String description;
    private long ingestDataPointsMonthly;
    private long queryUnitsMonthly;
    private long storeBytesQuota;
    private long timeSeriesQuota;
    private int lengthLimitMultipleQuota;
    private int purchaseLength;
    private boolean createWithAutoRenew;
    private int renewTime;
    @NonNull
    private RenewTimeUnit renewTimeUnit;
    private String couponName;

    public CreateDatabaseRequest(String databaseName, String description, long ingestDataPointsMonthly, long queryUnitsMonthly, long storeBytesQuota, long timeSeriesQuota, int lengthLimitMultipleQuota, int purchaseLength, boolean createWithAutoRenew, int renewTime, RenewTimeUnit renewTimeUnit, String couponName) {
        Validate.checkIsTrue(ingestDataPointsMonthly > 0L && ingestDataPointsMonthly % 1000000L == 0L, "Illegal quota of ingest, must be greater than 0 and be multiple of INGEST_QUOTA_UNIT(1 million).");
        Validate.checkIsTrue(queryUnitsMonthly >= 100000L && queryUnitsMonthly % 10000L == 0L, "Illegal quota of query, must be not less than 100 thousand and be multiple of QUERY_QUOTA_UNIT(100 thousand).");
        Validate.checkIsTrue(storeBytesQuota >= 0L && storeBytesQuota % 0x40000000L == 0L, "Illegal quota of storage, must be non-negative and be multiple of STORAGE_QUOTA_UNIT(1G).");
        if (timeSeriesQuota <= 0L) {
            timeSeriesQuota = QuotaCalculator.getTimeSeriesQuota(ingestDataPointsMonthly);
        }
        if (ingestDataPointsMonthly < 1000000000L) {
            Validate.checkIsTrue(timeSeriesQuota == QuotaCalculator.getTimeSeriesQuota(ingestDataPointsMonthly), String.format("Illegal quota of timeseries, must be consistent with the result of the QuotaCalculator, excepted %s but got %s.", QuotaCalculator.getTimeSeriesQuota(ingestDataPointsMonthly), timeSeriesQuota));
        } else {
            Validate.checkIsTrue(timeSeriesQuota >= QuotaCalculator.getTimeSeriesQuota(ingestDataPointsMonthly) && timeSeriesQuota % 1000000L == 0L, "Illegal quota of timeseries, must be multiple of ADDITIONAL_TIMESERIES_QUOTA(1 million).");
        }
        if (storeBytesQuota > 0L && lengthLimitMultipleQuota == 0) {
            lengthLimitMultipleQuota = 1;
        }
        Validate.checkIsTrue(storeBytesQuota == 0L && lengthLimitMultipleQuota == 0 || storeBytesQuota > 0L && lengthLimitMultipleQuota > 0, "Illegal quota of lengthLimitMultipleQuota, must be consistent with the storage bytes quota.");
        this.databaseName = databaseName;
        this.description = description;
        this.ingestDataPointsMonthly = ingestDataPointsMonthly;
        this.queryUnitsMonthly = queryUnitsMonthly;
        this.storeBytesQuota = storeBytesQuota;
        this.timeSeriesQuota = timeSeriesQuota;
        this.lengthLimitMultipleQuota = lengthLimitMultipleQuota;
        this.purchaseLength = purchaseLength;
        this.createWithAutoRenew = createWithAutoRenew;
        this.renewTime = Math.max(renewTime, 1);
        this.renewTimeUnit = (RenewTimeUnit)((Object)ObjectUtils.defaultIfNull((Object)((Object)renewTimeUnit), (Object)((Object)RenewTimeUnit.MONTH)));
        this.couponName = couponName;
    }

    @Override
    public CreateDatabaseRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public static CreateDatabaseRequestBuilder builder() {
        return new CreateDatabaseRequestBuilder();
    }

    @NonNull
    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDescription() {
        return this.description;
    }

    public long getIngestDataPointsMonthly() {
        return this.ingestDataPointsMonthly;
    }

    public long getQueryUnitsMonthly() {
        return this.queryUnitsMonthly;
    }

    public long getStoreBytesQuota() {
        return this.storeBytesQuota;
    }

    public long getTimeSeriesQuota() {
        return this.timeSeriesQuota;
    }

    public int getLengthLimitMultipleQuota() {
        return this.lengthLimitMultipleQuota;
    }

    public int getPurchaseLength() {
        return this.purchaseLength;
    }

    public boolean isCreateWithAutoRenew() {
        return this.createWithAutoRenew;
    }

    public int getRenewTime() {
        return this.renewTime;
    }

    @NonNull
    public RenewTimeUnit getRenewTimeUnit() {
        return this.renewTimeUnit;
    }

    public String getCouponName() {
        return this.couponName;
    }

    public void setDatabaseName(@NonNull String databaseName) {
        if (databaseName == null) {
            throw new NullPointerException("databaseName is marked @NonNull but is null");
        }
        this.databaseName = databaseName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIngestDataPointsMonthly(long ingestDataPointsMonthly) {
        this.ingestDataPointsMonthly = ingestDataPointsMonthly;
    }

    public void setQueryUnitsMonthly(long queryUnitsMonthly) {
        this.queryUnitsMonthly = queryUnitsMonthly;
    }

    public void setStoreBytesQuota(long storeBytesQuota) {
        this.storeBytesQuota = storeBytesQuota;
    }

    public void setTimeSeriesQuota(long timeSeriesQuota) {
        this.timeSeriesQuota = timeSeriesQuota;
    }

    public void setLengthLimitMultipleQuota(int lengthLimitMultipleQuota) {
        this.lengthLimitMultipleQuota = lengthLimitMultipleQuota;
    }

    public void setPurchaseLength(int purchaseLength) {
        this.purchaseLength = purchaseLength;
    }

    public void setCreateWithAutoRenew(boolean createWithAutoRenew) {
        this.createWithAutoRenew = createWithAutoRenew;
    }

    public void setRenewTime(int renewTime) {
        this.renewTime = renewTime;
    }

    public void setRenewTimeUnit(@NonNull RenewTimeUnit renewTimeUnit) {
        if (renewTimeUnit == null) {
            throw new NullPointerException("renewTimeUnit is marked @NonNull but is null");
        }
        this.renewTimeUnit = renewTimeUnit;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateDatabaseRequest)) {
            return false;
        }
        CreateDatabaseRequest other = (CreateDatabaseRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        if (this.getIngestDataPointsMonthly() != other.getIngestDataPointsMonthly()) {
            return false;
        }
        if (this.getQueryUnitsMonthly() != other.getQueryUnitsMonthly()) {
            return false;
        }
        if (this.getStoreBytesQuota() != other.getStoreBytesQuota()) {
            return false;
        }
        if (this.getTimeSeriesQuota() != other.getTimeSeriesQuota()) {
            return false;
        }
        if (this.getLengthLimitMultipleQuota() != other.getLengthLimitMultipleQuota()) {
            return false;
        }
        if (this.getPurchaseLength() != other.getPurchaseLength()) {
            return false;
        }
        if (this.isCreateWithAutoRenew() != other.isCreateWithAutoRenew()) {
            return false;
        }
        if (this.getRenewTime() != other.getRenewTime()) {
            return false;
        }
        RenewTimeUnit this$renewTimeUnit = this.getRenewTimeUnit();
        RenewTimeUnit other$renewTimeUnit = other.getRenewTimeUnit();
        if (this$renewTimeUnit == null ? other$renewTimeUnit != null : !((Object)((Object)this$renewTimeUnit)).equals((Object)other$renewTimeUnit)) {
            return false;
        }
        String this$couponName = this.getCouponName();
        String other$couponName = other.getCouponName();
        return !(this$couponName == null ? other$couponName != null : !this$couponName.equals(other$couponName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateDatabaseRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        long $ingestDataPointsMonthly = this.getIngestDataPointsMonthly();
        result = result * 59 + (int)($ingestDataPointsMonthly >>> 32 ^ $ingestDataPointsMonthly);
        long $queryUnitsMonthly = this.getQueryUnitsMonthly();
        result = result * 59 + (int)($queryUnitsMonthly >>> 32 ^ $queryUnitsMonthly);
        long $storeBytesQuota = this.getStoreBytesQuota();
        result = result * 59 + (int)($storeBytesQuota >>> 32 ^ $storeBytesQuota);
        long $timeSeriesQuota = this.getTimeSeriesQuota();
        result = result * 59 + (int)($timeSeriesQuota >>> 32 ^ $timeSeriesQuota);
        result = result * 59 + this.getLengthLimitMultipleQuota();
        result = result * 59 + this.getPurchaseLength();
        result = result * 59 + (this.isCreateWithAutoRenew() ? 79 : 97);
        result = result * 59 + this.getRenewTime();
        RenewTimeUnit $renewTimeUnit = this.getRenewTimeUnit();
        result = result * 59 + ($renewTimeUnit == null ? 43 : ((Object)((Object)$renewTimeUnit)).hashCode());
        String $couponName = this.getCouponName();
        result = result * 59 + ($couponName == null ? 43 : $couponName.hashCode());
        return result;
    }

    public String toString() {
        return "CreateDatabaseRequest(databaseName=" + this.getDatabaseName() + ", description=" + this.getDescription() + ", ingestDataPointsMonthly=" + this.getIngestDataPointsMonthly() + ", queryUnitsMonthly=" + this.getQueryUnitsMonthly() + ", storeBytesQuota=" + this.getStoreBytesQuota() + ", timeSeriesQuota=" + this.getTimeSeriesQuota() + ", lengthLimitMultipleQuota=" + this.getLengthLimitMultipleQuota() + ", purchaseLength=" + this.getPurchaseLength() + ", createWithAutoRenew=" + this.isCreateWithAutoRenew() + ", renewTime=" + this.getRenewTime() + ", renewTimeUnit=" + (Object)((Object)this.getRenewTimeUnit()) + ", couponName=" + this.getCouponName() + ")";
    }

    public static class CreateDatabaseRequestBuilder {
        private String databaseName;
        private String description;
        private long ingestDataPointsMonthly;
        private long queryUnitsMonthly;
        private long storeBytesQuota;
        private long timeSeriesQuota;
        private int lengthLimitMultipleQuota;
        private int purchaseLength;
        private boolean createWithAutoRenew;
        private int renewTime;
        private RenewTimeUnit renewTimeUnit;
        private String couponName;

        CreateDatabaseRequestBuilder() {
        }

        public CreateDatabaseRequestBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public CreateDatabaseRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public CreateDatabaseRequestBuilder ingestDataPointsMonthly(long ingestDataPointsMonthly) {
            this.ingestDataPointsMonthly = ingestDataPointsMonthly;
            return this;
        }

        public CreateDatabaseRequestBuilder queryUnitsMonthly(long queryUnitsMonthly) {
            this.queryUnitsMonthly = queryUnitsMonthly;
            return this;
        }

        public CreateDatabaseRequestBuilder storeBytesQuota(long storeBytesQuota) {
            this.storeBytesQuota = storeBytesQuota;
            return this;
        }

        public CreateDatabaseRequestBuilder timeSeriesQuota(long timeSeriesQuota) {
            this.timeSeriesQuota = timeSeriesQuota;
            return this;
        }

        public CreateDatabaseRequestBuilder lengthLimitMultipleQuota(int lengthLimitMultipleQuota) {
            this.lengthLimitMultipleQuota = lengthLimitMultipleQuota;
            return this;
        }

        public CreateDatabaseRequestBuilder purchaseLength(int purchaseLength) {
            this.purchaseLength = purchaseLength;
            return this;
        }

        public CreateDatabaseRequestBuilder createWithAutoRenew(boolean createWithAutoRenew) {
            this.createWithAutoRenew = createWithAutoRenew;
            return this;
        }

        public CreateDatabaseRequestBuilder renewTime(int renewTime) {
            this.renewTime = renewTime;
            return this;
        }

        public CreateDatabaseRequestBuilder renewTimeUnit(RenewTimeUnit renewTimeUnit) {
            this.renewTimeUnit = renewTimeUnit;
            return this;
        }

        public CreateDatabaseRequestBuilder couponName(String couponName) {
            this.couponName = couponName;
            return this;
        }

        public CreateDatabaseRequest build() {
            return new CreateDatabaseRequest(this.databaseName, this.description, this.ingestDataPointsMonthly, this.queryUnitsMonthly, this.storeBytesQuota, this.timeSeriesQuota, this.lengthLimitMultipleQuota, this.purchaseLength, this.createWithAutoRenew, this.renewTime, this.renewTimeUnit, this.couponName);
        }

        public String toString() {
            return "CreateDatabaseRequest.CreateDatabaseRequestBuilder(databaseName=" + this.databaseName + ", description=" + this.description + ", ingestDataPointsMonthly=" + this.ingestDataPointsMonthly + ", queryUnitsMonthly=" + this.queryUnitsMonthly + ", storeBytesQuota=" + this.storeBytesQuota + ", timeSeriesQuota=" + this.timeSeriesQuota + ", lengthLimitMultipleQuota=" + this.lengthLimitMultipleQuota + ", purchaseLength=" + this.purchaseLength + ", createWithAutoRenew=" + this.createWithAutoRenew + ", renewTime=" + this.renewTime + ", renewTimeUnit=" + (Object)((Object)this.renewTimeUnit) + ", couponName=" + this.couponName + ")";
        }
    }
}

