/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.http.handler;

import com.baidubce.BceErrorResponse;
import com.baidubce.BceServiceException;
import com.baidubce.http.BceHttpResponse;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.util.JsonUtils;
import java.io.InputStream;

public class BceErrorResponseHandler
implements HttpResponseHandler {
    @Override
    public boolean handle(BceHttpResponse httpResponse, AbstractBceResponse response) throws Exception {
        if (httpResponse.getStatusCode() / 100 == 2) {
            return false;
        }
        BceServiceException bse = null;
        InputStream content = httpResponse.getContent();
        if (content != null) {
            BceErrorResponse bceErrorResponse = JsonUtils.loadFrom(content, BceErrorResponse.class);
            if (bceErrorResponse.getMessage() != null) {
                bse = new BceServiceException(bceErrorResponse.getMessage());
                bse.setErrorCode(bceErrorResponse.getCode());
                bse.setRequestId(bceErrorResponse.getRequestId());
            }
            content.close();
        }
        if (bse == null) {
            bse = new BceServiceException(httpResponse.getStatusText());
            bse.setRequestId(response.getMetadata().getBceRequestId());
        }
        bse.setStatusCode(httpResponse.getStatusCode());
        if (bse.getStatusCode() >= 500) {
            bse.setErrorType(BceServiceException.ErrorType.Service);
        } else {
            bse.setErrorType(BceServiceException.ErrorType.Client);
        }
        throw bse;
    }
}

