/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bmr.model;

import com.baidubce.services.bmr.model.ApplicationConfig;

public class HBaseApplicationConfig
extends ApplicationConfig {
    private static final String HBASE_APPLICATION = "hbase";
    private static final String BACKUP_ENABLED = "backupEnabled";
    private static final String BACKUP_LOCATION = "backupLocation";
    private static final String BACKUP_INTERVAL_IN_MINUTES = "backupIntervalInMinutes";
    private static final String BACKUP_START_DATETIME = "backupStartDateTime";
    private static final String RESTORE_ENABLED = "restoreEnabled";
    private static final String RESTORE_LOCATION = "restoreLocation";
    private static final String RESTORE_VERSION = "restoreVersion";

    public HBaseApplicationConfig() {
        this.setName(HBASE_APPLICATION);
    }

    public HBaseApplicationConfig withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public HBaseApplicationConfig withBackupEnabled(boolean backupEnabled) {
        this.addProperty(BACKUP_ENABLED, backupEnabled);
        return this;
    }

    public HBaseApplicationConfig withBackupLocation(String backupLocation) {
        this.addProperty(BACKUP_LOCATION, backupLocation);
        return this;
    }

    public HBaseApplicationConfig withBackupIntervalInMinutes(int minutes) {
        this.addProperty(BACKUP_INTERVAL_IN_MINUTES, minutes);
        return this;
    }

    public HBaseApplicationConfig withBackupStartDatetime(String startDatetime) {
        this.addProperty(BACKUP_START_DATETIME, startDatetime);
        return this;
    }

    public HBaseApplicationConfig withRestoreEnabled(boolean restoreEnabled) {
        this.addProperty(RESTORE_ENABLED, restoreEnabled);
        return this;
    }

    public HBaseApplicationConfig withRestoreLocation(String restoreLocation) {
        this.addProperty(RESTORE_LOCATION, restoreLocation);
        return this;
    }

    public HBaseApplicationConfig withRestoreVersion(String restoreVersion) {
        this.addProperty(RESTORE_VERSION, restoreVersion);
        return this;
    }
}

