/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.services.bos.model.GenericUploadRequest;
import com.google.common.base.Preconditions;

public class UploadPartCopyRequest
extends GenericUploadRequest {
    private int partNumber;
    private long partSize;
    private long offSet;
    private String sourceBucketName;
    private String sourcetkey;
    private String xBceCrc;
    private String xBceCrc32c;
    private boolean xBceCrc32cFlag = false;

    public String getxBceCrc() {
        return this.xBceCrc;
    }

    public void setxBceCrc(String xBceCrc) {
        this.xBceCrc = xBceCrc;
    }

    public UploadPartCopyRequest() {
    }

    public UploadPartCopyRequest(String bucketName, String key, String sourcetBucketName, String sourcetkey, String uploadId, int partNumber, long partSize, long offSet) {
        super(bucketName, key, uploadId);
        this.setSourceBucketName(sourcetBucketName);
        this.setSourceKey(sourcetkey);
        this.setPartNumber(partNumber);
        this.setPartSize(partSize);
        this.setOffSet(offSet);
    }

    @Override
    public UploadPartCopyRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    @Override
    public UploadPartCopyRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    @Override
    public UploadPartCopyRequest withKey(String key) {
        this.setKey(key);
        return this;
    }

    @Override
    public UploadPartCopyRequest withUploadId(String uploadId) {
        this.setUploadId(uploadId);
        return this;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        Preconditions.checkArgument((partNumber > 0 ? 1 : 0) != 0, (String)"partNumber should be positive, but is %s", (Object[])new Object[]{partNumber});
        this.partNumber = partNumber;
    }

    public UploadPartCopyRequest withPartNumber(int partNumber) {
        this.setPartNumber(partNumber);
        return this;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        Preconditions.checkArgument((partSize >= 0L ? 1 : 0) != 0, (Object)"partSize should not be negative.");
        this.partSize = partSize;
    }

    public UploadPartCopyRequest withPartSize(long partSize) {
        this.setPartSize(partSize);
        return this;
    }

    public long getOffSet() {
        return this.offSet;
    }

    public void setOffSet(long offSet) {
        this.offSet = offSet;
    }

    public UploadPartCopyRequest withOffSet(long offSet) {
        this.setOffSet(offSet);
        return this;
    }

    public String getSourceBucketName() {
        return this.sourceBucketName;
    }

    public void setSourceBucketName(String sourceBucketName) {
        this.sourceBucketName = sourceBucketName;
    }

    public UploadPartCopyRequest withSourceBucketName(String sourceBucketName) {
        this.setSourceBucketName(sourceBucketName);
        return this;
    }

    public String getSourceKey() {
        return this.sourcetkey;
    }

    public void setSourceKey(String sourcetkey) {
        this.sourcetkey = sourcetkey;
    }

    public UploadPartCopyRequest withSourceKey(String sourcetkey) {
        this.setSourceKey(sourcetkey);
        return this;
    }

    public long getTrafficLimitBitPS() {
        return this.trafficLimitBitPS;
    }

    public void setTrafficLimitBitPS(long trafficLimitBitPS) {
        this.trafficLimitBitPS = trafficLimitBitPS;
    }

    public UploadPartCopyRequest withTrafficLimitBitPS(long trafficLimitBitPS) {
        this.setTrafficLimitBitPS(trafficLimitBitPS);
        return this;
    }

    public String getxBceCrc32c() {
        return this.xBceCrc32c;
    }

    public void setxBceCrc32c(String xBceCrc32c) {
        this.xBceCrc32c = xBceCrc32c;
    }

    public boolean getxBceCrc32cFlag() {
        return this.xBceCrc32cFlag;
    }

    public void setxBceCrc32cFlag(boolean xBceCrc32cFlag) {
        this.xBceCrc32cFlag = xBceCrc32cFlag;
    }
}

