/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.services.bos.model.BosProgressCallback;
import com.baidubce.services.bos.model.GenericUploadRequest;
import com.google.common.base.Preconditions;
import java.io.InputStream;

public class UploadPartRequest
extends GenericUploadRequest {
    private int partNumber;
    private long partSize;
    private String md5Digest;
    private InputStream inputStream;
    private String xBceCrc;
    private BosProgressCallback progressCallback = null;
    private String xBceCrc32c;
    private boolean xBceCrc32cFlag = false;

    public String getxBceCrc() {
        return this.xBceCrc;
    }

    public void setxBceCrc(String xBceCrc) {
        this.xBceCrc = xBceCrc;
    }

    public UploadPartRequest() {
    }

    public UploadPartRequest(String bucketName, String key, String uploadId, int partNumber, long partSize, InputStream inputStream) {
        super(bucketName, key, uploadId);
        this.setPartNumber(partNumber);
        this.setPartSize(partSize);
        this.setInputStream(inputStream);
    }

    @Override
    public UploadPartRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    @Override
    public UploadPartRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    @Override
    public UploadPartRequest withKey(String key) {
        this.setKey(key);
        return this;
    }

    @Override
    public UploadPartRequest withUploadId(String uploadId) {
        this.setUploadId(uploadId);
        return this;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        Preconditions.checkArgument((partNumber > 0 ? 1 : 0) != 0, (String)"partNumber should be positive, but is %s", (Object[])new Object[]{partNumber});
        this.partNumber = partNumber;
    }

    public UploadPartRequest withPartNumber(int partNumber) {
        this.setPartNumber(partNumber);
        return this;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        Preconditions.checkArgument((partSize >= 0L ? 1 : 0) != 0, (Object)"partSize should not be negative.");
        this.partSize = partSize;
    }

    public UploadPartRequest withPartSize(long partSize) {
        this.setPartSize(partSize);
        return this;
    }

    public String getMd5Digest() {
        return this.md5Digest;
    }

    public void setMd5Digest(String md5Digest) {
        this.md5Digest = md5Digest;
    }

    public UploadPartRequest withMD5Digest(String md5Digest) {
        this.setMd5Digest(md5Digest);
        return this;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream, (Object)"inputStream should not be null.");
        this.inputStream = inputStream;
    }

    public UploadPartRequest withInputStream(InputStream inputStream) {
        this.setInputStream(inputStream);
        return this;
    }

    public BosProgressCallback getProgressCallback() {
        return this.progressCallback;
    }

    public void setProgressCallback(BosProgressCallback progressCallback) {
        this.progressCallback = progressCallback;
    }

    public UploadPartRequest withProgressCallback(BosProgressCallback progressCallback) {
        this.setProgressCallback(progressCallback);
        return this;
    }

    public long getTrafficLimitBitPS() {
        return this.trafficLimitBitPS;
    }

    public void setTrafficLimitBitPS(long trafficLimitBitPS) {
        this.trafficLimitBitPS = trafficLimitBitPS;
    }

    public UploadPartRequest withTrafficLimitBitPS(long trafficLimitBitPS) {
        this.setTrafficLimitBitPS(trafficLimitBitPS);
        return this;
    }

    public String getxBceCrc32c() {
        return this.xBceCrc32c;
    }

    public void setxBceCrc32c(String xBceCrc32c) {
        this.xBceCrc32c = xBceCrc32c;
    }

    public boolean getxBceCrc32cFlag() {
        return this.xBceCrc32cFlag;
    }

    public void setxBceCrc32cFlag(boolean xBceCrc32cFlag) {
        this.xBceCrc32cFlag = xBceCrc32cFlag;
    }
}

