/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cfc;

import com.baidubce.http.BceHttpResponse;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.cfc.CfcInputStream;
import com.baidubce.services.cfc.model.CfcInvokeResult;
import com.baidubce.services.cfc.model.CfcMetaData;
import com.baidubce.services.cfc.model.GetInvokeResponse;
import com.baidubce.util.LengthCheckInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CfcResponseHandler
implements HttpResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(CfcResponseHandler.class);
    private static final String DEFAULT_ENCODING = "UTF-8";

    @Override
    public boolean handle(BceHttpResponse httpResponse, AbstractBceResponse response) throws Exception {
        if (!(response instanceof GetInvokeResponse)) {
            return false;
        }
        CfcInvokeResult object = new CfcInvokeResult();
        CfcMetaData objectMetadata = object.getObjectMetadata();
        objectMetadata.setBceRequestId(httpResponse.getHeader("x-bce-request-id"));
        objectMetadata.setContentLength(httpResponse.getHeaderAsLong("Content-Length"));
        objectMetadata.setContentType(httpResponse.getHeader("Content-Type"));
        objectMetadata.setServer(httpResponse.getHeader("Server"));
        objectMetadata.setBceLogResult(httpResponse.getHeader("X-Bce-Log-Result"));
        object.setObjectMetadata(objectMetadata);
        InputStream content = httpResponse.getContent();
        if (content != null) {
            if (objectMetadata.getContentLength() > 0L) {
                content = new LengthCheckInputStream(content, objectMetadata.getContentLength(), true);
            }
            object.setContent(new CfcInputStream(content, httpResponse.getHttpResponse()));
        }
        ((GetInvokeResponse)response).setInvoke(object);
        return true;
    }
}

