/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cfc.model;

import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonProperty;

public abstract class GenericFunctionRequest
extends AbstractBceRequest {
    private static final int MIN_FUNCTION_NAME_LENGTH = 1;
    private static final int MAX_FUNCTION_NAME_LENGTH = 64;
    private static final int MAX_DESCRIPTION_LENGTH = 256;
    @JsonProperty(value="FunctionName")
    private String FunctionName;
    @JsonProperty(value="Description")
    private String Description;

    public GenericFunctionRequest() {
    }

    public GenericFunctionRequest(String functionName, String description) {
        if (description == null) {
            description = "";
        }
        this.setFunctionName(functionName);
        this.setDescription(description);
    }

    @JsonProperty(value="FunctionName")
    public String getFunctionName() {
        return this.FunctionName;
    }

    public void setFunctionName(String functionName) {
        if (functionName == null) {
            throw new IllegalArgumentException("Invalid functionName: functionName should not be empty");
        }
        if ((functionName = functionName.trim()).length() < 1) {
            throw new IllegalArgumentException("Invalid functionName: " + functionName + ". functionName should not be less than " + 1 + ".");
        }
        if (functionName.length() > 64) {
            throw new IllegalArgumentException("Invalid functionName: " + functionName + ". functionName should not be greater than " + 64);
        }
        if (!GenericFunctionRequest.isLegalFunctionName(functionName)) {
            throw new IllegalArgumentException("Invalid functionName: " + functionName + ". functionName should be lowercase letters or digit or - or _");
        }
        this.FunctionName = functionName;
    }

    public abstract GenericFunctionRequest withFunctionName(String var1);

    private static boolean isLegalFunctionName(String functionName) {
        String regex = "^[a-z0-9A-Z-_]+$";
        return functionName.matches(regex);
    }

    @JsonProperty(value="Description")
    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        if (description == null) {
            this.Description = description;
        }
        if ((description = description.trim()).length() > 256) {
            throw new IllegalArgumentException("Invalid description: " + description + ". description should not be greater than " + 256);
        }
        this.Description = description;
    }

    public abstract GenericFunctionRequest withDescription(String var1);
}

