/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.esg;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.esg.EsgClientConfiguration;
import com.baidubce.services.esg.model.CreateEsgRequest;
import com.baidubce.services.esg.model.CreateEsgResponse;
import com.baidubce.services.esg.model.DeleteEsgRequest;
import com.baidubce.services.esg.model.DeleteEsgRuleRequest;
import com.baidubce.services.esg.model.EsgAction;
import com.baidubce.services.esg.model.EsgRuleOperateRequest;
import com.baidubce.services.esg.model.ListEsgRequest;
import com.baidubce.services.esg.model.ListEsgResponse;
import com.baidubce.services.esg.model.UpdateEsgRuleRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsgClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EsgClient.class);
    private static final String VERSION = "v1";
    private static final String ESG_PREFIX = "enterprise/security";
    private static final String ESG_RULE_PREFIX = "enterprise/security/rule";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String MARKER = "marker";
    private static final String MAX_KEYS = "maxKeys";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String REQUEST_RULE_NULL_ERROR_MESSAGE = "request rule should not be null.";
    private static final String NAME_MESSAGE_KEY = "name";
    private static final String ESGID_MESSAGE_KEY = "enterpriseSecurityGroupId";
    private static final String INSTANCEID_MESSAGE_KEY = "instanceId";
    private static final HttpResponseHandler[] ESG_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public EsgClient() {
        this(new EsgClientConfiguration());
    }

    public EsgClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, ESG_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    public CreateEsgResponse createEsg(CreateEsgRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ESG_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateEsgResponse.class);
    }

    public ListEsgResponse listEsg(ListEsgRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ESG_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        } else if (request.getMaxKeys() <= 0) {
            internalRequest.addParameter(MAX_KEYS, "1000");
        }
        if (!Strings.isNullOrEmpty((String)request.getInstanceId())) {
            internalRequest.addParameter(INSTANCEID_MESSAGE_KEY, request.getInstanceId());
        }
        return this.invokeHttpClient(internalRequest, ListEsgResponse.class);
    }

    public void deleteEsg(DeleteEsgRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEnterpriseSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ESGID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, ESG_PREFIX, request.getEnterpriseSecurityGroupId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteEsg(String esgId) {
        this.deleteEsg(DeleteEsgRequest.builder().enterpriseSecurityGroupId(esgId).build());
    }

    public void authorizeEsgRule(EsgRuleOperateRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEnterpriseSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ESGID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (Strings.isNullOrEmpty((String)request.getAction())) {
            request.setAction("authorizeRule");
        }
        if (null == request.getRules()) {
            throw new IllegalArgumentException(REQUEST_RULE_NULL_ERROR_MESSAGE);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ESG_PREFIX, request.getEnterpriseSecurityGroupId());
        internalRequest.addParameter(EsgAction.authorizeRule.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteEsgRule(DeleteEsgRuleRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEnterpriseSecurityGroupRuleId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ESGID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, ESG_RULE_PREFIX, request.getEnterpriseSecurityGroupRuleId());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteEsgRule(String esgRuleId) {
        this.deleteEsgRule(DeleteEsgRuleRequest.builder().enterpriseSecurityGroupRuleId(esgRuleId).build());
    }

    public void updateEsgRule(UpdateEsgRuleRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getEnterpriseSecurityGroupRuleId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ESGID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ESG_RULE_PREFIX, request.getEnterpriseSecurityGroupRuleId());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }
}

