/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vod;

import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.model.AbortMultipartUploadRequest;
import com.baidubce.services.bos.model.CompleteMultipartUploadRequest;
import com.baidubce.services.bos.model.CompleteMultipartUploadResponse;
import com.baidubce.services.bos.model.InitiateMultipartUploadRequest;
import com.baidubce.services.bos.model.InitiateMultipartUploadResponse;
import com.baidubce.services.bos.model.PartETag;
import com.baidubce.services.bos.model.UploadPartRequest;
import com.baidubce.services.bos.model.UploadPartResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadSession {
    private static Logger logger = LoggerFactory.getLogger(FileUploadSession.class);
    static final long CHUNK_SIZE = 0x500000L;
    private BosClient bosClient;
    private String bucket;
    private String bosKey;
    private String uploadId;
    private File file;
    private List<PartETag> partETags;

    public FileUploadSession(BosClient bosClient) {
        this.bosClient = bosClient;
    }

    public boolean upload(File file, String bucket, String bosKey) {
        this.file = file;
        this.bucket = bucket;
        this.bosKey = bosKey;
        long fileLength = file.length();
        logger.info("[fileLength] = " + fileLength);
        int parts = (int)(fileLength / 0x500000L);
        if (fileLength % 0x500000L > 0L) {
            ++parts;
        }
        logger.info("[fileLength] = " + fileLength + ", [parts] = " + parts);
        this.partETags = new ArrayList<PartETag>(parts);
        this.initMultipartUpload();
        ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(parts);
        for (int i = 0; i < parts; ++i) {
            futures.add(pool.submit(new UploadPartTask(this, i)));
        }
        boolean success = true;
        for (int i = 0; i < futures.size(); ++i) {
            Future future = (Future)futures.get(i);
            try {
                if (((Boolean)future.get()).booleanValue()) {
                    logger.info("The upload task [ " + i + "] completed.");
                    continue;
                }
                logger.error("The upload task [ " + i + "] failed.");
                success = false;
                continue;
            }
            catch (Exception e) {
                success = false;
            }
        }
        pool.shutdownNow();
        if (success) {
            Collections.sort(this.partETags, new Comparator<PartETag>(){

                @Override
                public int compare(PartETag a, PartETag b) {
                    return a.getPartNumber() - b.getPartNumber();
                }
            });
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucket, bosKey, this.uploadId, this.partETags);
            CompleteMultipartUploadResponse response = this.bosClient.completeMultipartUpload(completeMultipartUploadRequest);
            logger.info("Success to upload file: " + file.getAbsolutePath() + " to BOS with ETag: " + response.getETag());
        } else {
            AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(bucket, bosKey, this.uploadId);
            this.bosClient.abortMultipartUpload(abortMultipartUploadRequest);
            logger.info("Failed to upload file: " + file.getAbsolutePath());
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadPart(int partNum) {
        logger.info("Upload part: " + partNum);
        int tryCount = 5;
        while (tryCount > 0) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.file);
                long skipBytes = 0x500000L * (long)partNum;
                fis.skip(skipBytes);
                long partSize = 0x500000L < this.file.length() - skipBytes ? 0x500000L : this.file.length() - skipBytes;
                logger.info("[skipBytes]= " + skipBytes + ", [partSize] = " + partSize + ", [file.length() - skipBytes] = " + (this.file.length() - skipBytes));
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(this.bucket);
                uploadPartRequest.setKey(this.bosKey);
                uploadPartRequest.setUploadId(this.uploadId);
                uploadPartRequest.setInputStream(fis);
                uploadPartRequest.setPartSize(partSize);
                uploadPartRequest.setPartNumber(partNum + 1);
                UploadPartResponse uploadPartResponse = this.bosClient.uploadPart(uploadPartRequest);
                this.partETags.add(uploadPartResponse.getPartETag());
                logger.info("Complete upload with ETag: " + uploadPartResponse.getPartETag());
                break;
            }
            catch (IOException e) {
                logger.error("Failed to upload the part " + partNum + " [tryCount] = " + tryCount);
                --tryCount;
            }
            finally {
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        if (tryCount == 0) {
            logger.error("Failed to upload the part " + partNum);
        } else {
            logger.info("Success to upload the part " + partNum);
        }
        return tryCount > 0;
    }

    private void initMultipartUpload() {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(this.bucket, this.bosKey);
        InitiateMultipartUploadResponse initiateMultipartUploadResponse = this.bosClient.initiateMultipartUpload(initiateMultipartUploadRequest);
        this.uploadId = initiateMultipartUploadResponse.getUploadId();
        logger.info("[uploadId] = " + this.uploadId);
    }

    class UploadPartTask
    implements Callable<Boolean> {
        int partNum;
        FileUploadSession session;

        UploadPartTask(FileUploadSession session, int partNum) {
            this.session = session;
            this.partNum = partNum;
        }

        @Override
        public Boolean call() {
            return this.session.uploadPart(this.partNum);
        }
    }
}

