/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.auth;

import com.baidubce.BceClientException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.BceSessionCredentials;
import com.baidubce.auth.SignOptions;
import com.baidubce.auth.Signer;
import com.baidubce.internal.InternalRequest;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BceV1Signer
implements Signer {
    private static final Logger logger = LoggerFactory.getLogger(BceV1Signer.class);
    private static final String BCE_AUTH_VERSION = "bce-auth-v1";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Set<String> defaultHeadersToSign = Sets.newHashSet();
    private static final Joiner headerJoiner = Joiner.on((char)'\n');
    private static final Joiner signedHeaderStringJoiner = Joiner.on((char)';');

    @Override
    public void sign(InternalRequest request, BceCredentials credentials) {
        this.sign(request, credentials, null);
    }

    @Override
    public void sign(InternalRequest request, BceCredentials credentials, SignOptions options) {
        Date timestamp;
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (credentials == null) {
            return;
        }
        if (options == null) {
            options = request.getSignOptions() != null ? request.getSignOptions() : SignOptions.DEFAULT;
        }
        String accessKeyId = credentials.getAccessKeyId();
        String secretAccessKey = credentials.getSecretKey();
        request.addHeader("Host", HttpUtils.generateHostHeader(request.getUri()));
        if (credentials instanceof BceSessionCredentials) {
            if (options.getUseStsHeader().booleanValue()) {
                request.addHeader("x-bce-security-token", ((BceSessionCredentials)credentials).getSessionToken());
            } else {
                request.addParameter("x-bce-security-token", ((BceSessionCredentials)credentials).getSessionToken());
            }
        }
        if ((timestamp = options.getTimestamp()) == null) {
            timestamp = new Date();
        }
        String authString = "bce-auth-v1/" + accessKeyId + "/" + DateUtils.formatAlternateIso8601Date(timestamp) + "/" + options.getExpirationInSeconds();
        String signingKey = this.sha256Hex(secretAccessKey, authString);
        String canonicalURI = this.getCanonicalURIPath(request.getUri().getPath());
        String canonicalQueryString = HttpUtils.getCanonicalQueryString(request.getParameters(), true);
        SortedMap<String, String> headersToSign = this.getHeadersToSign(request.getHeaders(), options.getHeadersToSign());
        String canonicalHeader = this.getCanonicalHeaders(headersToSign);
        String signedHeaders = "";
        if (options.getHeadersToSign() != null) {
            signedHeaders = signedHeaderStringJoiner.join(headersToSign.keySet());
            signedHeaders = signedHeaders.trim().toLowerCase();
        }
        String canonicalRequest = (Object)((Object)request.getHttpMethod()) + "\n" + canonicalURI + "\n" + canonicalQueryString + "\n" + canonicalHeader;
        String signature = this.sha256Hex(signingKey, canonicalRequest);
        String authorizationHeader = authString + "/" + signedHeaders + "/" + signature;
        logger.debug("CanonicalRequest:{}\tAuthorization:{}", (Object)canonicalRequest.replace("\n", "[\\n]"), (Object)authorizationHeader);
        request.addHeader("Authorization", authorizationHeader);
    }

    private String getCanonicalURIPath(String path) {
        if (path == null) {
            return "/";
        }
        if (path.startsWith("/")) {
            return HttpUtils.normalizePath(path);
        }
        return "/" + HttpUtils.normalizePath(path);
    }

    private String getCanonicalHeaders(SortedMap<String, String> headers) {
        if (headers.isEmpty()) {
            return "";
        }
        ArrayList headerStrings = Lists.newArrayList();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            headerStrings.add(HttpUtils.normalize(key.trim().toLowerCase()) + ':' + HttpUtils.normalize(value.trim()));
        }
        Collections.sort(headerStrings);
        return headerJoiner.join((Iterable)headerStrings);
    }

    private SortedMap<String, String> getHeadersToSign(Map<String, String> headers, Set<String> headersToSign) {
        TreeMap ret = Maps.newTreeMap();
        if (headersToSign != null) {
            HashSet tempSet = Sets.newHashSet();
            for (String header : headersToSign) {
                tempSet.add(header.trim().toLowerCase());
            }
            headersToSign = tempSet;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() == null || entry.getValue().isEmpty() || (headersToSign != null || !this.isDefaultHeaderToSign(key)) && (headersToSign == null || !headersToSign.contains(key.toLowerCase()) || "Authorization".equalsIgnoreCase(key))) continue;
            ret.put(key, entry.getValue());
        }
        return ret;
    }

    private boolean isDefaultHeaderToSign(String header) {
        return (header = header.trim().toLowerCase()).startsWith("x-bce-") || defaultHeadersToSign.contains(header);
    }

    private String sha256Hex(String signingKey, String stringToSign) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(signingKey.getBytes(UTF8), "HmacSHA256"));
            return new String(Hex.encodeHex((byte[])mac.doFinal(stringToSign.getBytes(UTF8))));
        }
        catch (Exception e) {
            throw new BceClientException("Fail to generate the signature", e);
        }
    }

    static {
        defaultHeadersToSign.add("Host".toLowerCase());
        defaultHeadersToSign.add("Content-Length".toLowerCase());
        defaultHeadersToSign.add("Content-Type".toLowerCase());
        defaultHeadersToSign.add("Content-MD5".toLowerCase());
    }
}

