/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.csn;

import com.baidubce.BceClientConfiguration;
import com.baidubce.common.ApiInfo;
import com.baidubce.common.BaseBceClient;
import com.baidubce.common.BaseBceResponse;
import com.baidubce.common.BceRegion;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.csn.api.CsnApi;
import com.baidubce.services.csn.model.AttachInstanceRequest;
import com.baidubce.services.csn.model.BindCsnBpRequest;
import com.baidubce.services.csn.model.CreateAssociationRequest;
import com.baidubce.services.csn.model.CreateCsnBpLimitRequest;
import com.baidubce.services.csn.model.CreateCsnBpRequest;
import com.baidubce.services.csn.model.CreateCsnBpResponse;
import com.baidubce.services.csn.model.CreateCsnRequest;
import com.baidubce.services.csn.model.CreateCsnResponse;
import com.baidubce.services.csn.model.CreatePropagationRequest;
import com.baidubce.services.csn.model.CreateRouteRuleRequest;
import com.baidubce.services.csn.model.DeleteCsnBpLimitRequest;
import com.baidubce.services.csn.model.DetachInstanceRequest;
import com.baidubce.services.csn.model.GetCsnBpResponse;
import com.baidubce.services.csn.model.GetCsnResponse;
import com.baidubce.services.csn.model.ListAssociationResponse;
import com.baidubce.services.csn.model.ListCsnBpLimitByCsnIdResponse;
import com.baidubce.services.csn.model.ListCsnBpLimitResponse;
import com.baidubce.services.csn.model.ListCsnBpResponse;
import com.baidubce.services.csn.model.ListCsnResponse;
import com.baidubce.services.csn.model.ListInstanceResponse;
import com.baidubce.services.csn.model.ListPropagationResponse;
import com.baidubce.services.csn.model.ListRouteRuleResponse;
import com.baidubce.services.csn.model.ListRouteTableResponse;
import com.baidubce.services.csn.model.ListTgwResponse;
import com.baidubce.services.csn.model.ListTgwRuleResponse;
import com.baidubce.services.csn.model.ResizeCsnBpRequest;
import com.baidubce.services.csn.model.UnbindCsnBpRequest;
import com.baidubce.services.csn.model.UpdateCsnBpLimitRequest;
import com.baidubce.services.csn.model.UpdateCsnBpRequest;
import com.baidubce.services.csn.model.UpdateCsnRequest;
import com.baidubce.services.csn.model.UpdateTgwRequest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class CsnClient
extends BaseBceClient {
    private static final Map<BceRegion, String> ENDPOINTS = ImmutableMap.builder().put((Object)BceRegion.DEFAULT, (Object)"http://csn.baidubce.com").build();
    private static final String SERVICE_ID = "Csn";
    private static final Map<String, ApiInfo> CSN_APIS = CsnApi.getApis();

    public CsnClient(String ak, String sk, BceRegion region) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get((Object)region));
    }

    public CsnClient(String ak, String sk) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get((Object)BceRegion.DEFAULT));
    }

    public CsnClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    public CreateCsnResponse createCsn(CreateCsnRequest body, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("createCsn"));
        String apiPath = apiInfo.getPath().get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, CreateCsnResponse.class);
    }

    public void updateCsn(String csnId, UpdateCsnRequest body, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("updateCsn"));
        String apiPath = apiInfo.getPath().withPathParameter("csnId", csnId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void deleteCsn(String csnId, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("deleteCsn"));
        String apiPath = apiInfo.getPath().withPathParameter("csnId", csnId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public ListCsnResponse listCsn(String marker, Integer maxKeys) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("listCsn"));
        String apiPath = apiInfo.getPath().get();
        apiInfo.getQueries().put("marker", marker);
        if (null == maxKeys) {
            maxKeys = 1000;
        }
        apiInfo.getQueries().put("maxKeys", String.valueOf(maxKeys));
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListCsnResponse.class);
    }

    public ListInstanceResponse listInstance(String csnId, String marker, Integer maxKeys) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("listInstance"));
        String apiPath = apiInfo.getPath().withPathParameter("csnId", csnId).get();
        apiInfo.getQueries().put("marker", marker);
        apiInfo.getQueries().put("maxKeys", String.valueOf(maxKeys));
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListInstanceResponse.class);
    }

    public GetCsnResponse getCsn(String csnId) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("getCsn"));
        String apiPath = apiInfo.getPath().withPathParameter("csnId", csnId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, GetCsnResponse.class);
    }

    public void detachInstance(String csnId, DetachInstanceRequest detachInstanceRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("detachInstance"));
        String apiPath = apiInfo.getPath().withPathParameter("csnId", csnId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), detachInstanceRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void attachInstance(String csnId, AttachInstanceRequest attachInstanceRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("attachInstance"));
        String apiPath = apiInfo.getPath().withPathParameter("csnId", csnId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), attachInstanceRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void createRouteRule(String csnRtId, CreateRouteRuleRequest createRouteRuleRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("createRouteRule"));
        String apiPath = apiInfo.getPath().withPathParameter("csnRtId", csnRtId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), createRouteRuleRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public ListRouteRuleResponse listRouteRule(String csnRtId, String marker, Integer maxKeys) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("listRouteRule"));
        String apiPath = apiInfo.getPath().withPathParameter("csnRtId", csnRtId).get();
        apiInfo.getQueries().put("marker", marker);
        apiInfo.getQueries().put("maxKeys", String.valueOf(maxKeys));
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListRouteRuleResponse.class);
    }

    public void deleteRouteRule(String csnRtId, String csnRtRuleId, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("deleteRouteRule"));
        String apiPath = apiInfo.getPath().withPathParameter("csnRtId", csnRtId).withPathParameter("csnRtRuleId", csnRtRuleId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void createPropagation(String csnRtId, CreatePropagationRequest createPropagationRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("createPropagation"));
        String apiPath = apiInfo.getPath().withPathParameter("csnRtId", csnRtId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), createPropagationRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public ListPropagationResponse listPropagation(String csnRtId) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("listPropagation"));
        String apiPath = apiInfo.getPath().withPathParameter("csnRtId", csnRtId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListPropagationResponse.class);
    }

    public void deletePropagation(String csnRtId, String attachId, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("deletePropagation"));
        String apiPath = apiInfo.getPath().withPathParameter("csnRtId", csnRtId).withPathParameter("attachId", attachId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void createAssociation(String csnRtId, CreateAssociationRequest createAssociationRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("createAssociation"));
        String apiPath = apiInfo.getPath().withPathParameter("csnRtId", csnRtId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), createAssociationRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public ListAssociationResponse listAssociation(String csnRtId) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("listAssociation"));
        String apiPath = apiInfo.getPath().withPathParameter("csnRtId", csnRtId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListAssociationResponse.class);
    }

    public void deleteAssociation(String csnRtId, String attachId, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("deleteAssociation"));
        String apiPath = apiInfo.getPath().withPathParameter("csnRtId", csnRtId).withPathParameter("attachId", attachId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public ListRouteTableResponse listRouteTable(String csnId, String marker, Integer maxKeys) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("listRouteTable"));
        String apiPath = apiInfo.getPath().withPathParameter("csnId", csnId).get();
        apiInfo.getQueries().put("marker", marker);
        apiInfo.getQueries().put("maxKeys", String.valueOf(maxKeys));
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListRouteTableResponse.class);
    }

    public ListCsnBpResponse listCsnBp(String marker, Integer maxKeys) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("listCsnBp"));
        String apiPath = apiInfo.getPath().get();
        apiInfo.getQueries().put("marker", marker);
        apiInfo.getQueries().put("maxKeys", String.valueOf(maxKeys));
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListCsnBpResponse.class);
    }

    public GetCsnBpResponse getCsnBp(String csnBpId) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("getCsnBp"));
        String apiPath = apiInfo.getPath().withPathParameter("csnBpId", csnBpId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, GetCsnBpResponse.class);
    }

    public CreateCsnBpResponse createCsnBp(CreateCsnBpRequest createCsnBpRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("createCsnBp"));
        String apiPath = apiInfo.getPath().get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), createCsnBpRequest);
        return this.invokeHttpClient(internalRequest, CreateCsnBpResponse.class);
    }

    public void updateCsnBp(String csnBpId, UpdateCsnBpRequest updateCsnBpRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("updateCsnBp"));
        String apiPath = apiInfo.getPath().withPathParameter("csnBpId", csnBpId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), updateCsnBpRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void deleteCsnBp(String csnBpId, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("deleteCsnBp"));
        String apiPath = apiInfo.getPath().withPathParameter("csnBpId", csnBpId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void resizeCsnBp(String csnBpId, ResizeCsnBpRequest resizeCsnBpRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("resizeCsnBp"));
        String apiPath = apiInfo.getPath().withPathParameter("csnBpId", csnBpId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), resizeCsnBpRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void unbindCsnBp(String csnBpId, UnbindCsnBpRequest unbindCsnBpRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("unbindCsnBp"));
        String apiPath = apiInfo.getPath().withPathParameter("csnBpId", csnBpId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), unbindCsnBpRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void bindCsnBp(String csnBpId, BindCsnBpRequest bindCsnBpRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("bindCsnBp"));
        String apiPath = apiInfo.getPath().withPathParameter("csnBpId", csnBpId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), bindCsnBpRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public ListCsnBpLimitResponse listCsnBpLimit(String csnBpId) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("listCsnBpLimit"));
        String apiPath = apiInfo.getPath().withPathParameter("csnBpId", csnBpId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListCsnBpLimitResponse.class);
    }

    public void createCsnBpLimit(String csnBpId, CreateCsnBpLimitRequest createCsnBpLimitRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("createCsnBpLimit"));
        String apiPath = apiInfo.getPath().withPathParameter("csnBpId", csnBpId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), createCsnBpLimitRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void updateCsnBpLimit(String csnBpId, UpdateCsnBpLimitRequest updateCsnBpLimitRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("updateCsnBpLimit"));
        String apiPath = apiInfo.getPath().withPathParameter("csnBpId", csnBpId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), updateCsnBpLimitRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void deleteCsnBpLimit(String csnBpId, DeleteCsnBpLimitRequest deleteCsnBpLimitRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("deleteCsnBpLimit"));
        String apiPath = apiInfo.getPath().withPathParameter("csnBpId", csnBpId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), deleteCsnBpLimitRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public ListCsnBpLimitByCsnIdResponse listCsnBpLimitByCsnId(String csnId) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("listCsnBpLimitByCsnId"));
        String apiPath = apiInfo.getPath().withPathParameter("csnId", csnId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListCsnBpLimitByCsnIdResponse.class);
    }

    public ListTgwResponse listTgw(String csnId, String marker, Integer maxKeys) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("listTgw"));
        String apiPath = apiInfo.getPath().withPathParameter("csnId", csnId).get();
        apiInfo.getQueries().put("marker", marker);
        apiInfo.getQueries().put("maxKeys", String.valueOf(maxKeys));
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListTgwResponse.class);
    }

    public void updateTgw(String csnId, String tgwId, UpdateTgwRequest updateTgwRequest, String clientToken) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("updateTgw"));
        String apiPath = apiInfo.getPath().withPathParameter("csnId", csnId).withPathParameter("tgwId", tgwId).get();
        apiInfo.getQueries().put("clientToken", clientToken);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), updateTgwRequest);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public ListTgwRuleResponse listTgwRule(String csnId, String tgwId, String marker, Integer maxKeys) {
        ApiInfo apiInfo = new ApiInfo(CSN_APIS.get("listTgwRule"));
        String apiPath = apiInfo.getPath().withPathParameter("csnId", csnId).withPathParameter("tgwId", tgwId).get();
        apiInfo.getQueries().put("marker", marker);
        apiInfo.getQueries().put("maxKeys", String.valueOf(maxKeys));
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListTgwRuleResponse.class);
    }
}

