/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.havip;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.havip.HaVipClientConfiguration;
import com.baidubce.services.havip.model.BindEipRequest;
import com.baidubce.services.havip.model.BindInstanceRequest;
import com.baidubce.services.havip.model.CreateHaVipRequest;
import com.baidubce.services.havip.model.CreateHaVipResponse;
import com.baidubce.services.havip.model.DeleteHaVipRequest;
import com.baidubce.services.havip.model.HaVipResponse;
import com.baidubce.services.havip.model.ListHaVipRequest;
import com.baidubce.services.havip.model.ListHaVipResponse;
import com.baidubce.services.havip.model.UnBindEipRequest;
import com.baidubce.services.havip.model.UnBindInstanceRequest;
import com.baidubce.services.havip.model.UpdateHaVipRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;

public class HaVipClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String HAVIP_PREFIX = "havip";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String MARKER = "marker";
    private static final String MAX_KEYS = "maxKeys";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String NAME_MESSAGE_KEY = "name";
    private static final String HA_VIP_ID_MESSAGE_KEY = "haVipId";
    private static final String BIND_INSTANCE_TYPE_MESSAGE_KEY = "instanceType";
    private static final String BIND_PUBLIC_IP_ADDRESS_MESSAGE_KEY = "publicIpAddress";
    private static final HttpResponseHandler[] HAVIP_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public HaVipClient() {
        this(new HaVipClientConfiguration());
    }

    public HaVipClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, HAVIP_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    public CreateHaVipResponse createHaVip(CreateHaVipRequest createHaVipRequest) {
        Preconditions.checkNotNull((Object)createHaVipRequest, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)createHaVipRequest.getClientToken())) {
            createHaVipRequest.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(createHaVipRequest.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(createHaVipRequest, HttpMethodName.POST, HAVIP_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, createHaVipRequest.getClientToken());
        this.fillPayload(internalRequest, createHaVipRequest);
        return this.invokeHttpClient(internalRequest, CreateHaVipResponse.class);
    }

    public ListHaVipResponse listHaVip(String vpcId) {
        ListHaVipRequest listHaVipRequest = new ListHaVipRequest();
        listHaVipRequest.setVpcId(vpcId);
        return this.listHaVip(listHaVipRequest);
    }

    public ListHaVipResponse listHaVip(ListHaVipRequest listHaVipRequest) {
        Preconditions.checkNotNull((Object)listHaVipRequest, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(listHaVipRequest.getVpcId(), "VpcId not allow empty");
        InternalRequest internalRequest = this.createRequest(listHaVipRequest, HttpMethodName.GET, HAVIP_PREFIX);
        if (listHaVipRequest.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(listHaVipRequest.getMaxKeys()));
        } else if (listHaVipRequest.getMaxKeys() <= 0) {
            internalRequest.addParameter(MAX_KEYS, "1000");
        }
        internalRequest.addParameter("vpcId", listHaVipRequest.getVpcId());
        return this.invokeHttpClient(internalRequest, ListHaVipResponse.class);
    }

    public HaVipResponse getHaVip(String haVipId) {
        ListHaVipRequest listHaVipRequest = new ListHaVipRequest();
        InternalRequest internalRequest = this.createRequest(listHaVipRequest, HttpMethodName.GET, HAVIP_PREFIX, haVipId);
        return this.invokeHttpClient(internalRequest, HaVipResponse.class);
    }

    public void updateHaVip(UpdateHaVipRequest updateHaVipRequest) {
        Validate.checkNotNull(updateHaVipRequest, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(updateHaVipRequest.getHaVipId(), StringFormatUtils.checkEmptyExceptionMessageFormat(HA_VIP_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)updateHaVipRequest.getClientToken())) {
            updateHaVipRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(updateHaVipRequest, HttpMethodName.PUT, HAVIP_PREFIX, updateHaVipRequest.getHaVipId());
        internalRequest.addParameter(CLIENT_TOKEN, updateHaVipRequest.getClientToken());
        internalRequest.addParameter("modifyAttribute", null);
        this.fillPayload(internalRequest, updateHaVipRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteHaVip(DeleteHaVipRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getHaVipId(), StringFormatUtils.checkEmptyExceptionMessageFormat(HA_VIP_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, HAVIP_PREFIX, request.getHaVipId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteHaVip(String haVipId) {
        DeleteHaVipRequest deleteHaVipRequest = new DeleteHaVipRequest();
        deleteHaVipRequest.setHaVipId(haVipId);
        this.deleteHaVip(deleteHaVipRequest);
    }

    public void bindInstance(BindInstanceRequest bindInstanceRequest) {
        Validate.checkNotNull(bindInstanceRequest, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(bindInstanceRequest.getHaVipId(), StringFormatUtils.checkEmptyExceptionMessageFormat(HA_VIP_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(bindInstanceRequest.getInstanceType(), StringFormatUtils.checkEmptyExceptionMessageFormat(BIND_INSTANCE_TYPE_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)bindInstanceRequest.getClientToken())) {
            bindInstanceRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(bindInstanceRequest, HttpMethodName.PUT, HAVIP_PREFIX, bindInstanceRequest.getHaVipId());
        internalRequest.addParameter(CLIENT_TOKEN, bindInstanceRequest.getClientToken());
        internalRequest.addParameter("attach", null);
        this.fillPayload(internalRequest, bindInstanceRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unBindInstance(UnBindInstanceRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getHaVipId(), StringFormatUtils.checkEmptyExceptionMessageFormat(HA_VIP_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getInstanceType(), StringFormatUtils.checkEmptyExceptionMessageFormat(BIND_INSTANCE_TYPE_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, HAVIP_PREFIX, request.getHaVipId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        internalRequest.addParameter("detach", null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void bindEip(BindEipRequest bindEipRequest) {
        Validate.checkNotNull(bindEipRequest, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(bindEipRequest.getHaVipId(), StringFormatUtils.checkEmptyExceptionMessageFormat(HA_VIP_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(bindEipRequest.getPublicIpAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat(BIND_PUBLIC_IP_ADDRESS_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)bindEipRequest.getClientToken())) {
            bindEipRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(bindEipRequest, HttpMethodName.PUT, HAVIP_PREFIX, bindEipRequest.getHaVipId());
        internalRequest.addParameter(CLIENT_TOKEN, bindEipRequest.getClientToken());
        internalRequest.addParameter("bindPublicIp", null);
        this.fillPayload(internalRequest, bindEipRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unBindEip(UnBindEipRequest unBindEipRequest) {
        Validate.checkNotNull(unBindEipRequest, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(unBindEipRequest.getHaVipId(), StringFormatUtils.checkEmptyExceptionMessageFormat(HA_VIP_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)unBindEipRequest.getClientToken())) {
            unBindEipRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(unBindEipRequest, HttpMethodName.PUT, HAVIP_PREFIX, unBindEipRequest.getHaVipId());
        internalRequest.addParameter(CLIENT_TOKEN, unBindEipRequest.getClientToken());
        internalRequest.addParameter("unbindPublicIp", null);
        this.fillPayload(internalRequest, unBindEipRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }
}

