/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotdm;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.model.GenericAccountRequest;
import com.baidubce.services.iotdm.IotDmClientHelper;
import com.baidubce.services.iotdm.model.AccessDetailResponse;
import com.baidubce.services.iotdm.model.v3.device.CreateDeviceRequest;
import com.baidubce.services.iotdm.model.v3.device.DeviceAccessDetailResponse;
import com.baidubce.services.iotdm.model.v3.device.DeviceListRequest;
import com.baidubce.services.iotdm.model.v3.device.DeviceListResponse;
import com.baidubce.services.iotdm.model.v3.device.DeviceProfileListResponse;
import com.baidubce.services.iotdm.model.v3.device.DeviceProfileResponse;
import com.baidubce.services.iotdm.model.v3.device.DeviceViewResponse;
import com.baidubce.services.iotdm.model.v3.device.UpdateDeviceProfileRequest;
import com.baidubce.services.iotdm.model.v3.device.UpdateDeviceRegistryRequest;
import com.baidubce.services.iotdm.model.v3.device.UpdateDeviceViewRequest;
import com.baidubce.services.iotdm.model.v3.domain.CreateDomainRequest;
import com.baidubce.services.iotdm.model.v3.domain.DomainDetail;
import com.baidubce.services.iotdm.model.v3.domain.DomainDeviceListResponse;
import com.baidubce.services.iotdm.model.v3.domain.DomainListResponse;
import com.baidubce.services.iotdm.model.v3.domain.UpdateDomainDevicesRequest;
import com.baidubce.services.iotdm.model.v3.domain.UpdateDomainDevicesResponse;
import com.baidubce.services.iotdm.model.v3.domain.UpdateDomainRegistryInfoRequest;
import com.baidubce.services.iotdm.model.v3.rules.DeviceFormatRuleRequest;
import com.baidubce.services.iotdm.model.v3.rules.DeviceFormatRuleResponse;
import com.baidubce.services.iotdm.model.v3.rules.DeviceRuleRequest;
import com.baidubce.services.iotdm.model.v3.rules.DeviceRuleResponse;
import com.baidubce.services.iotdm.model.v3.schema.SchemaCreateRequest;
import com.baidubce.services.iotdm.model.v3.schema.SchemaCreateResponse;
import com.baidubce.services.iotdm.model.v3.schema.SchemaListResponse;
import com.baidubce.services.iotdm.model.v3.schema.SchemaResponse;
import com.baidubce.services.iotdm.model.v3.schema.SchemaUpdateRequest;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class IotDmV3Client
extends AbstractBceClient {
    private static final String ENDPOINT_HOST = "iotdm.gz.baidubce.com";
    private static final String DEVICE = "device";
    private static final String DOMAIN = "domain";
    private static final String ACCESS_DETAIL = "accessDetail";
    private static final String REMOVE = "remove";
    private static final String RESET = "reset";
    private static final String MODIFY = "modify";
    private static final String DEVICES = "devices";
    private static final String FORMAT = "format";
    private static final String UPDATE_PROFILE = "updateProfile";
    private static final String UPDATE_REGISTRY = "updateRegistry";
    private static final String UPDATE_SECRET_KEY = "updateSecretKey";
    private static final String DEVICE_VIEW = "deviceView";
    private static final String UPDATE_VIEW = "updateView";
    private static final String SCHEMA = "schema";
    private static final String NULL_DEVICE_NAME = "device name should not be null.";
    private static final String NULL_DOMAIN_NAME = "domain name should not be null.";
    private static final String NULL_REQUEST = "request should not be null.";
    private static final String NULL_SCHEMA_ID = "schema id should not be null.";
    private static final String NULL_SOURCES = "sources should not be null";
    private static final String NULL_DESTINATIONS = "destinations should not be null";
    private static final String NULL_FORMAT = "format should not be null";

    public IotDmV3Client(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT_HOST) : config, IotDmClientHelper.IOT_DM_HANDLERS);
    }

    public DeviceRuleResponse createDeviceRule(String deviceName, DeviceRuleRequest request) {
        Preconditions.checkNotNull((Object)deviceName, (Object)NULL_DEVICE_NAME);
        Preconditions.checkNotNull((Object)request, (Object)NULL_REQUEST);
        InternalRequest internalRequest = this.createRequestForRules(request, HttpMethodName.POST, DEVICE, deviceName);
        return this.invokeHttpClient(internalRequest, DeviceRuleResponse.class);
    }

    public DeviceRuleResponse getDeviceRules(String deviceName) {
        Preconditions.checkNotNull((Object)deviceName, (Object)NULL_DEVICE_NAME);
        InternalRequest internalRequest = this.createRequestForRules(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, deviceName);
        return this.invokeHttpClient(internalRequest, DeviceRuleResponse.class);
    }

    public DeviceRuleResponse modifyDeviceRule(String deviceName, DeviceRuleRequest request) {
        InternalRequest internalRequest = this.createRequestForRules(request, HttpMethodName.PUT, DEVICE, deviceName);
        return this.invokeHttpClient(internalRequest, DeviceRuleResponse.class);
    }

    public void removeDeviceRule(String deviceName) {
        Preconditions.checkNotNull((Object)deviceName, (Object)NULL_DEVICE_NAME);
        InternalRequest internalRequest = this.createRequestForRules(new GenericAccountRequest(), HttpMethodName.DELETE, DEVICE, deviceName);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void disableDeviceRule(String deviceName) {
        Preconditions.checkNotNull((Object)deviceName, (Object)NULL_DEVICE_NAME);
        InternalRequest internalRequest = this.createRequestForRules(new GenericAccountRequest(), HttpMethodName.PUT, DEVICE, deviceName);
        internalRequest.addParameter("disable", null);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void enableDeviceRule(String deviceName) {
        Preconditions.checkNotNull((Object)deviceName, (Object)NULL_DEVICE_NAME);
        InternalRequest internalRequest = this.createRequestForRules(new GenericAccountRequest(), HttpMethodName.PUT, DEVICE, deviceName);
        internalRequest.addParameter("enable", null);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DeviceFormatRuleResponse createTsdbFormatRule(String deviceName, DeviceFormatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)NULL_REQUEST);
        Preconditions.checkNotNull(request.getSources(), (Object)NULL_SOURCES);
        Preconditions.checkNotNull(request.getDestinations(), (Object)NULL_DESTINATIONS);
        Preconditions.checkNotNull((Object)request.getFormat(), (Object)NULL_FORMAT);
        Preconditions.checkNotNull((Object)deviceName, (Object)NULL_DEVICE_NAME);
        InternalRequest internalRequest = this.createRequestForRules(request, HttpMethodName.POST, DEVICE, deviceName, FORMAT);
        return this.invokeHttpClient(internalRequest, DeviceFormatRuleResponse.class);
    }

    public DeviceFormatRuleResponse getTsdbFormatRule(String deviceName) {
        Preconditions.checkNotNull((Object)deviceName, (Object)NULL_DEVICE_NAME);
        InternalRequest internalRequest = this.createRequestForRules(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, deviceName, FORMAT);
        return this.invokeHttpClient(internalRequest, DeviceFormatRuleResponse.class);
    }

    public DeviceFormatRuleResponse modifyTsdbFormatRule(String deviceName, DeviceFormatRuleRequest request) {
        InternalRequest internalRequest = this.createRequestForRules(request, HttpMethodName.PUT, DEVICE, deviceName, FORMAT);
        return this.invokeHttpClient(internalRequest, DeviceFormatRuleResponse.class);
    }

    public AccessDetailResponse createDomain(CreateDomainRequest createDomainRequest) {
        return this.doCreation(createDomainRequest, AccessDetailResponse.class, DOMAIN);
    }

    public void removeDomain(String domainName) {
        Preconditions.checkNotNull((Object)domainName, (Object)NULL_DOMAIN_NAME);
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, DOMAIN, domainName);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DomainListResponse getDomains(int pageNo, int pageSize, String orderBy, String order, String key, String type, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DOMAIN);
        this.addDomainQueryParas(internalRequest, pageNo, pageSize, orderBy, order, key, type, deviceName);
        return this.invokeHttpClient(internalRequest, DomainListResponse.class);
    }

    public DomainDetail getDomainDetail(String domainName) {
        Preconditions.checkNotNull((Object)domainName, (Object)NULL_DOMAIN_NAME);
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DOMAIN, domainName);
        return this.invokeHttpClient(internalRequest, DomainDetail.class);
    }

    public UpdateDomainDevicesResponse modifyDomainDevices(String domainName, UpdateDomainDevicesRequest updateDomainDevicesRequest) {
        Preconditions.checkNotNull((Object)domainName, (Object)NULL_DOMAIN_NAME);
        return this.doOperation(updateDomainDevicesRequest, UpdateDomainDevicesResponse.class, MODIFY, DOMAIN, domainName);
    }

    public void modifyDomainRegistryInfo(String domainName, UpdateDomainRegistryInfoRequest updateDomainRegistryInfoRequest) {
        Preconditions.checkNotNull((Object)domainName, (Object)NULL_DOMAIN_NAME);
        this.doOperation(updateDomainRegistryInfoRequest, AbstractBceResponse.class, null, DOMAIN, domainName);
    }

    public AccessDetailResponse getDomainAccessDetail(String domainName) {
        Preconditions.checkNotNull((Object)domainName, (Object)NULL_DOMAIN_NAME);
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DOMAIN, domainName, ACCESS_DETAIL);
        return this.invokeHttpClient(internalRequest, AccessDetailResponse.class);
    }

    public AccessDetailResponse updateDomainSecretKey(String domainName) {
        Preconditions.checkNotNull((Object)domainName, (Object)NULL_DOMAIN_NAME);
        return this.doOperation(new GenericAccountRequest(), AccessDetailResponse.class, UPDATE_SECRET_KEY, DOMAIN, domainName);
    }

    public DomainDeviceListResponse getDomainDeviceList(String domainName, int pageNo, int pageSize, String orderBy, String order, String name, String value, String favourite) {
        Preconditions.checkNotNull((Object)domainName, (Object)NULL_DOMAIN_NAME);
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DOMAIN, domainName, DEVICES);
        this.addDomainQueryDeviceParas(internalRequest, pageNo, pageSize, orderBy, order, name, value, favourite);
        return this.invokeHttpClient(internalRequest, DomainDeviceListResponse.class);
    }

    public DeviceAccessDetailResponse createDevice(CreateDeviceRequest createDeviceRequest) {
        return this.doCreation(createDeviceRequest, DeviceAccessDetailResponse.class, DEVICE);
    }

    public DeviceListResponse removeDevices(DeviceListRequest deviceListRequest) {
        return this.doOperation(deviceListRequest, DeviceListResponse.class, REMOVE, DEVICE);
    }

    public DeviceProfileResponse getDeviceProfile(String deviceName) {
        Preconditions.checkNotNull((Object)deviceName, (Object)NULL_DEVICE_NAME);
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, deviceName);
        return this.invokeHttpClient(internalRequest, DeviceProfileResponse.class);
    }

    public DeviceProfileResponse updateDeviceProfile(String deviceName, UpdateDeviceProfileRequest updateDeviceProfileRequest) {
        return this.doOperation(updateDeviceProfileRequest, DeviceProfileResponse.class, UPDATE_PROFILE, DEVICE, deviceName);
    }

    public DeviceProfileListResponse getDeviceProfiles(int pageNo, int pageSize, String orderBy, String order, String name, String value, String favourite) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE);
        this.addDeviceQueryParas(internalRequest, pageNo, pageSize, orderBy, order, name, value, favourite);
        return this.invokeHttpClient(internalRequest, DeviceProfileListResponse.class);
    }

    public DeviceAccessDetailResponse getDeviceAccessDetail(String deviceName) {
        Preconditions.checkNotNull((Object)deviceName, (Object)NULL_DEVICE_NAME);
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE, deviceName, ACCESS_DETAIL);
        return this.invokeHttpClient(internalRequest, DeviceAccessDetailResponse.class);
    }

    public DeviceProfileResponse updateDeviceRegistry(String deviceName, UpdateDeviceRegistryRequest updateDeviceRegistryRequest) {
        return this.doOperation(updateDeviceRegistryRequest, DeviceProfileResponse.class, UPDATE_REGISTRY, DEVICE, deviceName);
    }

    public DeviceAccessDetailResponse updateDeviceSecretKey(String deviceName) {
        return this.doOperation(new GenericAccountRequest(), DeviceAccessDetailResponse.class, UPDATE_SECRET_KEY, DEVICE, deviceName);
    }

    public DeviceListResponse resetDevices(DeviceListRequest request) {
        return this.doOperation(request, DeviceListResponse.class, RESET, DEVICE);
    }

    public DeviceViewResponse getDeviceView(String deviceName) {
        Preconditions.checkNotNull((Object)deviceName, (Object)NULL_DEVICE_NAME);
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICE_VIEW, deviceName);
        return this.invokeHttpClient(internalRequest, DeviceViewResponse.class);
    }

    public DeviceViewResponse updateDeviceView(String deviceName, UpdateDeviceViewRequest updateDeviceViewRequest) {
        return this.doOperation(updateDeviceViewRequest, DeviceViewResponse.class, UPDATE_VIEW, DEVICE_VIEW, deviceName);
    }

    public SchemaCreateResponse createSchema(SchemaCreateRequest schemaCreateRequest) {
        return this.doCreation(schemaCreateRequest, SchemaCreateResponse.class, SCHEMA);
    }

    public SchemaResponse getSchema(String schemaId) {
        Preconditions.checkNotNull((Object)schemaId, (Object)NULL_SCHEMA_ID);
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SCHEMA, schemaId);
        return this.invokeHttpClient(internalRequest, SchemaResponse.class);
    }

    public SchemaListResponse getSchemas(int pageNo, int pageSize, String orderBy, String order, String key) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SCHEMA);
        this.addSchemaQueryParas(internalRequest, pageNo, pageSize, orderBy, order, key);
        return this.invokeHttpClient(internalRequest, SchemaListResponse.class);
    }

    public void updateSchema(String schemaId, SchemaUpdateRequest schemaUpdateRequest) {
        this.doOperation(schemaUpdateRequest, AbstractBceResponse.class, null, SCHEMA, schemaId);
    }

    public void deleteSchema(String schemaId) {
        Preconditions.checkNotNull((Object)schemaId, (Object)NULL_SCHEMA_ID);
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, SCHEMA, schemaId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    private <T extends AbstractBceResponse> T doCreation(AbstractBceRequest request, Class<T> responseClass, String ... objectPath) {
        Preconditions.checkNotNull((Object)request, (Object)NULL_REQUEST);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, objectPath);
        return this.invokeHttpClient(internalRequest, responseClass);
    }

    private <T extends AbstractBceResponse> T doOperation(AbstractBceRequest request, Class<T> responseClass, String parameter, String ... pathVariables) {
        Preconditions.checkNotNull((Object)request, (Object)NULL_REQUEST);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, pathVariables);
        if (parameter != null) {
            internalRequest.addParameter(parameter, null);
        }
        return this.invokeHttpClient(internalRequest, responseClass);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        return IotDmClientHelper.createRequestForV3(bceRequest, httpMethod, this.getEndpoint(), null, pathVariables);
    }

    private InternalRequest createRequestForRules(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        return IotDmClientHelper.createRequestForRules(bceRequest, httpMethod, this.getEndpoint(), null, pathVariables);
    }

    private void addDeviceQueryParas(InternalRequest internalRequest, int pageNo, int pageSize, String orderBy, String order, String name, String value, String favourite) {
        this.addOrderAndPaginationParas(internalRequest, pageNo, pageSize, orderBy, order);
        if (name != null) {
            internalRequest.addParameter("name", name);
        }
        if (value != null) {
            internalRequest.addParameter("value", value);
        }
        if (favourite != null) {
            internalRequest.addParameter("favourite", favourite);
        }
    }

    private void addSchemaQueryParas(InternalRequest internalRequest, int pageNo, int pageSize, String orderBy, String order, String key) {
        this.addOrderAndPaginationParas(internalRequest, pageNo, pageSize, orderBy, order);
        if (key != null) {
            internalRequest.addParameter("key", key);
        }
    }

    private void addDomainQueryParas(InternalRequest internalRequest, int pageNo, int pageSize, String orderBy, String order, String key, String type, String deviceName) {
        this.addOrderAndPaginationParas(internalRequest, pageNo, pageSize, orderBy, order);
        if (StringUtils.isNotBlank((CharSequence)key)) {
            internalRequest.addParameter("key", key);
        }
        if (StringUtils.isBlank((CharSequence)type)) {
            type = "ALL";
        }
        internalRequest.addParameter("type", type);
        if (StringUtils.isNotBlank((CharSequence)deviceName)) {
            internalRequest.addParameter("deviceName", deviceName);
        }
    }

    private void addDomainQueryDeviceParas(InternalRequest internalRequest, int pageNo, int pageSize, String orderBy, String order, String name, String value, String favarite) {
        this.addOrderAndPaginationParas(internalRequest, pageNo, pageSize, orderBy, order);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            internalRequest.addParameter("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            internalRequest.addParameter("value", value);
        }
        if (StringUtils.isBlank((CharSequence)favarite)) {
            favarite = "all";
        }
        internalRequest.addParameter("favarite", favarite);
    }

    private void addOrderAndPaginationParas(InternalRequest internalRequest, int pageNo, int pageSize, String orderBy, String order) {
        internalRequest.addParameter("pageNo", String.valueOf(pageNo));
        internalRequest.addParameter("pageSize", String.valueOf(pageSize));
        if (orderBy != null) {
            internalRequest.addParameter("orderBy", orderBy);
        }
        if (order != null) {
            internalRequest.addParameter("order", order);
        }
    }
}

