/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.ipv6Gateway;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.ipv6Gateway.model.Billing;
import com.baidubce.services.ipv6Gateway.model.CreateEgressOnlyRuleRequest;
import com.baidubce.services.ipv6Gateway.model.CreateEgressOnlyRuleResponse;
import com.baidubce.services.ipv6Gateway.model.CreateIpv6GatewayRequest;
import com.baidubce.services.ipv6Gateway.model.CreateIpv6GatewayResponse;
import com.baidubce.services.ipv6Gateway.model.CreateRateLimitRuleRequest;
import com.baidubce.services.ipv6Gateway.model.DeleteIpv6EgressOnlyRuleRequest;
import com.baidubce.services.ipv6Gateway.model.DeleteIpv6GatewayRequest;
import com.baidubce.services.ipv6Gateway.model.DeleteIpv6RateLimitRuleRequest;
import com.baidubce.services.ipv6Gateway.model.Ipv6GatewayResponse;
import com.baidubce.services.ipv6Gateway.model.ListEgressOnlyRuleRequest;
import com.baidubce.services.ipv6Gateway.model.ListEgressOnlyRuleResponse;
import com.baidubce.services.ipv6Gateway.model.ListIpv6GatewayRequest;
import com.baidubce.services.ipv6Gateway.model.ListRateLimitRuleResponse;
import com.baidubce.services.ipv6Gateway.model.RateLimitRuleResponse;
import com.baidubce.services.ipv6Gateway.model.ResizeIpv6GatewayRequest;
import com.baidubce.services.ipv6Gateway.model.UpdateRateLimitRuleRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;

public class Ipv6GatewayClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String PREFIX = "IPv6Gateway";
    private static final String EGRESS_ONLY_RULE_PREFIX = "egressOnlyRule";
    private static final String RATE_LIMIT_RULE_PREFIX = "rateLimitRule";
    private static final String CLIENT_TOKEN_IDENTIFY = "clientToken";
    private static HttpResponseHandler[] ipv6GatewayHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public Ipv6GatewayClient() {
        this(new BceClientConfiguration());
    }

    public Ipv6GatewayClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, ipv6GatewayHandlers);
    }

    public CreateIpv6GatewayResponse createIpv6Gateway(String vpcId, String name, int bandwidthInMbps) {
        Billing billing = new Billing();
        billing.setPaymentTiming("Postpaid");
        return this.createIpv6Gateway(new CreateIpv6GatewayRequest().withVpcId(vpcId).withName(name).withBandwith(bandwidthInMbps).withBilling(billing));
    }

    public CreateIpv6GatewayResponse createIpv6Gateway(CreateIpv6GatewayRequest request) {
        Validate.checkNotNull(request.getName(), "name should not be null");
        Validate.checkNotNull(request.getVpcId(), "vpcId should not be null");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBilling());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        try {
            System.out.println(JsonUtils.toJsonPrettyString(internalRequest));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return this.invokeHttpClient(internalRequest, CreateIpv6GatewayResponse.class);
    }

    public void resizeIpv6Gateway(String ipv6GatewayId, int newBandwidthInMbps) {
        this.resizeIpv6Gateway(new ResizeIpv6GatewayRequest().withIpv6Gateway(ipv6GatewayId).withBandwidth(newBandwidthInMbps));
    }

    public void resizeIpv6Gateway(ResizeIpv6GatewayRequest request) {
        Validate.checkStringNotEmpty(request.getIpv6GatewayId(), "ipv6GatewayId should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getIpv6GatewayId());
        internalRequest.addParameter("resize", null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteIpv6Gateway(String gatewayId) {
        this.deleteIpv6Gateway(new DeleteIpv6GatewayRequest().withGatewayId(gatewayId));
    }

    public void deleteIpv6Gateway(DeleteIpv6GatewayRequest request) {
        Validate.checkStringNotEmpty(request.getGatewayId(), "gatewayId should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, request.getGatewayId());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public Ipv6GatewayResponse getIpv6Gateway(String vpcId) {
        ListIpv6GatewayRequest listIpv6GatewayRequest = new ListIpv6GatewayRequest();
        listIpv6GatewayRequest.withRequestVpcId(vpcId);
        return this.getIpv6Gateway(listIpv6GatewayRequest);
    }

    public Ipv6GatewayResponse getIpv6Gateway(ListIpv6GatewayRequest request) {
        Validate.checkStringNotEmpty(request.getVpcId(), "vpcId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, null);
        internalRequest.addParameter("vpcId", request.getVpcId());
        return this.invokeHttpClient(internalRequest, Ipv6GatewayResponse.class);
    }

    public CreateEgressOnlyRuleResponse craeteEgressOnlyRule(String gatewayId, String cidr) {
        CreateEgressOnlyRuleRequest createEgressOnlyRuleRequest = new CreateEgressOnlyRuleRequest();
        createEgressOnlyRuleRequest.setGatewayId(gatewayId);
        createEgressOnlyRuleRequest.setCidr(cidr);
        return this.createEgressOnlyRule(createEgressOnlyRuleRequest);
    }

    public CreateEgressOnlyRuleResponse createEgressOnlyRule(CreateEgressOnlyRuleRequest request) {
        Validate.checkStringNotEmpty(request.getGatewayId(), "gatewayId should not be empty");
        Validate.checkStringNotEmpty(request.getCidr(), "cidr should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, request.getGatewayId(), EGRESS_ONLY_RULE_PREFIX);
        this.fillPayload(internalRequest, request);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        return this.invokeHttpClient(internalRequest, CreateEgressOnlyRuleResponse.class);
    }

    public ListEgressOnlyRuleResponse listEgressOnlyRule(String gatewayId) {
        return this.listEgressOnlyRule(new ListEgressOnlyRuleRequest().withRequestGatewayId(gatewayId));
    }

    public ListEgressOnlyRuleResponse listEgressOnlyRule(ListEgressOnlyRuleRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getGatewayId(), "the gatewyId should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, request.getGatewayId(), EGRESS_ONLY_RULE_PREFIX);
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListEgressOnlyRuleResponse.class);
    }

    public void deleteIpv6GatewayEgressOnlyRule(String gatewayId, String egressOnlyRuleId) {
        this.deleteIpv6GatewayEgressOnlyRule(new DeleteIpv6EgressOnlyRuleRequest().withRequestGatewayId(gatewayId).wirhRequestEgressOnlyRuleId(egressOnlyRuleId));
    }

    public void deleteIpv6GatewayEgressOnlyRule(DeleteIpv6EgressOnlyRuleRequest deleteIpv6EgressOnlyRuleRequest) {
        Validate.checkNotNull(deleteIpv6EgressOnlyRuleRequest, "the deleteIpv6EgressOnlyRuleRequest should not be null");
        Validate.checkStringNotEmpty(deleteIpv6EgressOnlyRuleRequest.getEgressOnlyRuleId(), "egressOnlyRuleId should not be empty");
        Validate.checkStringNotEmpty(deleteIpv6EgressOnlyRuleRequest.getGatewayId(), "ipv6GatewayId should not be empty");
        if (Strings.isNullOrEmpty((String)deleteIpv6EgressOnlyRuleRequest.getClientToken())) {
            deleteIpv6EgressOnlyRuleRequest.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(deleteIpv6EgressOnlyRuleRequest, HttpMethodName.DELETE, deleteIpv6EgressOnlyRuleRequest.getGatewayId(), EGRESS_ONLY_RULE_PREFIX, deleteIpv6EgressOnlyRuleRequest.getEgressOnlyRuleId());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, deleteIpv6EgressOnlyRuleRequest.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public RateLimitRuleResponse createRateLimitRule(CreateRateLimitRuleRequest request) {
        Validate.checkNotNull(request, "the request should not be null");
        Validate.checkStringNotEmpty(request.getGatewayId(), "the gatewayId should not be null");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, request.getGatewayId(), RATE_LIMIT_RULE_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, RateLimitRuleResponse.class);
    }

    public void updateRateLimitRule(UpdateRateLimitRuleRequest request) {
        Validate.checkNotNull(request, "the request should not be null");
        Validate.checkStringNotEmpty(request.getGatewayId(), "the gatewayId should not be null");
        Validate.checkStringNotEmpty(request.getRateLimitRuleId(), "the rateLimitRuleId should not be null");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getGatewayId(), RATE_LIMIT_RULE_PREFIX, request.getRateLimitRuleId());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteIpv6GatewayRateLimitRule(String gatewayId, String rateLimitRuleId) {
        this.deleteIpv6GatewayEgressOnlyRule(new DeleteIpv6RateLimitRuleRequest().withRequestGatewayId(gatewayId).withRequestRateLimitRuleId(rateLimitRuleId));
    }

    public void deleteIpv6GatewayEgressOnlyRule(DeleteIpv6RateLimitRuleRequest request) {
        Validate.checkNotNull(request, "the deleteIpv6EgressOnlyRuleRequest should not be null");
        Validate.checkStringNotEmpty(request.getRateLimitRuleId(), "rateLimitRuleId should not be empty");
        Validate.checkStringNotEmpty(request.getGatewayId(), "ipv6GatewayId should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, request.getGatewayId(), RATE_LIMIT_RULE_PREFIX, request.getRateLimitRuleId());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListRateLimitRuleResponse listRateLimitRule(String gatewayId) {
        return this.listRateLimitRule(new ListEgressOnlyRuleRequest().withRequestGatewayId(gatewayId));
    }

    public ListRateLimitRuleResponse listRateLimitRule(ListEgressOnlyRuleRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getGatewayId(), "the gatewyId should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, request.getGatewayId(), RATE_LIMIT_RULE_PREFIX);
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListRateLimitRuleResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        path.add(PREFIX);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateDefaultClientToken() {
        return UUID.randomUUID().toString();
    }

    private Billing generateDefaultBilling() {
        Billing billing = new Billing();
        billing.setPaymentTiming("Postpaid");
        return billing;
    }
}

