/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.tablestorage.model.InstanceInfo;
import com.baidubce.services.tablestorage.model.ListInstanceResponse;
import com.baidubce.services.tablestorage.model.transform.Unmarshaller;
import com.baidubce.services.tablestorage.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class ListInstanceResponseUnmarshaller
implements Unmarshaller<ListInstanceResponse, InputStream> {
    private ListInstanceResponse result;

    public ListInstanceResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (ListInstanceResponse)response;
    }

    @Override
    public ListInstanceResponse unmarshall(InputStream in) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(in);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (!root.isObject()) {
            throw new BceClientException("The input json object:" + root.toString() + " is not an object.");
        }
        JsonNode instanceObj = root.get("instances");
        ArrayList<InstanceInfo> instanceInfos = new ArrayList<InstanceInfo>();
        if (instanceObj != null) {
            Iterator elements = instanceObj.elements();
            while (elements.hasNext()) {
                JsonNode node = (JsonNode)elements.next();
                String id = node.get("id").asText();
                String name = node.get("name").asText();
                String region = node.get("region").asText();
                String state = node.get("state").asText();
                String createTime = node.get("createTime").asText();
                String storageType = node.get("storageType").asText();
                InstanceInfo info = new InstanceInfo();
                info.setId(id);
                info.setName(name);
                info.setRegion(region);
                info.setState(state);
                info.setCreateTime(createTime);
                info.setStorageType(storageType);
                instanceInfos.add(info);
            }
        }
        this.result.setInstances(instanceInfos);
        return this.result;
    }
}

