/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.esg;

import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.esg.EsgClient;
import com.baidubce.services.esg.EsgClientConfiguration;
import com.baidubce.services.esg.model.CreateEsgRequest;
import com.baidubce.services.esg.model.CreateEsgResponse;
import com.baidubce.services.esg.model.EnterpriseSecurityGroupRule;
import java.util.Arrays;

public class ExampleCreateEsg {
    public static void main(String[] args) {
        String ak = "Your Ak";
        String sk = "Your Sk";
        String endpoint = "bcc.bj.baidubce.com";
        EsgClientConfiguration config = new EsgClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        config.setEndpoint(endpoint);
        EsgClient esgClient = new EsgClient(config);
        CreateEsgRequest createEsgRequest = new CreateEsgRequest();
        createEsgRequest.setName("esgName");
        createEsgRequest.setDesc("desc");
        EnterpriseSecurityGroupRule enterpriseSecurityGroupRule = new EnterpriseSecurityGroupRule();
        enterpriseSecurityGroupRule.setSourceIp("all");
        enterpriseSecurityGroupRule.setDestIp("all");
        enterpriseSecurityGroupRule.setAction("allow");
        enterpriseSecurityGroupRule.setDirection("ingress");
        enterpriseSecurityGroupRule.setPriority(100);
        enterpriseSecurityGroupRule.setProtocol("tcp");
        enterpriseSecurityGroupRule.setPortRange("1000-3000");
        enterpriseSecurityGroupRule.setEthertype("IPv4");
        createEsgRequest.setRules(Arrays.asList(enterpriseSecurityGroupRule));
        try {
            CreateEsgResponse response = esgClient.createEsg(createEsgRequest);
            System.out.println(response);
        }
        catch (BceClientException e) {
            System.out.println(e.getMessage());
        }
    }
}

