/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bcm;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bcm.MultiDimensionalLatestMetricsRequest;
import com.baidubce.services.bcm.MultiDimensionalLatestMetricsResponse;
import com.baidubce.services.bcm.handler.BcmJsonResponseHandler;
import com.baidubce.services.bcm.model.EmptyResponse;
import com.baidubce.services.bcm.model.ListMetricDataRequest;
import com.baidubce.services.bcm.model.ListMetricDataResponse;
import com.baidubce.services.bcm.model.ListResponse;
import com.baidubce.services.bcm.model.MapListResponse;
import com.baidubce.services.bcm.model.MetricDataRequest;
import com.baidubce.services.bcm.model.MetricDataResponse;
import com.baidubce.services.bcm.model.Page;
import com.baidubce.services.bcm.model.PushCustomMetricDataRequest;
import com.baidubce.services.bcm.model.PushMetricDataResponse;
import com.baidubce.services.bcm.model.Statistics;
import com.baidubce.services.bcm.model.action.CreateAndUpdateActionRequest;
import com.baidubce.services.bcm.model.action.DeleteActionRequest;
import com.baidubce.services.bcm.model.action.ListActionsRequest;
import com.baidubce.services.bcm.model.action.ListActionsResponse;
import com.baidubce.services.bcm.model.action.ListNotifyGroupsResponse;
import com.baidubce.services.bcm.model.action.ListNotifyPartiesResponse;
import com.baidubce.services.bcm.model.action.NotifyRequest;
import com.baidubce.services.bcm.model.alarm.AlarmConfig;
import com.baidubce.services.bcm.model.alarm.AlarmConfigV2;
import com.baidubce.services.bcm.model.alarm.AlarmMetric;
import com.baidubce.services.bcm.model.alarm.TargetType;
import com.baidubce.services.bcm.model.alarm.request.CommonAlarmConfigRequest;
import com.baidubce.services.bcm.model.alarm.request.CreateOrUpdateAlarmConfigRequest;
import com.baidubce.services.bcm.model.alarm.request.CreateOrUpdateAlarmConfigV2Request;
import com.baidubce.services.bcm.model.alarm.request.ListAlarmMetricsRequest;
import com.baidubce.services.bcm.model.alarm.request.ListSingleInstanceAlarmConfigsRequest;
import com.baidubce.services.bcm.model.alarm.response.CreateAlarmConfigV2Response;
import com.baidubce.services.bcm.model.application.ApplicationAlarmConfig;
import com.baidubce.services.bcm.model.application.ApplicationDataListRequest;
import com.baidubce.services.bcm.model.application.ApplicationDataListResponse;
import com.baidubce.services.bcm.model.application.ApplicationDimensionTableDeleteRequest;
import com.baidubce.services.bcm.model.application.ApplicationDimensionTableInfoRequest;
import com.baidubce.services.bcm.model.application.ApplicationDimensionTableInfoResponse;
import com.baidubce.services.bcm.model.application.ApplicationDimensionTableListRequest;
import com.baidubce.services.bcm.model.application.ApplicationInfoDetaleRequest;
import com.baidubce.services.bcm.model.application.ApplicationInfoRequest;
import com.baidubce.services.bcm.model.application.ApplicationInfoResponse;
import com.baidubce.services.bcm.model.application.ApplicationInfoUpdateRequest;
import com.baidubce.services.bcm.model.application.ApplicationInfoUpdateResponse;
import com.baidubce.services.bcm.model.application.ApplicationInstanceCreateRequest;
import com.baidubce.services.bcm.model.application.ApplicationInstanceCreatedListRequest;
import com.baidubce.services.bcm.model.application.ApplicationInstanceDeleteRequest;
import com.baidubce.services.bcm.model.application.ApplicationInstanceListRequest;
import com.baidubce.services.bcm.model.application.ApplicationInstanceListResponse;
import com.baidubce.services.bcm.model.application.ApplicationMetric;
import com.baidubce.services.bcm.model.application.ApplicationMonitorResponse;
import com.baidubce.services.bcm.model.application.ApplicationMonitorTaskDeleteRequest;
import com.baidubce.services.bcm.model.application.ApplicationMonitorTaskDetailRequest;
import com.baidubce.services.bcm.model.application.ApplicationMonitorTaskInfoRequest;
import com.baidubce.services.bcm.model.application.ApplicationMonitorTaskListRequest;
import com.baidubce.services.bcm.model.application.ApplicationMonitorTaskResponse;
import com.baidubce.services.bcm.model.application.CreateOrUpdateAlarmConfigForApplicationRequest;
import com.baidubce.services.bcm.model.application.DeleteAlarmConfigForApplicationRequest;
import com.baidubce.services.bcm.model.application.GetAlarmConfigForApplicationRequest;
import com.baidubce.services.bcm.model.application.GetMetricDataForApplicationRequest;
import com.baidubce.services.bcm.model.application.GetMetricMetaForApplicationRequest;
import com.baidubce.services.bcm.model.application.ListAlarmConfigForApplicationRequest;
import com.baidubce.services.bcm.model.application.ListAlarmMetricsForApplicationRequest;
import com.baidubce.services.bcm.model.application.LogExtractRequest;
import com.baidubce.services.bcm.model.application.LogExtractResult;
import com.baidubce.services.bcm.model.application.MetricDataForApplication;
import com.baidubce.services.bcm.model.application.MonitorObjectType;
import com.baidubce.services.bcm.model.custom.AlarmPolicyBatch;
import com.baidubce.services.bcm.model.custom.AlarmPolicyBatchListRequest;
import com.baidubce.services.bcm.model.custom.BatchDeleteNamespaceEventsRequest;
import com.baidubce.services.bcm.model.custom.BatchDeleteNamespaceMetricsRequest;
import com.baidubce.services.bcm.model.custom.BatchDeleteNamespacesRequest;
import com.baidubce.services.bcm.model.custom.CustomAlarmConfigRequest;
import com.baidubce.services.bcm.model.custom.CustomAlarmConfigResponse;
import com.baidubce.services.bcm.model.custom.CustomAlarmRule;
import com.baidubce.services.bcm.model.custom.CustomMonitorResponse;
import com.baidubce.services.bcm.model.custom.DetailCustomAlarmConfigRequest;
import com.baidubce.services.bcm.model.custom.GetCustomEventRequest;
import com.baidubce.services.bcm.model.custom.GetCustomEventResponse;
import com.baidubce.services.bcm.model.custom.GetCustomMetricRequest;
import com.baidubce.services.bcm.model.custom.GetCustomMetricResponse;
import com.baidubce.services.bcm.model.custom.ListCustomAlarmConfigRequest;
import com.baidubce.services.bcm.model.custom.ListCustomConfigResponse;
import com.baidubce.services.bcm.model.custom.ListNamespaceEventsRequest;
import com.baidubce.services.bcm.model.custom.ListNamespaceEventsResponse;
import com.baidubce.services.bcm.model.custom.ListNamespaceMetricsRequest;
import com.baidubce.services.bcm.model.custom.ListNamespaceMetricsResponse;
import com.baidubce.services.bcm.model.custom.ListNamespacesRequest;
import com.baidubce.services.bcm.model.custom.ListNamespacesResponse;
import com.baidubce.services.bcm.model.custom.NamespaceEventRequest;
import com.baidubce.services.bcm.model.custom.NamespaceMetricRequest;
import com.baidubce.services.bcm.model.custom.NamespaceRequest;
import com.baidubce.services.bcm.model.dashboard.DashboardBaseRequest;
import com.baidubce.services.bcm.model.dashboard.DashboardBillboardDataResponse;
import com.baidubce.services.bcm.model.dashboard.DashboardCreateResponse;
import com.baidubce.services.bcm.model.dashboard.DashboardDataRequest;
import com.baidubce.services.bcm.model.dashboard.DashboardDimensionsRequest;
import com.baidubce.services.bcm.model.dashboard.DashboardReportDataResponse;
import com.baidubce.services.bcm.model.dashboard.DashboardResponse;
import com.baidubce.services.bcm.model.dashboard.DashboardTrendDataResponse;
import com.baidubce.services.bcm.model.dashboard.DashboardTrendSeniorDataResponse;
import com.baidubce.services.bcm.model.dashboard.DashboardWidgetRequest;
import com.baidubce.services.bcm.model.event.CloudEventResponse;
import com.baidubce.services.bcm.model.event.EventDataRequest;
import com.baidubce.services.bcm.model.event.EventFilter;
import com.baidubce.services.bcm.model.event.EventLevel;
import com.baidubce.services.bcm.model.event.EventPolicy;
import com.baidubce.services.bcm.model.event.EventPolicyResponse;
import com.baidubce.services.bcm.model.event.EventResourceFilter;
import com.baidubce.services.bcm.model.event.EventType;
import com.baidubce.services.bcm.model.event.PlatformEventResponse;
import com.baidubce.services.bcm.model.group.IGInstanceListResponse;
import com.baidubce.services.bcm.model.group.IGInstanceQuery;
import com.baidubce.services.bcm.model.group.IGInstanceQueryType;
import com.baidubce.services.bcm.model.group.InstanceGroup;
import com.baidubce.services.bcm.model.group.InstanceGroupBase;
import com.baidubce.services.bcm.model.group.InstanceGroupListResponse;
import com.baidubce.services.bcm.model.group.InstanceGroupQuery;
import com.baidubce.services.bcm.model.group.InstanceGroupResponse;
import com.baidubce.services.bcm.model.group.MergedGroup;
import com.baidubce.services.bcm.model.metrics.MultiDimensionalMetricsRequest;
import com.baidubce.services.bcm.model.metrics.PartialDimensionsMetricsRequest;
import com.baidubce.services.bcm.model.metrics.TsdbDimensionTopQuery;
import com.baidubce.services.bcm.model.metrics.TsdbDimensionTopResult;
import com.baidubce.services.bcm.model.metrics.TsdbMetricAllDataResult;
import com.baidubce.services.bcm.model.metrics.TsdbMetricResult;
import com.baidubce.services.bcm.model.site.DnsTaskRequest;
import com.baidubce.services.bcm.model.site.DnsTaskResponse;
import com.baidubce.services.bcm.model.site.FtpTaskRequest;
import com.baidubce.services.bcm.model.site.FtpTaskResponse;
import com.baidubce.services.bcm.model.site.HttpTaskRequest;
import com.baidubce.services.bcm.model.site.HttpTaskResponse;
import com.baidubce.services.bcm.model.site.HttpsTaskRequest;
import com.baidubce.services.bcm.model.site.HttpsTaskResponse;
import com.baidubce.services.bcm.model.site.IdcIspResponse;
import com.baidubce.services.bcm.model.site.PageData;
import com.baidubce.services.bcm.model.site.PageResultResponse;
import com.baidubce.services.bcm.model.site.PingTaskRequest;
import com.baidubce.services.bcm.model.site.PingTaskResponse;
import com.baidubce.services.bcm.model.site.SiteAgentRequest;
import com.baidubce.services.bcm.model.site.SiteAgentResponse;
import com.baidubce.services.bcm.model.site.SiteAlarmConfigDetailResponse;
import com.baidubce.services.bcm.model.site.SiteAlarmConfigListRequest;
import com.baidubce.services.bcm.model.site.SiteAlarmConfigRequest;
import com.baidubce.services.bcm.model.site.SiteAlarmRule;
import com.baidubce.services.bcm.model.site.SiteAlarmUserIdRequest;
import com.baidubce.services.bcm.model.site.SiteBasicResponse;
import com.baidubce.services.bcm.model.site.SiteInfoResponse;
import com.baidubce.services.bcm.model.site.SiteMetricDataQueryRequest;
import com.baidubce.services.bcm.model.site.SiteMetricDataQueryResponse;
import com.baidubce.services.bcm.model.site.SiteTaskIspRequest;
import com.baidubce.services.bcm.model.site.SiteTaskRequest;
import com.baidubce.services.bcm.model.site.SiteViewResponse;
import com.baidubce.services.bcm.model.site.TaskDetailRequest;
import com.baidubce.services.bcm.model.site.TaskResponse;
import com.baidubce.services.bcm.model.site.TaskSummaryRequest;
import com.baidubce.services.bcm.model.site.TaskSummaryResponse;
import com.baidubce.services.bcm.model.site.TcpTaskRequest;
import com.baidubce.services.bcm.model.site.TcpTaskResponse;
import com.baidubce.services.bcm.model.site.UdpTaskRequest;
import com.baidubce.services.bcm.model.site.UdpTaskResponse;
import com.baidubce.services.bcm.model.siteonce.EmptyRequest;
import com.baidubce.services.bcm.model.siteonce.HttpResponseWrapper;
import com.baidubce.services.bcm.model.siteonce.SiteOnceAgent;
import com.baidubce.services.bcm.model.siteonce.SiteOnceGroupTask;
import com.baidubce.services.bcm.model.siteonce.SiteOnceRequest;
import com.baidubce.services.bcm.model.siteonce.SiteOnceTaskList;
import com.baidubce.services.bcm.model.siteonce.SiteOnceTaskRequest;
import com.baidubce.services.bcm.model.siteonce.SiteOnceTaskResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.util.Strings;

public class BcmClient
extends AbstractBceClient {
    private static final String PREFIX = "json-api";
    private static final String V1 = "v1";
    private static final String V3 = "v3";
    private static final String METRIC_DATA = "metricdata";
    private static final String METRIC_NAME = "metricName";
    private static final String USER_ID = "userId";
    private static final String NAME = "name";
    private static final String NAMESPACE = "namespace";
    private static final String PAGE_NO = "pageNo";
    private static final String PAGE_SIZE = "pageSize";
    private static final String EVENT_NAME = "eventName";
    private static final String EVENT_LEVEL = "eventLevel";
    private static final Integer MAX_DIMENSIONS_SIZE = 100;
    private static final String PUSH_CUSTOM_METRIC_DATA_FORMAT = "/csm/api/v1/userId/%s/custom/data";
    private static final String CREATE_NAMESPACE = "/csm/api/v1/userId/%s/custom/namespaces/create";
    private static final String BATCH_DELETE_NAMESPACES = "/csm/api/v1/userId/%s/custom/namespaces/delete";
    private static final String UPDATE_NAMESPACE = "/csm/api/v1/userId/%s/custom/namespaces/update";
    private static final String LIST_NAMESPACES = "/csm/api/v1/userId/%s/custom/namespaces/list";
    private static final String CREATE_NAMESPACE_METRIC = "/csm/api/v1/userId/%s/custom/namespaces/%s/metrics/create";
    private static final String BATCH_DELETE_NAMESPACE_METRICS = "/csm/api/v1/userId/%s/custom/namespaces/%s/metrics/delete";
    private static final String UPDATE_NAMESPACE_METRIC = "/csm/api/v1/userId/%s/custom/namespaces/%s/metrics/%s";
    private static final String LIST_NAMESPACE_METRICS = "/csm/api/v1/userId/%s/custom/namespaces/metrics";
    private static final String GET_CUSTOM_METRIC = "/csm/api/v1/userId/%s/custom/namespaces/%s/metrics/%s";
    private static final String CREATE_NAMESPACE_EVENT = "/csm/api/v1/custom/event/configs/create";
    private static final String BATCH_DELETE_NAMESPACE_EVENTS = "/csm/api/v1/custom/event/configs/delete";
    private static final String UPDATE_NAMESPACE_EVENT = "/csm/api/v1/custom/event/configs/update";
    private static final String LIST_NAMESPACE_EVENTS = "/csm/api/v1/custom/event/configs/list";
    private static final String GET_CUSTOM_EVENT = "/csm/api/v1/custom/event/configs/detail";
    private static final String CREATE_DASHBOARD_PATH = "/csm/api/v1/dashboard/products/%s/dashboards";
    private static final String DASHBOARD_PATH = "/csm/api/v1/dashboard/products/%s/dashboards/%s";
    private static final String DUPLICATE_DASHBOARD_PATH = "/csm/api/v1/dashboard/products/%s/dashboards/%s/duplicate";
    private static final String DASHBOARD_WIDGET_PATH = "/csm/api/v1/dashboard/products/%s/dashboards/%s/widgets/%s";
    private static final String CREATE_DASHBOARD_WIDGET_PATH = "/csm/api/v1/dashboard/products/%s/dashboards/%s/widgets";
    private static final String DUPLICATE_DASHBOARD_WIDGET_PATH = "/csm/api/v1/dashboard/products/%s/dashboards/%s/widgets/%s/duplicate";
    private static final String DASHBOARD_REPORT_DATA_PATH = "/csm/api/v1/dashboard/metric/report";
    private static final String DASHBOARD_TREND_DATA_PATH = "/csm/api/v1/dashboard/metric/trend";
    private static final String DASHBOARD_GAUGE_CHART_DATA_PATH = "/csm/api/v1/dashboard/metric/gaugechart";
    private static final String DASHBOARD_BILLBOARD_DATA_PATH = "/csm/api/v1/dashboard/metric/billboard";
    private static final String DASHBOARD_TREND_SENIOR_DATA_PATH = "/csm/api/v1/dashboard/metric/trend/senior";
    private static final String DASHBOARD_DIMENSIONS_PATH = "/csm/api/v1/userId/%s/services/%s/region/%s/metric/dimensions";
    private static final String CLOUD_EVENT_LIST_PATH = "/event-api/v1/bce-event/list";
    private static final String PLATFORM_EVENT_LIST_PATH = "/event-api/v1/platform-event/list";
    private static final String EVENT_POLICY_PATH = "/event-api/v1/accounts/%s/services/%s/alarm-policies";
    private static final String INSTANCE_GROUP_PATH = "/csm/api/v1/userId/%s/instance-group";
    private static final String INSTANCE_GROUP_ID_PATH = "/csm/api/v1/userId/%s/instance-group/%s";
    private static final String INSTANCE_GROUP_LIST_PATH = "/csm/api/v1/userId/%s/instance-group/list";
    private static final String IG_INSTANCE_ADD = "/csm/api/v1/userId/%s/instance-group/%s/instance/add";
    private static final String IG_INSTANCE_REMOVE = "/csm/api/v1/userId/%s/instance-group/%s/instance/remove";
    private static final String IG_INSTANCE_LIST = "/csm/api/v1/userId/%s/instance-group/instance/list";
    private static final String IG_QUERY_INSTANCE_LIST = "/csm/api/v1/userId/%s/instance/list";
    private static final String IG_QUERY_INSTANCE_LIST_FILTER = "/csm/api/v1/userId/%s/instance/filteredList";
    private static final String SITE_CREATE_HTTP_TASK_PATH = "/csm/api/v1/userId/%s/site/http/create";
    private static final String SITE_UPDATE_HTTP_TASK_PATH = "/csm/api/v1/userId/%s/site/http/update";
    private static final String SITE_GET_HTTP_TASK_PATH = "/csm/api/v1/userId/%s/site/http/detail";
    private static final String SITE_CREATE_HTTPS_TASK_PATH = "/csm/api/v1/userId/%s/site/https/create";
    private static final String SITE_UPDATE_HTTPS_TASK_PATH = "/csm/api/v1/userId/%s/site/https/update";
    private static final String SITE_GET_HTTPS_TASK_PATH = "/csm/api/v1/userId/%s/site/https/detail";
    private static final String SITE_CREATE_PING_TASK_PATH = "/csm/api/v1/userId/%s/site/ping/create";
    private static final String SITE_UPDATE_PING_TASK_PATH = "/csm/api/v1/userId/%s/site/ping/update";
    private static final String SITE_GET_PING_TASK_PATH = "/csm/api/v1/userId/%s/site/ping/detail";
    private static final String SITE_CREATE_TCP_TASK_PATH = "/csm/api/v1/userId/%s/site/tcp/create";
    private static final String SITE_UPDATE_TCP_TASK_PATH = "/csm/api/v1/userId/%s/site/tcp/update";
    private static final String SITE_GET_TCP_TASK_PATH = "/csm/api/v1/userId/%s/site/tcp/detail";
    private static final String SITE_CREATE_UDP_TASK_PATH = "/csm/api/v1/userId/%s/site/udp/create";
    private static final String SITE_UPDATE_UDP_TASK_PATH = "/csm/api/v1/userId/%s/site/udp/update";
    private static final String SITE_GET_UDP_TASK_PATH = "/csm/api/v1/userId/%s/site/udp/detail";
    private static final String SITE_CREATE_FTP_TASK_PATH = "/csm/api/v1/userId/%s/site/ftp/create";
    private static final String SITE_UPDATE_FTP_TASK_PATH = "/csm/api/v1/userId/%s/site/ftp/update";
    private static final String SITE_GET_FTP_TASK_PATH = "/csm/api/v1/userId/%s/site/ftp/detail";
    private static final String SITE_CREATE_DNS_TASK_PATH = "/csm/api/v1/userId/%s/site/dns/create";
    private static final String SITE_UPDATE_DNS_TASK_PATH = "/csm/api/v1/userId/%s/site/dns/update";
    private static final String SITE_GET_DNS_TASK_PATH = "/csm/api/v1/userId/%s/site/dns/detail";
    private static final String SITE_GET_TASK_LIST_PATH = "/csm/api/v1/userId/%s/site/list";
    private static final String SITE_DELETE_TASK_PATH = "/csm/api/v1/userId/%s/site/delete";
    private static final String SITE_GET_TASK_DETAIL_PATH = "/csm/api/v1/userId/%s/site/%s";
    private static final String SITE_CREATE_ALARM_CONFIG_PATH = "/csm/api/v1/userId/%s/site/alarm/config/create";
    private static final String SITE_UPDATE_ALARM_CONFIG_PATH = "/csm/api/v1/userId/%s/site/alarm/config/update";
    private static final String SITE_DELETE_ALARM_CONFIG_PATH = "/csm/api/v1/userId/%s/site/alarm/config/delete";
    private static final String SITE_GET_ALARM_CONFIG_DETAIL_PATH = "/csm/api/v1/userId/%s/site/alarm/config/detail";
    private static final String SITE_GE_TALARM_CONFIG_LIST_PATH = "/csm/api/v1/userId/%s/site/alarm/config/list";
    private static final String SITE_ALARM_BLOCK_PATH = "/csm/api/v1/userId/%s/site/alarm/config/block";
    private static final String SITE_ALARM_UNBLOCK_PATH = "/csm/api/v1/userId/%s/site/alarm/config/unblock";
    private static final String SITE_GET_TASK_BY_ALARMNAME_PATH = "/csm/api/v1/userId/%s/site/alarm/config/%s";
    private static final String SITE_GET_METRIC_DATA_PATH = "/csm/api/v1/userId/%s/site/metricSiteData";
    private static final String SITE_GET_OVERALL_VIEW_PATH = "/csm/api/v1/userId/%s/site/idc/overallView";
    private static final String SITE_GET_PROVINCIAL_VIEW_PATH = "/csm/api/v1/userId/%s/site/idc/provincialView";
    private static final String SITE_AGENT_LIST_PATH = "/csm/api/v1/userId/%s/site/agent/list";
    private static final String SITE_GET_AGENT_BY_TASKID_PATH = "/csm/api/v1/userId/%s/site/agent/idcIsp";
    private static final String APPLICATION_INFO_PATH = "/csm/api/v1/userId/%s/application";
    private static final String APPLICATION_INFO_DELETE_PATH = "/csm/api/v1/userId/%s/application/%s/delete";
    private static final String APPLICATION_INFO_LIST_PATH = "/csm/api/v1/userId/%s/instances/all";
    private static final String APPLICATION_INSTANCE_CREATE_PATH = "/csm/api/v1/userId/%s/application/instance/bind";
    private static final String APPLICATION_INSTANCE_CREATED_LIST_PATH = "/csm/api/v1/userId/%s/application/%s/instance/list";
    private static final String APPLICATION_INSTANCE_DELETE_PATH = "/csm/api/v1/userId/%s/application/%s/instance/%s/delete";
    private static final String APPLICATION_TASK_CREATE_PATH = "/csm/api/v1/userId/%s/application/task/create";
    private static final String APPLICATION_TASK_DETAIL_PATH = "/csm/api/v1/userId/%s/application/%s/task/%s";
    private static final String APPLICATION_TASK_LIST_PATH = "/csm/api/v1/userId/%s/application/%s/task/list";
    private static final String APPLICATION_TASK_DELETE_PATH = "/csm/api/v1/userId/%s/application/%s/task/%s/delete";
    private static final String APPLICATION_TASK_UPDATE_PATH = "/csm/api/v1/userId/%s/application/task/update";
    private static final String APPLICATION_DIMENSION_TABLE_CREATE_PATH = "/csm/api/v1/userId/%s/application/dimensionMap/create";
    private static final String APPLICATION_DIMENSION_TABLE_LIST_PATH = "/csm/api/v1/userId/%s/application/%s/dimensionMap/list";
    private static final String APPLICATION_DIMENSION_TABLE_DELETE_PATH = "/csm/api/v1/userId/%s/application/%s/dimensionMap/%s/delete";
    private static final String APPLICATION_DIMENSION_TABLE_UPDATE_PATH = "/csm/api/v1/userId/%s/application/dimensionMap/update";
    private static final String MULTI_DIMENSIONAL_LATEST_METRICS_PATH = "/csm/api/v2/userId/%s/services/%s/data/metricData/latest/batch";
    private static final String METRICS_BY_PARTIAL_DIMENSIONS_PATH = "/csm/api/v2/userId/%s/services/%s/data/metricData/PartialDimension";
    private static final String BATCH_GET_METRICS_PATH = "/csm/api/v2/data/metricAllData/batch";
    private static final String ALL_DATA_METRIC_V2_PATH = "/csm/api/v2/data/metricAllData";
    private static final String TOPN_PATH = "/csm/api/v2/dimensions/top";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String USER_NULL_ERROR_MESSAGE = "userId should not be null";
    private static final String REQUEST_PARAM_NULL_ERROR_MESSAGE = "param %s should not be null";
    private static final String PERIOD_ERROR_MESSAGE = "request %s should be a multiple of 60.";
    private static final String USER_ID_MESSAGE_KEY = "userId";
    private static final String ACCOUNT_ID_MESSAGE_KEY = "accountId";
    private static final String PAGE_NO_MESSAGE_KEY = "pageNo";
    private static final String PAGE_SIZE_MESSAGE_KEY = "pageSize";
    private static final String SCOPE_MESSAGE_KEY = "scope";
    private static final String STATISTICS_ARR_MESSAGE_KEY = "statistics[]";
    private static final String START_TIME_MESSAGE_KEY = "startTime";
    private static final String END_TIME_MESSAGE_KEY = "endTime";
    private static final String TIMESTAMP_MESSAGE_KEY = "timestamp";
    private static final String PERIOD_MESSAGE_KEY = "periodInSecond";
    private static final String DIMENSIONS_MESSAGE_KEY = "dimensions";
    private static final String METRIC_NAME_MESSAGE_KEY = "metricName";
    private static final String METRIC_NAMES_MESSAGE_KEY = "metricName[]";
    private static final String NAMESPACE_MESSAGE_KEY = "namespace";
    private static final String NAME_MESSAGE_KEY = "name";
    private static final String TITLE = "title";
    private static final String CONFIGURE = "configure";
    private static final String TYPE = "type";
    private static final String DASHBOARD_NAME = "dashboardName";
    private static final String WIDGET_NAME = "widgetName";
    private static final String REGION = "region";
    private static final String SERVICE = "service";
    private static final String SHOW_ID = "showId";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] BCM_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BcmJsonResponseHandler()};

    public BcmClient() {
        this(new BceClientConfiguration());
    }

    public BcmClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, BCM_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(PREFIX);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private InternalRequest createRequestWithUrl(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String url) {
        URI uri = HttpUtils.appendUri(this.getEndpoint(), url);
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private InternalRequest createBodyRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String url) {
        URI uri = HttpUtils.appendUri(this.getEndpoint(), url);
        InternalRequest request = new InternalRequest(httpMethod, uri);
        this.fillPayload(request, bceRequest);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT || internalRequest.getHttpMethod() == HttpMethodName.PATCH) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private void checkV1Request(AbstractBceRequest request, InternalRequest internalRequest, String userId, String scope, Statistics[] statistics, String startTime, String endTime, Integer periodInSecond) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(userId, StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(scope, StringFormatUtils.checkEmptyExceptionMessageFormat(SCOPE_MESSAGE_KEY));
        Preconditions.checkNotNull((Object)statistics, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(STATISTICS_ARR_MESSAGE_KEY));
        Preconditions.checkArgument((statistics.length != 0 ? 1 : 0) != 0, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(STATISTICS_ARR_MESSAGE_KEY));
        Validate.checkStringNotEmpty(startTime, StringFormatUtils.checkEmptyExceptionMessageFormat(START_TIME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(endTime, StringFormatUtils.checkEmptyExceptionMessageFormat(END_TIME_MESSAGE_KEY));
        Preconditions.checkNotNull((Object)periodInSecond, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(PERIOD_MESSAGE_KEY));
        Preconditions.checkArgument((periodInSecond / 60 != 0 ? 1 : 0) != 0, (Object)StringFormatUtils.stringFormat(PERIOD_ERROR_MESSAGE, PERIOD_MESSAGE_KEY));
        internalRequest.addParameter(STATISTICS_ARR_MESSAGE_KEY, StringUtils.join((Object[])statistics, (String)","));
        internalRequest.addParameter(START_TIME_MESSAGE_KEY, startTime);
        internalRequest.addParameter(END_TIME_MESSAGE_KEY, endTime);
        internalRequest.addParameter(PERIOD_MESSAGE_KEY, String.valueOf(periodInSecond));
    }

    public MetricDataResponse getMetricData(MetricDataRequest request) {
        Validate.checkStringNotEmpty(request.getMetricName(), StringFormatUtils.checkEmptyExceptionMessageFormat("metricName"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, V1, METRIC_DATA, request.getUserId(), request.getScope(), request.getMetricName());
        this.checkV1Request(request, internalRequest, request.getUserId(), request.getScope(), request.getStatistics(), request.getStartTime(), request.getEndTime(), request.getPeriodInSecond());
        Validate.checkStringNotEmpty(request.getDimensions(), StringFormatUtils.checkEmptyExceptionMessageFormat(DIMENSIONS_MESSAGE_KEY));
        internalRequest.addParameter(DIMENSIONS_MESSAGE_KEY, request.getDimensions());
        return this.invokeHttpClient(internalRequest, MetricDataResponse.class);
    }

    public ListMetricDataResponse getMetricData(ListMetricDataRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, V1, METRIC_DATA, "metricName", request.getUserId(), request.getScope());
        this.checkV1Request(request, internalRequest, request.getUserId(), request.getScope(), request.getStatistics(), request.getStartTime(), request.getEndTime(), request.getPeriodInSecond());
        Preconditions.checkNotNull((Object)request.getMetricNames(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(METRIC_NAMES_MESSAGE_KEY));
        Preconditions.checkArgument((request.getMetricNames().length != 0 ? 1 : 0) != 0, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(METRIC_NAMES_MESSAGE_KEY));
        internalRequest.addParameter(METRIC_NAMES_MESSAGE_KEY, StringUtils.join((Object[])request.getMetricNames(), (String)","));
        Validate.checkStringNotEmpty(request.getDimensions(), StringFormatUtils.checkEmptyExceptionMessageFormat(DIMENSIONS_MESSAGE_KEY));
        internalRequest.addParameter(DIMENSIONS_MESSAGE_KEY, request.getDimensions());
        return this.invokeHttpClient(internalRequest, ListMetricDataResponse.class);
    }

    public PushMetricDataResponse pushCustomMonitorMetricData(PushCustomMetricDataRequest request) {
        this.checkAndFormatPushCustomMetricDataRequest(request);
        String url = String.format(PUSH_CUSTOM_METRIC_DATA_FORMAT, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, PushMetricDataResponse.class);
    }

    private void checkAndFormatPushCustomMetricDataRequest(PushCustomMetricDataRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTimestamp(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        Validate.checkStringNotEmpty(request.getMetricName(), StringFormatUtils.checkEmptyExceptionMessageFormat("metricName"));
        Validate.checkStringNotEmpty(request.getTimestamp(), StringFormatUtils.checkEmptyExceptionMessageFormat(TIMESTAMP_MESSAGE_KEY));
        if (null == request.getValue() && null == request.getStatisticValues()) {
            throw new IllegalArgumentException("value and statistics all should not be null.");
        }
        if (null == request.getDimensions()) {
            request.setDimensions(Collections.emptyList());
        }
    }

    public CustomMonitorResponse createNamespace(NamespaceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
        String url = String.format(CREATE_NAMESPACE, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, CustomMonitorResponse.class);
    }

    public CustomMonitorResponse batchDeleteNamespaces(BatchDeleteNamespacesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getNames()), "names should not be empty");
        String url = String.format(BATCH_DELETE_NAMESPACES, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, CustomMonitorResponse.class);
    }

    public CustomMonitorResponse updateNamespace(NamespaceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
        String url = String.format(UPDATE_NAMESPACE, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, CustomMonitorResponse.class);
    }

    public ListNamespacesResponse listNamespaces(ListNamespacesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        if (null == request.getPageNo() || request.getPageNo() <= 0) {
            request.setPageNo(1);
        }
        if (null == request.getPageSize() || request.getPageSize() <= 0) {
            request.setPageSize(10);
        }
        String url = String.format(LIST_NAMESPACES, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("name", request.getName());
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        return this.invokeHttpClient(internalRequest, ListNamespacesResponse.class);
    }

    public CustomMonitorResponse createNamespaceMetric(NamespaceMetricRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        Validate.checkStringNotEmpty(request.getMetricName(), StringFormatUtils.checkEmptyExceptionMessageFormat("metricName"));
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (CollectionUtils.isEmpty(request.getDimensions())) {
            request.setDimensions(Collections.emptyList());
        }
        String url = String.format(CREATE_NAMESPACE_METRIC, request.getUserId(), request.getNamespace());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, CustomMonitorResponse.class);
    }

    public CustomMonitorResponse batchDeleteNamespaceMetrics(BatchDeleteNamespaceMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getIds()), "ids should not be empty");
        String url = String.format(BATCH_DELETE_NAMESPACE_METRICS, request.getUserId(), request.getNamespace());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, CustomMonitorResponse.class);
    }

    public CustomMonitorResponse updateNamespaceMetric(NamespaceMetricRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        Validate.checkStringNotEmpty(request.getMetricName(), StringFormatUtils.checkEmptyExceptionMessageFormat("metricName"));
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (CollectionUtils.isEmpty(request.getDimensions())) {
            request.setDimensions(Collections.emptyList());
        }
        String url = String.format("/csm/api/v1/userId/%s/custom/namespaces/%s/metrics/%s", request.getUserId(), request.getNamespace(), request.getMetricName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, CustomMonitorResponse.class);
    }

    public ListNamespaceMetricsResponse listNamespaceMetrics(ListNamespaceMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        if (null == request.getPageNo() || request.getPageNo() <= 0) {
            request.setPageNo(1);
        }
        if (null == request.getPageSize() || request.getPageSize() <= 0) {
            request.setPageSize(10);
        }
        String url = String.format(LIST_NAMESPACE_METRICS, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("namespace", request.getNamespace());
        internalRequest.addParameter("metricName", request.getMetricName());
        internalRequest.addParameter("metricAlias", request.getMetricAlias());
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        return this.invokeHttpClient(internalRequest, ListNamespaceMetricsResponse.class);
    }

    public GetCustomMetricResponse getCustomMetric(GetCustomMetricRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        Validate.checkStringNotEmpty(request.getMetricName(), StringFormatUtils.checkEmptyExceptionMessageFormat("metricName"));
        String url = String.format("/csm/api/v1/userId/%s/custom/namespaces/%s/metrics/%s", request.getUserId(), request.getNamespace(), request.getMetricName());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, GetCustomMetricResponse.class);
    }

    public CustomMonitorResponse createNamespaceEvent(NamespaceEventRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        Validate.checkStringNotEmpty(request.getEventName(), StringFormatUtils.checkEmptyExceptionMessageFormat(EVENT_NAME));
        Preconditions.checkNotNull((Object)((Object)request.getEventLevel()), (Object)"eventLevel should not be null");
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, CREATE_NAMESPACE_EVENT);
        return this.invokeHttpClient(internalRequest, CustomMonitorResponse.class);
    }

    public CustomMonitorResponse batchDeleteNamespaceEvents(BatchDeleteNamespaceEventsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getNames()), "names should not be empty");
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, BATCH_DELETE_NAMESPACE_EVENTS);
        return this.invokeHttpClient(internalRequest, CustomMonitorResponse.class);
    }

    public CustomMonitorResponse updateNamespaceEvent(NamespaceEventRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        Validate.checkStringNotEmpty(request.getEventName(), StringFormatUtils.checkEmptyExceptionMessageFormat(EVENT_NAME));
        Preconditions.checkNotNull((Object)((Object)request.getEventLevel()), (Object)"eventLevel should not be null");
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, UPDATE_NAMESPACE_EVENT);
        return this.invokeHttpClient(internalRequest, CustomMonitorResponse.class);
    }

    public ListNamespaceEventsResponse listNamespaceEvents(ListNamespaceEventsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        if (null == request.getPageNo() || request.getPageNo() <= 0) {
            request.setPageNo(1);
        }
        if (null == request.getPageSize() || request.getPageSize() <= 0) {
            request.setPageSize(10);
        }
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, LIST_NAMESPACE_EVENTS);
        internalRequest.addParameter("userId", request.getUserId());
        internalRequest.addParameter("namespace", request.getNamespace());
        internalRequest.addParameter("name", request.getName());
        if (null != request.getEventLevel()) {
            internalRequest.addParameter(EVENT_LEVEL, request.getEventLevel().name());
        }
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        return this.invokeHttpClient(internalRequest, ListNamespaceEventsResponse.class);
    }

    public GetCustomEventResponse getCustomEvent(GetCustomEventRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        Validate.checkStringNotEmpty(request.getEventName(), StringFormatUtils.checkEmptyExceptionMessageFormat(EVENT_NAME));
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, GET_CUSTOM_EVENT);
        internalRequest.addParameter("userId", request.getUserId());
        internalRequest.addParameter("namespace", request.getNamespace());
        internalRequest.addParameter(EVENT_NAME, request.getEventName());
        return this.invokeHttpClient(internalRequest, GetCustomEventResponse.class);
    }

    public DashboardCreateResponse createDashboard(DashboardBaseRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTitle(), StringFormatUtils.checkEmptyExceptionMessageFormat(TITLE));
        Validate.checkStringNotEmpty(request.getConfigure(), StringFormatUtils.checkEmptyExceptionMessageFormat(CONFIGURE));
        Validate.checkStringNotEmpty(request.getType(), StringFormatUtils.checkEmptyExceptionMessageFormat(TYPE));
        String url = String.format(CREATE_DASHBOARD_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, DashboardCreateResponse.class);
    }

    public DashboardCreateResponse getDashboard(DashboardBaseRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getDashboardName(), StringFormatUtils.checkEmptyExceptionMessageFormat(DASHBOARD_NAME));
        String url = String.format(DASHBOARD_PATH, request.getUserId(), request.getDashboardName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, DashboardCreateResponse.class);
    }

    public DashboardResponse updateDashboard(DashboardBaseRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getDashboardName(), StringFormatUtils.checkEmptyExceptionMessageFormat(DASHBOARD_NAME));
        Validate.checkStringNotEmpty(request.getConfigure(), StringFormatUtils.checkEmptyExceptionMessageFormat(CONFIGURE));
        String url = String.format(DASHBOARD_PATH, request.getUserId(), request.getDashboardName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, DashboardResponse.class);
    }

    public DashboardResponse deleteDashboard(DashboardBaseRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getDashboardName(), StringFormatUtils.checkEmptyExceptionMessageFormat(DASHBOARD_NAME));
        String url = String.format(DASHBOARD_PATH, request.getUserId(), request.getDashboardName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.DELETE, url);
        return this.invokeHttpClient(internalRequest, DashboardResponse.class);
    }

    public DashboardResponse duplicateDashboard(DashboardBaseRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getDashboardName(), StringFormatUtils.checkEmptyExceptionMessageFormat(DASHBOARD_NAME));
        String url = String.format(DUPLICATE_DASHBOARD_PATH, request.getUserId(), request.getDashboardName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, DashboardResponse.class);
    }

    public DashboardCreateResponse getDashboardWidget(DashboardWidgetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getDashboardName(), StringFormatUtils.checkEmptyExceptionMessageFormat(DASHBOARD_NAME));
        Validate.checkStringNotEmpty(request.getWidgetName(), StringFormatUtils.checkEmptyExceptionMessageFormat(WIDGET_NAME));
        String url = String.format(DASHBOARD_WIDGET_PATH, request.getUserId(), request.getDashboardName(), request.getWidgetName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, DashboardCreateResponse.class);
    }

    public DashboardResponse createDashboardWidget(DashboardBaseRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getDashboardName(), StringFormatUtils.checkEmptyExceptionMessageFormat(DASHBOARD_NAME));
        String url = String.format(CREATE_DASHBOARD_WIDGET_PATH, request.getUserId(), request.getDashboardName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, DashboardResponse.class);
    }

    public DashboardResponse updateDashboardWidget(DashboardWidgetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getDashboardName(), StringFormatUtils.checkEmptyExceptionMessageFormat(DASHBOARD_NAME));
        Validate.checkStringNotEmpty(request.getWidgetName(), StringFormatUtils.checkEmptyExceptionMessageFormat(WIDGET_NAME));
        String url = String.format(DASHBOARD_WIDGET_PATH, request.getUserId(), request.getDashboardName(), request.getWidgetName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, DashboardResponse.class);
    }

    public DashboardResponse deleteDashboardWidget(DashboardWidgetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getDashboardName(), StringFormatUtils.checkEmptyExceptionMessageFormat(DASHBOARD_NAME));
        Validate.checkStringNotEmpty(request.getWidgetName(), StringFormatUtils.checkEmptyExceptionMessageFormat(WIDGET_NAME));
        String url = String.format(DASHBOARD_WIDGET_PATH, request.getUserId(), request.getDashboardName(), request.getWidgetName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.DELETE, url);
        return this.invokeHttpClient(internalRequest, DashboardResponse.class);
    }

    public DashboardResponse duplicateDashboardWidget(DashboardWidgetRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getDashboardName(), StringFormatUtils.checkEmptyExceptionMessageFormat(DASHBOARD_NAME));
        Validate.checkStringNotEmpty(request.getWidgetName(), StringFormatUtils.checkEmptyExceptionMessageFormat(WIDGET_NAME));
        String url = String.format(DUPLICATE_DASHBOARD_WIDGET_PATH, request.getUserId(), request.getDashboardName(), request.getWidgetName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, DashboardResponse.class);
    }

    public DashboardReportDataResponse getDashboardReportData(DashboardDataRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, DASHBOARD_REPORT_DATA_PATH);
        return this.invokeHttpClient(internalRequest, DashboardReportDataResponse.class);
    }

    public DashboardTrendDataResponse getDashboardTrendData(DashboardDataRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, DASHBOARD_TREND_DATA_PATH);
        return this.invokeHttpClient(internalRequest, DashboardTrendDataResponse.class);
    }

    public DashboardBillboardDataResponse getDashboardGaugeChartData(DashboardDataRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, DASHBOARD_GAUGE_CHART_DATA_PATH);
        return this.invokeHttpClient(internalRequest, DashboardBillboardDataResponse.class);
    }

    public DashboardBillboardDataResponse getDashboardBillboardData(DashboardDataRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, DASHBOARD_BILLBOARD_DATA_PATH);
        return this.invokeHttpClient(internalRequest, DashboardBillboardDataResponse.class);
    }

    public DashboardTrendSeniorDataResponse getDashboardTrendSeniorData(DashboardDataRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, DASHBOARD_TREND_SENIOR_DATA_PATH);
        return this.invokeHttpClient(internalRequest, DashboardTrendSeniorDataResponse.class);
    }

    public Map<String, List<String>> getDashboardDimensions(DashboardDimensionsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        String url = String.format(DASHBOARD_DIMENSIONS_PATH, request.getUserId(), request.getService(), request.getRegion());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter(DIMENSIONS_MESSAGE_KEY, request.getDimensions());
        internalRequest.addParameter("metricName", request.getMetricName());
        internalRequest.addParameter(REGION, request.getRegion());
        internalRequest.addParameter(SERVICE, request.getService());
        internalRequest.addParameter(SHOW_ID, request.getShowId());
        return this.invokeHttpClient(internalRequest, MapListResponse.class).getResult();
    }

    public ListNotifyGroupsResponse listNotifyGroups(NotifyRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/json-api/v1/alarm/notify/group/list");
        return this.invokeHttpClient(internalRequest, ListNotifyGroupsResponse.class);
    }

    public ListNotifyPartiesResponse listNotifyParties(NotifyRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/json-api/v1/alarm/notify/party/list");
        return this.invokeHttpClient(internalRequest, ListNotifyPartiesResponse.class);
    }

    public void createAction(CreateAndUpdateActionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Preconditions.checkNotNull(request.getMembers(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("members"));
        Validate.checkStringNotEmpty(request.getAlias(), StringFormatUtils.checkEmptyExceptionMessageFormat("alias"));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getNotifications()), StringFormatUtils.checkEmptyExceptionMessageFormat("notifications"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, String.format("/csm/api/v1/userId/%s/action/create", request.getUserId()));
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public void deleteAction(DeleteActionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.DELETE, String.format("/csm/api/v1/userId/%s/action/delete", request.getUserId()));
        internalRequest.addParameter("name", request.getName());
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public void updateAction(CreateAndUpdateActionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        request.setProductName(request.getUserId());
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Preconditions.checkNotNull(request.getMembers(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("members"));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getNotifications()), StringFormatUtils.checkEmptyExceptionMessageFormat("notifications"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, String.format("/csm/api/v1/userId/%s/action/update", request.getUserId()));
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public ListActionsResponse listActions(ListActionsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkIsTrue(request.getPageNo() > 0, "pageNo should be greater than 0");
        Validate.checkIsTrue(request.getPageSize() > 0, "pageSize should be greater than 0");
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, String.format("/csm/api/v1/userId/%s/action/actionList", request.getUserId()));
        return this.invokeHttpClient(internalRequest, ListActionsResponse.class);
    }

    public List<LogExtractResult> logExtract(LogExtractRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getExtractRule(), StringFormatUtils.checkEmptyExceptionMessageFormat("extractRule"));
        Validate.checkStringNotEmpty(request.getLogExample(), StringFormatUtils.checkEmptyExceptionMessageFormat("logExample"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, String.format("/csm/api/v1/userId/%s/application/logextract", request.getUserId()));
        return this.invokeHttpClient(internalRequest, ListResponse.class).getResult();
    }

    public Map<String, List<String>> getMetricMetaForApplication(GetMetricMetaForApplicationRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAppName(), StringFormatUtils.checkEmptyExceptionMessageFormat("appName"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getMetricName(), StringFormatUtils.checkEmptyExceptionMessageFormat("metricName"));
        Validate.checkIsTrue(request.getInstances() != null && !request.getInstances().isEmpty(), "instances should not be empty");
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, String.format("/csm/api/v1/userId/%s/application/%s/task/%s/metricMeta", request.getUserId(), request.getAppName(), request.getTaskName()));
        internalRequest.addParameter("metricName", request.getMetricName());
        internalRequest.addParameter("instances", StringUtils.join(request.getInstances(), (String)","));
        internalRequest.addParameter("dimensionKeys", StringUtils.join(request.getDimensionKeys(), (String)","));
        return this.invokeHttpClient(internalRequest, MapListResponse.class).getResult();
    }

    public List<MetricDataForApplication> getMetricDataForApplication(GetMetricDataForApplicationRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAppName(), StringFormatUtils.checkEmptyExceptionMessageFormat("appName"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getMetricName(), StringFormatUtils.checkEmptyExceptionMessageFormat("metricName"));
        Validate.checkStringNotEmpty(request.getStartTime(), StringFormatUtils.checkEmptyExceptionMessageFormat(START_TIME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getEndTime(), StringFormatUtils.checkEmptyExceptionMessageFormat("endtTime"));
        Validate.checkIsTrue(!CollectionUtils.isEmpty(request.getInstances()) || !BooleanUtils.isNotTrue((Boolean)request.getAggrData()), "instances can't be empty when aggrData is false or default");
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, String.format("/csm/api/v1/userId/%s/application/%s/task/%s/metricData", request.getUserId(), request.getAppName(), request.getTaskName()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(START_TIME_MESSAGE_KEY, request.getStartTime());
        params.put(END_TIME_MESSAGE_KEY, request.getEndTime());
        params.put("metricName", request.getMetricName());
        if (CollectionUtils.isNotEmpty(request.getInstances())) {
            params.put("instances", StringUtils.join(request.getInstances(), (String)","));
        }
        if (request.getCycle() > 0) {
            params.put("cycle", String.valueOf(request.getCycle()));
        }
        if (request.getAggrData().booleanValue()) {
            params.put("aggrData", String.valueOf(true));
        }
        if (null != request.getStatistics()) {
            params.put("statistics", request.getStatistics().name());
        }
        if (MapUtils.isNotEmpty(request.getDimensions())) {
            ArrayList<String> dimensions = new ArrayList<String>();
            for (String key : request.getDimensions().keySet()) {
                List<String> values = request.getDimensions().get(key);
                dimensions.add("key:" + StringUtils.join(values, (String)"___"));
            }
            params.put(DIMENSIONS_MESSAGE_KEY, StringUtils.join(dimensions, (String)","));
        }
        internalRequest.setParameters(params);
        return this.invokeHttpClient(internalRequest, ListResponse.class).getResult();
    }

    public ApplicationAlarmConfig createAlarmConfigForApplication(CreateOrUpdateAlarmConfigForApplicationRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAppName(), StringFormatUtils.checkEmptyExceptionMessageFormat("appName"));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        Validate.checkIsTrue(request.getMonitorObjectType() == MonitorObjectType.APP || request.getMonitorObjectType() == MonitorObjectType.SERVICE, "monitorObjectType error");
        Preconditions.checkNotNull((Object)request.getMonitorObject(), (Object)"monitor object should not be null");
        Preconditions.checkNotNull((Object)((Object)request.getType()), (Object)"type should not be null");
        Preconditions.checkNotNull((Object)((Object)request.getLevel()), (Object)"level should not be null");
        Preconditions.checkNotNull((Object)request.getActionEnabled(), (Object)"actionEnabled should not be null");
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getRules()), "rules should not be null");
        Validate.checkStringNotEmpty(request.getSrcName(), StringFormatUtils.checkEmptyExceptionMessageFormat("srcName"));
        Validate.checkStringNotEmpty(request.getSrcType(), StringFormatUtils.checkEmptyExceptionMessageFormat("srcType"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, String.format("/csm/api/v1/userId/%s/application/alarm/config/create", request.getUserId()));
        return this.invokeHttpClient(internalRequest, ApplicationAlarmConfig.class);
    }

    public ApplicationAlarmConfig updateAlarmConfigForApplication(CreateOrUpdateAlarmConfigForApplicationRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAppName(), StringFormatUtils.checkEmptyExceptionMessageFormat("appName"));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        Validate.checkIsTrue(request.getMonitorObjectType() == MonitorObjectType.APP || request.getMonitorObjectType() == MonitorObjectType.SERVICE, "monitorObjectType error");
        Preconditions.checkNotNull((Object)request.getMonitorObject(), (Object)"monitor object should not be null");
        Preconditions.checkNotNull((Object)((Object)request.getType()), (Object)"type should not be null");
        Preconditions.checkNotNull((Object)((Object)request.getLevel()), (Object)"level should not be null");
        Preconditions.checkNotNull((Object)request.getActionEnabled(), (Object)"actionEnabled should not be null");
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getRules()), "rules should not be null");
        Validate.checkStringNotEmpty(request.getSrcName(), StringFormatUtils.checkEmptyExceptionMessageFormat("srcName"));
        Validate.checkStringNotEmpty(request.getSrcType(), StringFormatUtils.checkEmptyExceptionMessageFormat("srcType"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, String.format("/csm/api/v1/userId/%s/application/alarm/config/update", request.getUserId()));
        return this.invokeHttpClient(internalRequest, ApplicationAlarmConfig.class);
    }

    public Page<ApplicationAlarmConfig> listAlarmConfigForApplication(ListAlarmConfigForApplicationRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkIsTrue(request.getPageNo() > 0, "pageNo should be greater than 0");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appName", request.getAppName());
        params.put("alarmName", request.getAlarmName());
        params.put("actionEnabled", BooleanUtils.toString((Boolean)request.getActionEnabled(), (String)"true", (String)"false", (String)""));
        params.put("srcType", request.getSrcType());
        params.put("taskName", request.getTaskName());
        params.put("pageNo", String.valueOf(request.getPageNo()));
        params.put("pageSize", String.valueOf(request.getPageSize()));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, String.format("/csm/api/v1/userId/%s/application/alarm/config/list", request.getUserId()));
        internalRequest.setParameters(params);
        return this.invokeHttpClient(internalRequest, Page.class);
    }

    public void deleteAlarmConfigForApplication(DeleteAlarmConfigForApplicationRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAppName(), StringFormatUtils.checkEmptyExceptionMessageFormat("appName"));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.DELETE, String.format("/csm/api/v1/userId/%s/application/alarm/config/delete", request.getUserId()));
        internalRequest.addParameter("appName", request.getAppName());
        internalRequest.addParameter("alarmName", request.getAlarmName());
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public ApplicationAlarmConfig getAlarmConfigForApplication(GetAlarmConfigForApplicationRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAppName(), StringFormatUtils.checkEmptyExceptionMessageFormat("appName"));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, String.format("/csm/api/v1/userId/%s/application/alarm/%s/config/", request.getUserId(), request.getAlarmName()));
        internalRequest.addParameter("appName", request.getAppName());
        return this.invokeHttpClient(internalRequest, ApplicationAlarmConfig.class);
    }

    public List<ApplicationMetric> listAlarmMetricsForApplication(ListAlarmMetricsForApplicationRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAppName(), StringFormatUtils.checkEmptyExceptionMessageFormat("appName"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, String.format("/csm/api/v1/userId/%s/application/%s/%s/alarm/metrics", request.getUserId(), request.getAppName(), request.getTaskName()));
        if (null != request.getSearchName()) {
            internalRequest.addParameter("searchName", request.getSearchName());
        }
        return this.invokeHttpClient(internalRequest, ListResponse.class).getResult();
    }

    public void createAlarmConfig(CreateOrUpdateAlarmConfigRequest request) {
        this.checkCreateOrUpdateAlarmConfigRequest(request);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/services/alarm/config/create");
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public void updateAlarmConfig(CreateOrUpdateAlarmConfigRequest request) {
        this.checkCreateOrUpdateAlarmConfigRequest(request);
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/services/alarm/config/update");
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public void deleteAlarmConfig(CommonAlarmConfigRequest request) {
        this.checkCommonAlarmConfigRequest(request);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/services/alarm/config/delete");
        internalRequest.addParameter("userId", request.getUserId());
        internalRequest.addParameter(SCOPE_MESSAGE_KEY, request.getScope());
        internalRequest.addParameter("alarmName", request.getAlarmName());
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public void blockAlarmConfig(CommonAlarmConfigRequest request) {
        this.checkCommonAlarmConfigRequest(request);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/services/alarm/config/block");
        internalRequest.addParameter("userId", request.getUserId());
        internalRequest.addParameter(SCOPE_MESSAGE_KEY, request.getScope());
        internalRequest.addParameter("alarmName", request.getAlarmName());
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public void unblockAlarmConfig(CommonAlarmConfigRequest request) {
        this.checkCommonAlarmConfigRequest(request);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/services/alarm/config/unblock");
        internalRequest.addParameter("userId", request.getUserId());
        internalRequest.addParameter(SCOPE_MESSAGE_KEY, request.getScope());
        internalRequest.addParameter("alarmName", request.getAlarmName());
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public AlarmConfig getAlarmConfigDetail(CommonAlarmConfigRequest request) {
        this.checkCommonAlarmConfigRequest(request);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, "/csm/api/v1/services/alarm/config");
        internalRequest.addParameter("userId", request.getUserId());
        internalRequest.addParameter(SCOPE_MESSAGE_KEY, request.getScope());
        internalRequest.addParameter("alarmName", request.getAlarmName());
        return this.invokeHttpClient(internalRequest, AlarmConfig.class);
    }

    public Page<AlarmConfig> listSingleInstanceAlarmConfigs(ListSingleInstanceAlarmConfigsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getScope(), StringFormatUtils.checkEmptyExceptionMessageFormat(SCOPE_MESSAGE_KEY));
        Validate.checkIsTrue(request.getPageNo() > 0, "pageNo should be greater than 0");
        Validate.checkIsTrue(request.getPageSize() > 0, "pageSize should be greater than 0");
        if (StringUtils.isEmpty((String)request.getRegion())) {
            request.setRegion("bj");
        }
        if (StringUtils.isEmpty((String)request.getOrder())) {
            request.setOrder("desc");
        }
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, "/csm/api/v1/services/alarm/config/list");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", request.getUserId());
        params.put(SCOPE_MESSAGE_KEY, request.getScope());
        params.put(REGION, request.getRegion());
        params.put(DIMENSIONS_MESSAGE_KEY, request.getDimensions());
        params.put("order", request.getOrder());
        params.put("alarmNamePrefix", request.getAlarmNamePrefix());
        params.put("pageNo", String.valueOf(request.getPageNo()));
        params.put("pageSize", String.valueOf(request.getPageSize()));
        if (null != request.getActionEnabled()) {
            params.put("actionEnabled", String.valueOf(request.getActionEnabled()));
        }
        internalRequest.setParameters(params);
        return this.invokeHttpClient(internalRequest, Page.class);
    }

    public List<AlarmMetric> listAlarmMetrics(ListAlarmMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getScope(), StringFormatUtils.checkEmptyExceptionMessageFormat(SCOPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getRegion(), "region should not be empty");
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, "/csm/api/v1/services/alarm/config/metrics");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", request.getUserId());
        params.put(SCOPE_MESSAGE_KEY, request.getScope());
        params.put(REGION, request.getRegion());
        params.put(DIMENSIONS_MESSAGE_KEY, request.getDimensions());
        params.put(TYPE, request.getType());
        params.put("locale", request.getLocale());
        internalRequest.setParameters(params);
        return this.invokeHttpClient(internalRequest, ListResponse.class).getResult();
    }

    public CreateAlarmConfigV2Response createAlarmPolicyV2(CreateOrUpdateAlarmConfigV2Request request) {
        this.checkCreateOrUpdateAlarmConfigV2Request(request);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, String.format("/csm/api/v2/userId/%s/services/%s/alarm/config/create", request.getUserId(), request.getScope()));
        return this.invokeHttpClient(internalRequest, CreateAlarmConfigV2Response.class);
    }

    public void updateAlarmPolicyV2(CreateOrUpdateAlarmConfigV2Request request) {
        this.checkCreateOrUpdateAlarmConfigV2Request(request);
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, String.format("/csm/api/v2/userId/%s/services/%s/alarm/config/update", request.getUserId(), request.getScope()));
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public void blockAlarmConfigV2(CommonAlarmConfigRequest request) {
        this.checkCommonAlarmConfigRequest(request);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, String.format("/csm/api/v2/userId/%s/services/%s/alarm/config/block", request.getUserId(), request.getScope()));
        internalRequest.addParameter("alarmName", request.getAlarmName());
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public void unblockAlarmConfigV2(CommonAlarmConfigRequest request) {
        this.checkCommonAlarmConfigRequest(request);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, String.format("/csm/api/v2/userId/%s/services/%s/alarm/config/unblock", request.getUserId(), request.getScope()));
        internalRequest.addParameter("alarmName", request.getAlarmName());
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public AlarmConfigV2 getAlarmPolicyDetailV2(CommonAlarmConfigRequest request) {
        this.checkCommonAlarmConfigRequest(request);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, String.format("/csm/api/v2/userId/%s/services/%s/alarm/config", request.getUserId(), request.getScope()));
        internalRequest.addParameter("alarmName", request.getAlarmName());
        return this.invokeHttpClient(internalRequest, AlarmConfigV2.class);
    }

    private void checkCreateOrUpdateAlarmConfigV2Request(CreateOrUpdateAlarmConfigV2Request request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getScope(), StringFormatUtils.checkEmptyExceptionMessageFormat(SCOPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAliasName(), StringFormatUtils.checkEmptyExceptionMessageFormat("aliasName"));
        TargetType targetType = request.getTargetType();
        Validate.checkIsTrue(TargetType.TARGET_TYPE_ALL_INSTANCES == targetType || TargetType.TARGET_TYPE_INSTANCE_GROUP == targetType || TargetType.TARGET_TYPE_MULTI_INSTANCES == targetType || TargetType.TARGET_TYPE_INSTANCE_TAGS == targetType, "targetType is invalid");
        if (TargetType.TARGET_TYPE_INSTANCE_GROUP == targetType) {
            Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getTargetInstanceGroups()), "targetInstanceGroups should not be empty");
        }
        if (TargetType.TARGET_TYPE_MULTI_INSTANCES == targetType) {
            Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getTargetInstances()), "targetInstances should not be empty");
        }
        if (TargetType.TARGET_TYPE_INSTANCE_TAGS == targetType) {
            Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getTargetInstanceTags()), "targetInstanceTags should not be empty");
        }
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getPolicies()), "policies should not be empty");
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getActions()), "actions should not be empty");
    }

    private void checkCreateOrUpdateAlarmConfigRequest(CreateOrUpdateAlarmConfigRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getScope(), StringFormatUtils.checkEmptyExceptionMessageFormat(SCOPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAliasName(), StringFormatUtils.checkEmptyExceptionMessageFormat("aliasName"));
        Preconditions.checkNotNull((Object)request.getMonitorObject(), (Object)"monitorObject should not be null");
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getAlarmActions()), "alarmActions should not be empty");
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getRules()), "rules should not be empty");
    }

    private void checkCommonAlarmConfigRequest(CommonAlarmConfigRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getScope(), StringFormatUtils.checkEmptyExceptionMessageFormat(SCOPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
    }

    public CloudEventResponse getCloudEventData(EventDataRequest request) {
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, CLOUD_EVENT_LIST_PATH);
        this.checkEventDataRequest(request, internalRequest, EventType.Cloud);
        return this.invokeHttpClient(internalRequest, CloudEventResponse.class);
    }

    public PlatformEventResponse getPlatformEventData(EventDataRequest request) {
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, PLATFORM_EVENT_LIST_PATH);
        this.checkEventDataRequest(request, internalRequest, EventType.Platform);
        return this.invokeHttpClient(internalRequest, PlatformEventResponse.class);
    }

    public EventPolicyResponse createEventPolicy(EventPolicy eventPolicy) {
        this.checkEventPolicy(eventPolicy);
        String url = String.format(EVENT_POLICY_PATH, eventPolicy.getAccountId(), eventPolicy.getServiceName());
        InternalRequest internalRequest = this.createBodyRequest(eventPolicy, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, EventPolicyResponse.class);
    }

    public InstanceGroupResponse instanceGroupCreate(MergedGroup mergedGroup) {
        this.checkMergedGroup(mergedGroup);
        String url = String.format(INSTANCE_GROUP_PATH, mergedGroup.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(mergedGroup, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, InstanceGroupResponse.class);
    }

    public InstanceGroupResponse instanceGroupUpdate(InstanceGroup instanceGroup) {
        this.checkInstanceGroup(instanceGroup);
        String url = String.format(INSTANCE_GROUP_PATH, instanceGroup.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(instanceGroup, HttpMethodName.PATCH, url);
        return this.invokeHttpClient(internalRequest, InstanceGroupResponse.class);
    }

    public InstanceGroupResponse instanceGroupDelete(InstanceGroupBase instanceGroupBase) {
        this.checkInstanceGroupBase(instanceGroupBase);
        String url = String.format(INSTANCE_GROUP_ID_PATH, instanceGroupBase.getUserId(), instanceGroupBase.getId());
        InternalRequest internalRequest = this.createBodyRequest(instanceGroupBase, HttpMethodName.DELETE, url);
        return this.invokeHttpClient(internalRequest, InstanceGroupResponse.class);
    }

    public InstanceGroupResponse instanceGroupGet(InstanceGroupBase instanceGroupBase) {
        this.checkInstanceGroupBase(instanceGroupBase);
        String url = String.format(INSTANCE_GROUP_ID_PATH, instanceGroupBase.getUserId(), instanceGroupBase.getId());
        InternalRequest internalRequest = this.createBodyRequest(instanceGroupBase, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, InstanceGroupResponse.class);
    }

    public InstanceGroupListResponse instanceGroupList(InstanceGroupQuery instanceGroupQuery) {
        this.checkInstanceGroupQuery(instanceGroupQuery);
        String url = String.format(INSTANCE_GROUP_LIST_PATH, instanceGroupQuery.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(instanceGroupQuery, HttpMethodName.GET, url);
        this.buildInstanceGroupQueryParams(instanceGroupQuery, internalRequest);
        return this.invokeHttpClient(internalRequest, InstanceGroupListResponse.class);
    }

    public InstanceGroupResponse instanceGroupAddInstance(MergedGroup mergedGroup) {
        this.checkMergedGroup(mergedGroup);
        String url = String.format(IG_INSTANCE_ADD, mergedGroup.getUserId(), mergedGroup.getId());
        InternalRequest internalRequest = this.createBodyRequest(mergedGroup, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, InstanceGroupResponse.class);
    }

    public InstanceGroupResponse instanceGroupRemoveInstance(MergedGroup mergedGroup) {
        this.checkMergedGroup(mergedGroup);
        String url = String.format(IG_INSTANCE_REMOVE, mergedGroup.getUserId(), mergedGroup.getId());
        InternalRequest internalRequest = this.createBodyRequest(mergedGroup, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, InstanceGroupResponse.class);
    }

    public IGInstanceListResponse instanceGroupGetInstanceList(IGInstanceQuery igInstanceQuery) {
        this.checkIGInstanceQuery(igInstanceQuery, IGInstanceQueryType.INCLUDE);
        String url = String.format(IG_INSTANCE_LIST, igInstanceQuery.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(igInstanceQuery, HttpMethodName.GET, url);
        this.buildIGInstanceQueryParams(igInstanceQuery, internalRequest, IGInstanceQueryType.INCLUDE);
        return this.invokeHttpClient(internalRequest, IGInstanceListResponse.class);
    }

    public IGInstanceListResponse instanceGroupQueryInstanceList(IGInstanceQuery igInstanceQuery) {
        this.checkIGInstanceQuery(igInstanceQuery, IGInstanceQueryType.ALL);
        String url = String.format(IG_QUERY_INSTANCE_LIST, igInstanceQuery.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(igInstanceQuery, HttpMethodName.GET, url);
        this.buildIGInstanceQueryParams(igInstanceQuery, internalRequest, IGInstanceQueryType.ALL);
        return this.invokeHttpClient(internalRequest, IGInstanceListResponse.class);
    }

    public IGInstanceListResponse instanceGroupQueryInstanceListFilter(IGInstanceQuery igInstanceQuery) {
        this.checkIGInstanceQuery(igInstanceQuery, IGInstanceQueryType.FILTER);
        String url = String.format(IG_QUERY_INSTANCE_LIST_FILTER, igInstanceQuery.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(igInstanceQuery, HttpMethodName.GET, url);
        this.buildIGInstanceQueryParams(igInstanceQuery, internalRequest, IGInstanceQueryType.FILTER);
        return this.invokeHttpClient(internalRequest, IGInstanceListResponse.class);
    }

    private void checkIGInstanceQuery(IGInstanceQuery igInstanceQuery, IGInstanceQueryType type) {
        Preconditions.checkNotNull((Object)igInstanceQuery, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(igInstanceQuery.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Preconditions.checkNotNull((Object)igInstanceQuery.getPageNo(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("pageNo"));
        Preconditions.checkNotNull((Object)igInstanceQuery.getPageSize(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("pageSize"));
        Validate.checkStringNotEmpty(igInstanceQuery.getServiceName(), StringFormatUtils.checkEmptyExceptionMessageFormat("serviceName"));
        Validate.checkStringNotEmpty(igInstanceQuery.getTypeName(), StringFormatUtils.checkEmptyExceptionMessageFormat("typeName"));
        Validate.checkStringNotEmpty(igInstanceQuery.getRegion(), StringFormatUtils.checkEmptyExceptionMessageFormat(REGION));
        Preconditions.checkNotNull((Object)((Object)igInstanceQuery.getViewType()), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("viewType"));
        if (IGInstanceQueryType.INCLUDE.equals((Object)type)) {
            Preconditions.checkNotNull((Object)igInstanceQuery.getId(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("id"));
        }
        if (IGInstanceQueryType.FILTER.equals((Object)type)) {
            Preconditions.checkNotNull((Object)igInstanceQuery.getId(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("id"));
            Validate.checkStringNotEmpty(igInstanceQuery.getUuid(), StringFormatUtils.checkEmptyExceptionMessageFormat("uuid"));
        }
    }

    private void buildIGInstanceQueryParams(IGInstanceQuery igInstanceQuery, InternalRequest internalRequest, IGInstanceQueryType type) {
        internalRequest.addParameter("pageNo", String.valueOf(igInstanceQuery.getPageNo()));
        internalRequest.addParameter("pageSize", String.valueOf(igInstanceQuery.getPageSize()));
        internalRequest.addParameter("serviceName", igInstanceQuery.getServiceName());
        internalRequest.addParameter("typeName", igInstanceQuery.getTypeName());
        internalRequest.addParameter(REGION, igInstanceQuery.getRegion());
        internalRequest.addParameter("viewType", igInstanceQuery.getViewType().toString());
        if (IGInstanceQueryType.INCLUDE.equals((Object)type)) {
            internalRequest.addParameter("id", String.valueOf(igInstanceQuery.getId()));
        }
        if (IGInstanceQueryType.ALL.equals((Object)type)) {
            internalRequest.addParameter("keywordType", igInstanceQuery.getKeywordType());
            internalRequest.addParameter("keyword", igInstanceQuery.getKeyword());
        }
        if (IGInstanceQueryType.FILTER.equals((Object)type)) {
            internalRequest.addParameter("keywordType", igInstanceQuery.getKeywordType());
            internalRequest.addParameter("keyword", igInstanceQuery.getKeyword());
            internalRequest.addParameter("id", String.valueOf(igInstanceQuery.getId()));
            internalRequest.addParameter("uuid", igInstanceQuery.getUuid());
        }
    }

    private void checkInstanceGroupQuery(InstanceGroupQuery instanceGroupQuery) {
        Preconditions.checkNotNull((Object)instanceGroupQuery, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(instanceGroupQuery.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Preconditions.checkNotNull((Object)instanceGroupQuery.getPageNo(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("pageNo"));
        Preconditions.checkNotNull((Object)instanceGroupQuery.getPageSize(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("pageSize"));
    }

    private void buildInstanceGroupQueryParams(InstanceGroupQuery instanceGroupQuery, InternalRequest internalRequest) {
        internalRequest.addParameter("pageNo", String.valueOf(instanceGroupQuery.getPageNo()));
        internalRequest.addParameter("pageSize", String.valueOf(instanceGroupQuery.getPageSize()));
        if (Strings.isNotEmpty((String)instanceGroupQuery.getName())) {
            internalRequest.addParameter("name", instanceGroupQuery.getName());
        }
        if (Strings.isNotEmpty((String)instanceGroupQuery.getServiceName())) {
            internalRequest.addParameter("serviceName", instanceGroupQuery.getServiceName());
        }
        if (Strings.isNotEmpty((String)instanceGroupQuery.getRegion())) {
            internalRequest.addParameter(REGION, instanceGroupQuery.getRegion());
        }
        if (Strings.isNotEmpty((String)instanceGroupQuery.getTypeName())) {
            internalRequest.addParameter("typeName", instanceGroupQuery.getTypeName());
        }
    }

    private void checkInstanceGroupBase(InstanceGroupBase instanceGroupBase) {
        Preconditions.checkNotNull((Object)instanceGroupBase, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(instanceGroupBase.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(instanceGroupBase.getId(), StringFormatUtils.checkEmptyExceptionMessageFormat("id"));
    }

    private void checkInstanceGroup(InstanceGroup instanceGroup) {
        Preconditions.checkNotNull((Object)instanceGroup, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull((Object)instanceGroup.getId(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("id"));
        Validate.checkStringNotEmpty(instanceGroup.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
        Validate.checkStringNotEmpty(instanceGroup.getServiceName(), StringFormatUtils.checkEmptyExceptionMessageFormat("serviceName"));
        Validate.checkStringNotEmpty(instanceGroup.getTypeName(), StringFormatUtils.checkEmptyExceptionMessageFormat("typeName"));
        Validate.checkStringNotEmpty(instanceGroup.getRegion(), StringFormatUtils.checkEmptyExceptionMessageFormat(REGION));
    }

    private void checkMergedGroup(MergedGroup mergedGroup) {
        Preconditions.checkNotNull((Object)mergedGroup, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(mergedGroup.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(mergedGroup.getRegion(), StringFormatUtils.checkEmptyExceptionMessageFormat(REGION));
        Validate.checkStringNotEmpty(mergedGroup.getServiceName(), StringFormatUtils.checkEmptyExceptionMessageFormat("serviceName"));
        Validate.checkStringNotEmpty(mergedGroup.getTypeName(), StringFormatUtils.checkEmptyExceptionMessageFormat("typeName"));
        Validate.checkStringNotEmpty(mergedGroup.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
    }

    private void checkEventPolicy(EventPolicy eventPolicy) {
        Preconditions.checkNotNull((Object)eventPolicy, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(eventPolicy.getAccountId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ACCOUNT_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(eventPolicy.getServiceName(), StringFormatUtils.checkEmptyExceptionMessageFormat("serviceName"));
        Validate.checkStringNotEmpty(eventPolicy.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
        Preconditions.checkNotNull((Object)((Object)eventPolicy.getBlockStatus()), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("blockStatus"));
        EventFilter eventFilter = eventPolicy.getEventFilter();
        Preconditions.checkNotNull((Object)eventFilter, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("eventFilter"));
        Preconditions.checkNotNull((Object)((Object)eventFilter.getEventLevel()), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(EVENT_LEVEL));
        Preconditions.checkNotNull(eventFilter.getEventTypeList(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("eventTypeList"));
        Preconditions.checkArgument((eventFilter.getEventTypeList().size() != 0 ? 1 : 0) != 0, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("eventTypeList"));
        EventResourceFilter resource = eventPolicy.getResource();
        Preconditions.checkNotNull((Object)resource, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("resource"));
        Validate.checkStringNotEmpty(resource.getRegion(), StringFormatUtils.checkEmptyExceptionMessageFormat("resource.region"));
        Validate.checkStringNotEmpty(resource.getType(), StringFormatUtils.checkEmptyExceptionMessageFormat("resource.type"));
        Preconditions.checkNotNull(eventPolicy.getIncidentActions(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("incidentActions"));
        Preconditions.checkArgument((eventPolicy.getIncidentActions().size() != 0 ? 1 : 0) != 0, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("incidentActions"));
    }

    private void checkEventDataRequest(EventDataRequest request, InternalRequest internalRequest, EventType type) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull((Object)request.getPageNo(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("pageNo"));
        Preconditions.checkNotNull((Object)request.getPageSize(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("pageSize"));
        Validate.checkStringNotEmpty(request.getAccountId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ACCOUNT_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getStartTime(), StringFormatUtils.checkEmptyExceptionMessageFormat(START_TIME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getEndTime(), StringFormatUtils.checkEmptyExceptionMessageFormat(END_TIME_MESSAGE_KEY));
        this.checkUTC(request.getStartTime());
        this.checkUTC(request.getEndTime());
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        internalRequest.addParameter(ACCOUNT_ID_MESSAGE_KEY, request.getAccountId());
        internalRequest.addParameter(START_TIME_MESSAGE_KEY, request.getStartTime());
        internalRequest.addParameter(END_TIME_MESSAGE_KEY, request.getEndTime());
        if (request.getAscending() != null) {
            internalRequest.addParameter("ascending", String.valueOf(request.getAscending()));
        }
        if (EventType.Cloud.equals((Object)type) && Strings.isNotEmpty((String)request.getScope())) {
            internalRequest.addParameter(SCOPE_MESSAGE_KEY, request.getScope());
        }
        if (Strings.isNotEmpty((String)request.getRegion())) {
            internalRequest.addParameter(REGION, request.getRegion());
        }
        if (request.getEventLevel() != null && EventLevel.ALL != request.getEventLevel()) {
            internalRequest.addParameter(EVENT_LEVEL, request.getEventLevel().getName());
        }
        if (EventType.Cloud.equals((Object)type) && Strings.isNotEmpty((String)request.getResourceType())) {
            internalRequest.addParameter("resourceType", request.getResourceType());
        }
        if (EventType.Cloud.equals((Object)type) && Strings.isNotEmpty((String)request.getResourceId())) {
            internalRequest.addParameter("resourceId", request.getResourceId());
        }
        if (Strings.isNotEmpty((String)request.getEventName())) {
            internalRequest.addParameter(EVENT_NAME, request.getEventName());
        }
        if (Strings.isNotEmpty((String)request.getEventAlias())) {
            internalRequest.addParameter("eventAlias", request.getEventAlias());
        }
        if (Strings.isNotEmpty((String)request.getEventId())) {
            internalRequest.addParameter("eventId", request.getEventId());
        }
    }

    private void checkUTC(String time) {
        String utcPattern = "^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z$";
        Validate.checkPattern(time, utcPattern, "time should be UTC format");
    }

    public TaskResponse createHttpSiteTask(HttpTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getMethod(), StringFormatUtils.checkEmptyExceptionMessageFormat("method"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        String url = String.format(SITE_CREATE_HTTP_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public TaskResponse updateHttpSiteTask(HttpTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getMethod(), StringFormatUtils.checkEmptyExceptionMessageFormat("method"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        String url = String.format(SITE_UPDATE_HTTP_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public HttpTaskResponse getHttpSiteTask(TaskDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        String url = String.format(SITE_GET_HTTP_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("taskId", request.getTaskId());
        return this.invokeHttpClient(internalRequest, HttpTaskResponse.class);
    }

    public TaskResponse createHttpsSiteTask(HttpsTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getMethod(), StringFormatUtils.checkEmptyExceptionMessageFormat("method"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        String url = String.format(SITE_CREATE_HTTPS_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public TaskResponse updateHttpsSiteTask(HttpsTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getMethod(), StringFormatUtils.checkEmptyExceptionMessageFormat("method"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        String url = String.format(SITE_UPDATE_HTTPS_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public HttpsTaskResponse getHttpsSiteTask(TaskDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        String url = String.format(SITE_GET_HTTPS_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("taskId", request.getTaskId());
        return this.invokeHttpClient(internalRequest, HttpsTaskResponse.class);
    }

    public TaskResponse createPingSiteTask(PingTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("timeout should not greater 0");
        }
        String url = String.format(SITE_CREATE_PING_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public TaskResponse updatePingSiteTask(PingTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("timeout should not greater 0");
        }
        String url = String.format(SITE_UPDATE_PING_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public PingTaskResponse getPingSiteTask(TaskDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        String url = String.format(SITE_GET_PING_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("taskId", request.getTaskId());
        return this.invokeHttpClient(internalRequest, PingTaskResponse.class);
    }

    public TaskResponse createTcpSiteTask(TcpTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (request.getPort() <= 0) {
            throw new IllegalArgumentException("port should not greater 0");
        }
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("timeout should not greater 0");
        }
        String url = String.format(SITE_CREATE_TCP_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public TaskResponse updateTcpSiteTask(TcpTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (request.getPort() <= 0) {
            throw new IllegalArgumentException("port should not greater 0");
        }
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("timeout should not greater 0");
        }
        String url = String.format(SITE_UPDATE_TCP_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public TcpTaskResponse getTcpSiteTask(TaskDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        String url = String.format(SITE_GET_TCP_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("taskId", request.getTaskId());
        return this.invokeHttpClient(internalRequest, TcpTaskResponse.class);
    }

    public TaskResponse createUdpSiteTask(UdpTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (request.getPort() <= 0) {
            throw new IllegalArgumentException("port should not greater 0");
        }
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("timeout should not greater 0");
        }
        String url = String.format(SITE_CREATE_UDP_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public TaskResponse updateUdpSiteTask(UdpTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (request.getPort() <= 0) {
            throw new IllegalArgumentException("port should not greater 0");
        }
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("timeout should not greater 0");
        }
        String url = String.format(SITE_UPDATE_UDP_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public UdpTaskResponse getUdpSiteTask(TaskDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        String url = String.format(SITE_GET_UDP_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("taskId", request.getTaskId());
        return this.invokeHttpClient(internalRequest, UdpTaskResponse.class);
    }

    public TaskResponse createFtpSiteTask(FtpTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (request.getPort() <= 0) {
            throw new IllegalArgumentException("port should not greater 0");
        }
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("timeout should not greater 0");
        }
        String url = String.format(SITE_CREATE_FTP_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public TaskResponse updateFtpSiteTask(FtpTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (request.getPort() <= 0) {
            throw new IllegalArgumentException("port should not greater 0");
        }
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("timeout should not greater 0");
        }
        String url = String.format(SITE_UPDATE_FTP_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public FtpTaskResponse getFtpSiteTask(TaskDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        String url = String.format(SITE_GET_FTP_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("taskId", request.getTaskId());
        return this.invokeHttpClient(internalRequest, FtpTaskResponse.class);
    }

    public TaskResponse createDnsSiteTask(DnsTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("timeout should not greater 0");
        }
        String url = String.format(SITE_CREATE_DNS_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public TaskResponse updateDnsSiteTask(DnsTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskName(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskName"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (null == request.getCycle() || request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        if (request.getTimeout() <= 0) {
            throw new IllegalArgumentException("timeout should not greater 0");
        }
        String url = String.format(SITE_UPDATE_DNS_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, TaskResponse.class);
    }

    public DnsTaskResponse getDnsSiteTask(TaskDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        String url = String.format(SITE_GET_DNS_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("taskId", request.getTaskId());
        return this.invokeHttpClient(internalRequest, DnsTaskResponse.class);
    }

    public PageData<TaskSummaryResponse> getSiteTaskList(TaskSummaryRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        if (request.getPageNo() <= 0) {
            throw new IllegalArgumentException("pageNo should not greater 0");
        }
        if (request.getPageSize() <= 0) {
            throw new IllegalArgumentException("pageSize should not greater 0");
        }
        String url = String.format(SITE_GET_TASK_LIST_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageNo", String.valueOf(request.getPageNo()));
        params.put("pageSize", String.valueOf(request.getPageSize()));
        params.put("query", request.getQuery());
        internalRequest.setParameters(params);
        return this.invokeHttpClient(internalRequest, PageData.class);
    }

    public SiteBasicResponse deleteSiteTask(SiteTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        String url = String.format(SITE_DELETE_TASK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.DELETE, url);
        internalRequest.addParameter("taskId", request.getTaskId());
        return this.invokeHttpClient(internalRequest, SiteBasicResponse.class);
    }

    public SiteInfoResponse getSiteInfo(SiteTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        String url = String.format(SITE_GET_TASK_DETAIL_PATH, request.getUserId(), request.getTaskId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, SiteInfoResponse.class);
    }

    public void createSiteAlarmConfig(SiteAlarmConfigRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAliasName(), StringFormatUtils.checkEmptyExceptionMessageFormat("aliasName"));
        Preconditions.checkNotNull((Object)((Object)request.getLevel()), (Object)"level should not be null");
        Preconditions.checkArgument((request.getRules().size() != 0 ? 1 : 0) != 0, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("rules"));
        List<SiteAlarmRule> rules = request.getRules();
        for (SiteAlarmRule rule : rules) {
            if (!CollectionUtils.isEmpty(rule.getActOnIdcs()) || !CollectionUtils.isEmpty(rule.getActOnIsps())) continue;
            Validate.checkStringNotEmpty(null, StringFormatUtils.checkEmptyExceptionMessageFormat("idc or isp"));
        }
        String url = String.format(SITE_CREATE_ALARM_CONFIG_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public void updateSiteAlarmConfig(SiteAlarmConfigRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        Validate.checkStringNotEmpty(request.getAliasName(), StringFormatUtils.checkEmptyExceptionMessageFormat("aliasName"));
        Preconditions.checkNotNull((Object)((Object)request.getLevel()), (Object)"level should not be null");
        Preconditions.checkArgument((request.getRules().size() != 0 ? 1 : 0) != 0, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("rules"));
        List<SiteAlarmRule> rules = request.getRules();
        for (SiteAlarmRule rule : rules) {
            if (!CollectionUtils.isEmpty(rule.getActOnIdcs()) || !CollectionUtils.isEmpty(rule.getActOnIsps())) continue;
            Validate.checkStringNotEmpty(null, StringFormatUtils.checkEmptyExceptionMessageFormat("idc or isp"));
        }
        String url = String.format(SITE_UPDATE_ALARM_CONFIG_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public SiteAlarmConfigDetailResponse getSiteAlarmConfigDetail(SiteAlarmUserIdRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        String url = String.format(SITE_GET_ALARM_CONFIG_DETAIL_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("alarmName", request.getAlarmName());
        return this.invokeHttpClient(internalRequest, SiteAlarmConfigDetailResponse.class);
    }

    public PageResultResponse<SiteAlarmConfigDetailResponse> getSiteAlarmConfigList(SiteAlarmConfigListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        if (request.getPageNo() <= 0) {
            throw new IllegalArgumentException("pageNo should not greater 0");
        }
        if (request.getPageSize() <= 0) {
            throw new IllegalArgumentException("pageSize should not greater 0");
        }
        String url = String.format(SITE_GE_TALARM_CONFIG_LIST_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        if (!StringUtils.isEmpty((String)request.getAliasName())) {
            internalRequest.addParameter("aliasName", request.getAliasName());
        }
        if (!StringUtils.isEmpty((String)request.getTaskId())) {
            internalRequest.addParameter("taskId", request.getTaskId());
        }
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        internalRequest.addParameter("actionEnabled", String.valueOf(request.isActionEnabled()));
        return this.invokeHttpClient(internalRequest, PageResultResponse.class);
    }

    public void blockSiteAlarmConfig(SiteAlarmUserIdRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        String url = String.format(SITE_ALARM_BLOCK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.POST, url);
        internalRequest.addParameter("alarmName", request.getAlarmName());
        internalRequest.addParameter("namespace", request.getNamespace());
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public void unblockSiteAlarmConfig(SiteAlarmUserIdRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        String url = String.format(SITE_ALARM_UNBLOCK_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.POST, url);
        internalRequest.addParameter("alarmName", request.getAlarmName());
        internalRequest.addParameter("namespace", request.getNamespace());
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public SiteInfoResponse getSiteConfigByAlarmName(SiteAlarmUserIdRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        String url = String.format(SITE_GET_TASK_BY_ALARMNAME_PATH, request.getUserId(), request.getAlarmName());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, SiteInfoResponse.class);
    }

    public List<SiteMetricDataQueryResponse> getSiteMetricSiteData(SiteMetricDataQueryRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getMetricName(), StringFormatUtils.checkEmptyExceptionMessageFormat("metricName"));
        Validate.checkStringNotEmpty(request.getStartTime(), StringFormatUtils.checkEmptyExceptionMessageFormat(START_TIME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getEndTime(), StringFormatUtils.checkEmptyExceptionMessageFormat(END_TIME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        Preconditions.checkNotNull((Object)request.getStatistics(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("statistics"));
        if (request.getCycle() <= 0) {
            throw new IllegalArgumentException("cycle should not greater 0");
        }
        String url = String.format(SITE_GET_METRIC_DATA_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("metricName", request.getMetricName());
        internalRequest.addParameter("taskId", request.getTaskId());
        internalRequest.addParameter("statistics", StringUtils.join((Object[])request.getStatistics(), (String)","));
        internalRequest.addParameter(START_TIME_MESSAGE_KEY, request.getStartTime());
        internalRequest.addParameter(END_TIME_MESSAGE_KEY, request.getEndTime());
        internalRequest.addParameter("cycle", String.valueOf(request.getCycle()));
        if (!StringUtils.isEmpty((String)request.getDimensions())) {
            internalRequest.addParameter(DIMENSIONS_MESSAGE_KEY, request.getDimensions());
        }
        return this.invokeHttpClient(internalRequest, ListResponse.class).getResult();
    }

    public List<SiteViewResponse> getSiteOverallView(SiteTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        String url = String.format(SITE_GET_OVERALL_VIEW_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("taskId", request.getTaskId());
        return this.invokeHttpClient(internalRequest, ListResponse.class).getResult();
    }

    public List<SiteViewResponse> getSiteProvincialView(SiteTaskIspRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getTaskId(), StringFormatUtils.checkEmptyExceptionMessageFormat("taskId"));
        Validate.checkStringNotEmpty(request.getIsp(), StringFormatUtils.checkEmptyExceptionMessageFormat("isp"));
        String url = String.format(SITE_GET_PROVINCIAL_VIEW_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("taskId", request.getTaskId());
        internalRequest.addParameter("isp", request.getIsp());
        return this.invokeHttpClient(internalRequest, ListResponse.class).getResult();
    }

    public List<SiteAgentResponse> getSiteAgentList(SiteAgentRequest request) {
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        String url = String.format(SITE_AGENT_LIST_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListResponse.class).getResult();
    }

    public IdcIspResponse getSiteAgentListByTaskId(SiteTaskRequest request) {
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        String url = String.format(SITE_GET_AGENT_BY_TASKID_PATH, request.getUserId());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        internalRequest.addParameter("taskId", request.getTaskId());
        return this.invokeHttpClient(internalRequest, IdcIspResponse.class);
    }

    public void createCustomAlarmConfig(CustomAlarmConfigRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkIsTrue(request.getActionEnabled() != null, "actionEnabled should not be null");
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        Validate.checkIsTrue(request.getLevel() != null, "level should not be null");
        Validate.checkIsTrue(request.getRules() != null, "rules should not be null");
        for (CustomAlarmRule rule : request.getRules()) {
            this.checkCustomAlarmRule(rule);
        }
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/custom/alarm/configs/create");
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    private void checkCustomAlarmRule(CustomAlarmRule rule) {
        Validate.checkStringNotEmpty(rule.getMetricName(), StringFormatUtils.checkEmptyExceptionMessageFormat("metricName"));
        Validate.checkIsTrue(rule.getCycle() > 0, "cycle need large 0");
        Validate.checkStringNotEmpty(rule.getStatistics(), StringFormatUtils.checkEmptyExceptionMessageFormat("statistics"));
        Validate.checkStringNotEmpty(rule.getComparisonOperator(), StringFormatUtils.checkEmptyExceptionMessageFormat("comparisonOperator"));
        Validate.checkStringNotEmpty(rule.getFunction(), StringFormatUtils.checkEmptyExceptionMessageFormat("comparisonOperator"));
        Validate.checkIsTrue(rule.getFunction() == "THRESHOLD", "function should be THRESHOLD");
    }

    public void deleteCustomAlarmConfig(AlarmPolicyBatchListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull(request.getCustomAlarmList(), (Object)"customAlarmList should not be null");
        for (AlarmPolicyBatch config : request.getCustomAlarmList()) {
            Validate.checkStringNotEmpty(config.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
            Validate.checkStringNotEmpty(config.getScope(), StringFormatUtils.checkEmptyExceptionMessageFormat(SCOPE_MESSAGE_KEY));
            Validate.checkIsTrue(config.getAlarmName() != null, "alarmName should not be null");
        }
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/custom/alarm/configs/delete");
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public void updateCustomAlarmConfig(CustomAlarmConfigRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkIsTrue(request.getActionEnabled() != null, "actionEnabled should not be null");
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        Validate.checkIsTrue(request.getLevel() != null, "level should not be null");
        Validate.checkIsTrue(request.getRules() != null, "rules should not be null");
        for (CustomAlarmRule rule : request.getRules()) {
            this.checkCustomAlarmRule(rule);
        }
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, "/csm/api/v1/custom/alarm/configs/update");
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public ListCustomConfigResponse listCustomAlarmConfig(ListCustomAlarmConfigRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        if (request.getPageNo() == 0) {
            request.setPageNo(1);
        }
        if (request.getPageSize() == 0) {
            request.setPageSize(10);
        }
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, "/csm/api/v1/custom/alarm/configs/list");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", request.getUserId());
        if (null != request.getAlarmName()) {
            params.put("alarmName", request.getAlarmName());
        }
        if (null != request.getNamespace()) {
            params.put("namespace", request.getNamespace());
        }
        params.put("pageNo", String.valueOf(request.getPageNo()));
        params.put("pageSize", String.valueOf(request.getPageSize()));
        if (null != request.getActionEnabled()) {
            params.put("actionEnabled", String.valueOf(request.getActionEnabled()));
        }
        internalRequest.setParameters(params);
        return this.invokeHttpClient(internalRequest, ListCustomConfigResponse.class);
    }

    public CustomAlarmConfigResponse detailCustomAlarmConfig(DetailCustomAlarmConfigRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, "/csm/api/v1/custom/alarm/configs/detail");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", request.getUserId());
        params.put("alarmName", request.getAlarmName());
        params.put("namespace", request.getNamespace());
        internalRequest.setParameters(params);
        return this.invokeHttpClient(internalRequest, CustomAlarmConfigResponse.class);
    }

    public void blockCustomAlarmConfig(DetailCustomAlarmConfigRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/custom/alarm/configs/block");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", request.getUserId());
        params.put("alarmName", request.getAlarmName());
        params.put("namespace", request.getNamespace());
        internalRequest.setParameters(params);
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public void unblockCustomAlarmConfig(DetailCustomAlarmConfigRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAlarmName(), StringFormatUtils.checkEmptyExceptionMessageFormat("alarmName"));
        Validate.checkStringNotEmpty(request.getNamespace(), StringFormatUtils.checkEmptyExceptionMessageFormat("namespace"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/custom/alarm/configs/unblock");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", request.getUserId());
        params.put("alarmName", request.getAlarmName());
        params.put("namespace", request.getNamespace());
        internalRequest.setParameters(params);
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public HttpResponseWrapper<SiteOnceTaskResponse> createSiteOnceTask(String type, SiteOnceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull((Object)request.getOnceConfig(), (Object)"onceConfig is not null");
        Validate.checkIsTrue(this.checkSiteOnceType(type), "type is wrong, provide HTTP/HTTPS/PING/FTP/TCP/UDP/DNS.");
        Validate.checkIsTrue(this.checkSiteOnceType(String.valueOf((Object)request.getProtocolType())), "protocolType is wrong, provide HTTP/HTTPS/PING/FTP/TCP/UDP/DNS.");
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getAddress(), StringFormatUtils.checkEmptyExceptionMessageFormat("address"));
        Validate.checkIsTrue(request.getIpType() != null && (request.getIpType().equals("ipv6") || request.getIpType().equals("ipv4")), "ipType is ipv6 or ipv4");
        Validate.checkStringNotEmpty(request.getIdc(), StringFormatUtils.checkEmptyExceptionMessageFormat("idc"));
        if (request.getTimeout() < 0) {
            request.setTimeout(60);
        }
        String url = String.format("/csm/api/v1/site/once/%s/taskCreate", type);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, HttpResponseWrapper.class);
    }

    private boolean checkSiteOnceType(String type) {
        return "HTTP".equals(type) || "HTTPS".equals(type) || "PING".equals(type) || "FTP".equals(type) || "TCP".equals(type) || "UDP".equals(type) || "DNS".equals(type);
    }

    public HttpResponseWrapper<SiteOnceTaskList> listSiteOnceHistory(SiteOnceTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (request.getPageNo() <= 0) {
            request.setPageNo(1);
        }
        if (request.getPageSize() <= 0) {
            request.setPageSize(10);
        }
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/site/once/taskList");
        return this.invokeHttpClient(internalRequest, HttpResponseWrapper.class);
    }

    public HttpResponseWrapper<SiteOnceTaskResponse> deleteSiteOnceRecord(SiteOnceTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getSiteId(), StringFormatUtils.checkEmptyExceptionMessageFormat("siteId"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/site/once/taskDelete");
        return this.invokeHttpClient(internalRequest, HttpResponseWrapper.class);
    }

    public HttpResponseWrapper<SiteOnceTaskRequest> detailSiteOnceResult(SiteOnceTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getSiteId(), StringFormatUtils.checkEmptyExceptionMessageFormat("siteId"));
        if (request.getPageNo() <= 0) {
            request.setPageNo(1);
        }
        if (request.getPageSize() <= 0) {
            request.setPageSize(10);
        }
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/site/once/loadData");
        return this.invokeHttpClient(internalRequest, HttpResponseWrapper.class);
    }

    public HttpResponseWrapper<SiteOnceGroupTask> detailSiteOnce(SiteOnceTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        if (request.getPageNo() <= 0) {
            request.setPageNo(1);
        }
        if (request.getPageSize() <= 0) {
            request.setPageSize(10);
        }
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/site/once/groupTask");
        return this.invokeHttpClient(internalRequest, HttpResponseWrapper.class);
    }

    public HttpResponseWrapper<SiteOnceTaskResponse> againExecSiteOnce(SiteOnceTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkStringNotEmpty(request.getSiteId(), StringFormatUtils.checkEmptyExceptionMessageFormat("siteId"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/site/once/createFromTask");
        return this.invokeHttpClient(internalRequest, HttpResponseWrapper.class);
    }

    public HttpResponseWrapper<SiteOnceTaskList> listSiteOnceTaskHistory(SiteOnceTaskRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, "/csm/api/v1/site/once/groupTaskList");
        return this.invokeHttpClient(internalRequest, HttpResponseWrapper.class);
    }

    public HttpResponseWrapper<SiteOnceAgent> getSiteAgent(String userId, String ipType) {
        Validate.checkStringNotEmpty(userId, StringFormatUtils.checkEmptyExceptionMessageFormat("userId"));
        Validate.checkIsTrue(ipType != null && ("ipv6".equals(ipType) || "ipv4".equals(ipType)), "ipType is ipv6 or ipv4");
        InternalRequest internalRequest = this.createBodyRequest(new EmptyRequest(), HttpMethodName.GET, "/csm/api/v1/site/once/siteAgent");
        internalRequest.addParameter("userId", userId);
        internalRequest.addParameter("ipType", ipType);
        return this.invokeHttpClient(internalRequest, HttpResponseWrapper.class);
    }

    public ApplicationInfoResponse createApplicationData(ApplicationInfoRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "name"));
        Validate.checkStringNotEmpty(request.getType(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, TYPE));
        Validate.checkStringNotEmpty(request.getUserId(), USER_NULL_ERROR_MESSAGE);
        String url = String.format(APPLICATION_INFO_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, ApplicationInfoResponse.class);
    }

    public ApplicationDataListResponse getApplicationDataList(String userId, ApplicationDataListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(userId, USER_NULL_ERROR_MESSAGE);
        String url = String.format(APPLICATION_INFO_PATH, userId);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ApplicationDataListResponse.class);
    }

    public ApplicationInfoUpdateResponse updateApplicationData(ApplicationInfoUpdateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), USER_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(String.valueOf(request.getId()), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "id"));
        Validate.checkStringNotEmpty(request.getType(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, TYPE));
        Validate.checkStringNotEmpty(request.getName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "name"));
        String url = String.format(APPLICATION_INFO_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, ApplicationInfoUpdateResponse.class);
    }

    public void deleteApplicationData(String userId, ApplicationInfoDetaleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "name"));
        Validate.checkStringNotEmpty(userId, String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        String url = String.format(APPLICATION_INFO_DELETE_PATH, userId, request.getName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.DELETE, url);
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public ApplicationInstanceListResponse getApplicationInstanceList(String userId, ApplicationInstanceListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(userId, String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userId"));
        Validate.checkStringNotEmpty(request.getRegion(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, REGION));
        Validate.checkStringNotEmpty(request.getAppName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "appName"));
        if (StringUtils.isEmpty((String)String.valueOf(request.getPageSize())) || StringUtils.isEmpty((String)String.valueOf(request.getPageNo()))) {
            request.setPageSize(10);
            request.setPageNo(1);
        }
        String url = String.format(APPLICATION_INFO_LIST_PATH, userId);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, ApplicationInstanceListResponse.class);
    }

    public ApplicationMonitorResponse createApplicationInstance(ApplicationInstanceCreateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull(request.getHostList(), (Object)String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "instanceList"));
        String url = String.format(APPLICATION_INSTANCE_CREATE_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, ApplicationMonitorResponse.class);
    }

    public ApplicationInstanceListResponse getApplicationInstanceCreatedList(ApplicationInstanceCreatedListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        String url = String.format(APPLICATION_INSTANCE_CREATED_LIST_PATH, request.getUserId(), request.getAppName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ApplicationInstanceListResponse.class);
    }

    public void deleteApplicationInstance(String userId, ApplicationInstanceDeleteRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(userId, String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userId"));
        Validate.checkStringNotEmpty(request.getAppName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "appName"));
        Validate.checkStringNotEmpty(request.getId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "id"));
        String url = String.format(APPLICATION_INSTANCE_DELETE_PATH, userId, request.getAppName(), request.getId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.DELETE, url);
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public ApplicationMonitorTaskResponse createApplicationInstanceTask(String userId, ApplicationMonitorTaskInfoRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(userId, String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        String url = String.format(APPLICATION_TASK_CREATE_PATH, userId);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, ApplicationMonitorTaskResponse.class);
    }

    public ApplicationMonitorTaskResponse getApplicationMonitorTaskDetail(ApplicationMonitorTaskDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getAppName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "appName"));
        Validate.checkStringNotEmpty(request.getTaskName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "taskName"));
        String url = String.format(APPLICATION_TASK_DETAIL_PATH, request.getUserId(), request.getAppName(), request.getTaskName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ApplicationMonitorTaskResponse.class);
    }

    public List<ApplicationMonitorTaskResponse> getApplicationMonitorTaskList(ApplicationMonitorTaskListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getAppName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "appName"));
        String url = String.format(APPLICATION_TASK_LIST_PATH, request.getUserId(), request.getAppName());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        if (null != request.getType() && StringUtils.isNotEmpty((String)request.getType())) {
            internalRequest.addParameter(TYPE, request.getType());
        }
        return this.invokeHttpClient(internalRequest, ListResponse.class).getResult();
    }

    public ApplicationMonitorTaskResponse updateApplicationMonitorTask(String userId, ApplicationMonitorTaskInfoRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(userId, String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getAppName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "appName"));
        Validate.checkStringNotEmpty(request.getName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "name"));
        Validate.checkStringNotEmpty(request.getAliasName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "aliasName"));
        Validate.checkStringNotEmpty(request.getTarget(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "target"));
        if (request.getType() < 0 || request.getType() > 3) {
            throw new IllegalArgumentException("type must be in [0,1,2,3]");
        }
        String url = String.format(APPLICATION_TASK_UPDATE_PATH, userId);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, ApplicationMonitorTaskResponse.class);
    }

    public void deleteApplicationMonitorTask(ApplicationMonitorTaskDeleteRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getAppName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "appName"));
        Validate.checkStringNotEmpty(request.getName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "name"));
        String url = String.format(APPLICATION_TASK_DELETE_PATH, request.getUserId(), request.getAppName(), request.getName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.DELETE, url);
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public ApplicationDimensionTableInfoResponse createApplicationDimensionTable(ApplicationDimensionTableInfoRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getAppName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "appName"));
        Validate.checkStringNotEmpty(request.getTableName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "tableName"));
        Validate.checkStringNotEmpty(request.getMapContentJson(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "mapContentJson"));
        String url = String.format(APPLICATION_DIMENSION_TABLE_CREATE_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, ApplicationDimensionTableInfoResponse.class);
    }

    public List<ApplicationDimensionTableInfoResponse> getApplicationDimensionTableList(ApplicationDimensionTableListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getAppName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "appName"));
        String url = String.format(APPLICATION_DIMENSION_TABLE_LIST_PATH, request.getUserId(), request.getAppName());
        InternalRequest internalRequest = this.createRequestWithUrl(request, HttpMethodName.GET, url);
        if (null != request.getSearchName() && StringUtils.isNotEmpty((String)request.getSearchName())) {
            internalRequest.addParameter("searchName", request.getSearchName());
        }
        return this.invokeHttpClient(internalRequest, ListResponse.class).getResult();
    }

    public ApplicationMonitorResponse updateApplicationDimensionTable(ApplicationDimensionTableInfoRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getAppName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "appName"));
        Validate.checkStringNotEmpty(request.getTableName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "tableName"));
        Validate.checkStringNotEmpty(request.getMapContentJson(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "mapContentJson"));
        String url = String.format(APPLICATION_DIMENSION_TABLE_UPDATE_PATH, request.getUserId());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.PUT, url);
        return this.invokeHttpClient(internalRequest, ApplicationMonitorResponse.class);
    }

    public void deleteApplicationDimensionTable(ApplicationDimensionTableDeleteRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getAppName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "appName"));
        Validate.checkStringNotEmpty(request.getTableName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "tableName"));
        String url = String.format(APPLICATION_DIMENSION_TABLE_DELETE_PATH, request.getUserId(), request.getAppName(), request.getTableName());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.DELETE, url);
        this.invokeHttpClient(internalRequest, EmptyResponse.class);
    }

    public MultiDimensionalLatestMetricsResponse getMultiDimensionalLatestMetrics(MultiDimensionalLatestMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getScope(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, SCOPE_MESSAGE_KEY));
        Validate.checkListSizeInRange(request.getDimensions(), MAX_DIMENSIONS_SIZE, "the max size of dimensions is " + MAX_DIMENSIONS_SIZE);
        String url = String.format(MULTI_DIMENSIONAL_LATEST_METRICS_PATH, request.getUserId(), request.getScope());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        return this.invokeHttpClient(internalRequest, MultiDimensionalLatestMetricsResponse.class);
    }

    public TsdbMetricResult<PageResultResponse<TsdbMetricAllDataResult.AllDataMetric>> getMetricsByPartialDimensions(PartialDimensionsMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getScope(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, SCOPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getStartTime(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, START_TIME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getEndTime(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, END_TIME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getMetricName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "metricName"));
        if (CollectionUtils.isEmpty(request.getStatistics())) {
            throw new IllegalArgumentException("param statistics should not be null");
        }
        Validate.checkListSizeInRange(request.getDimensions(), MAX_DIMENSIONS_SIZE, "the max size of dimensions is " + MAX_DIMENSIONS_SIZE);
        String url = String.format(METRICS_BY_PARTIAL_DIMENSIONS_PATH, request.getUserId(), request.getScope());
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, url);
        TsdbMetricResult tsdbMetricResult = this.invokeHttpClient(internalRequest, TsdbMetricResult.class);
        ObjectMapper objectMapper = new ObjectMapper();
        tsdbMetricResult.setResult(objectMapper.convertValue(tsdbMetricResult.getResult(), (TypeReference)new TypeReference<PageResultResponse<TsdbMetricAllDataResult.AllDataMetric>>(){}));
        return tsdbMetricResult;
    }

    public TsdbMetricAllDataResult batchGetMetricsAllDataV2(MultiDimensionalMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getScope(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, SCOPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getRegion(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, REGION));
        Validate.checkStringNotEmpty(request.getStartTime(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, START_TIME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getEndTime(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, END_TIME_MESSAGE_KEY));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getMetricNames()), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "metricNames"));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getStatistics()), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "statistics"));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getDimensions()), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, DIMENSIONS_MESSAGE_KEY));
        Validate.checkListSizeInRange(request.getDimensions(), MAX_DIMENSIONS_SIZE, "the max size of dimensions is " + MAX_DIMENSIONS_SIZE);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, BATCH_GET_METRICS_PATH);
        return this.invokeHttpClient(internalRequest, TsdbMetricAllDataResult.class);
    }

    public TsdbMetricAllDataResult getAllDataMetricV2(MultiDimensionalMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getScope(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, SCOPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getRegion(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, REGION));
        Validate.checkStringNotEmpty(request.getStartTime(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, START_TIME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getEndTime(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, END_TIME_MESSAGE_KEY));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getMetricNames()), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "metricNames"));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getStatistics()), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "statistics"));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getDimensions()), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, DIMENSIONS_MESSAGE_KEY));
        Validate.checkListSizeInRange(request.getDimensions(), MAX_DIMENSIONS_SIZE, "the max size of dimensions is " + MAX_DIMENSIONS_SIZE);
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, ALL_DATA_METRIC_V2_PATH);
        return this.invokeHttpClient(internalRequest, TsdbMetricAllDataResult.class);
    }

    public TsdbDimensionTopResult getMetricDimensionTop(TsdbDimensionTopQuery request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getUserId(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "userID"));
        Validate.checkStringNotEmpty(request.getScope(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, SCOPE_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getRegion(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, REGION));
        Validate.checkStringNotEmpty(request.getStartTime(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, START_TIME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getEndTime(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, END_TIME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getMetricName(), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "metricName"));
        Validate.checkIsTrue(request.getDimensions().size() > 0, String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, DIMENSIONS_MESSAGE_KEY));
        Validate.checkIsTrue(CollectionUtils.isNotEmpty(request.getLabels()), String.format(REQUEST_PARAM_NULL_ERROR_MESSAGE, "labels"));
        InternalRequest internalRequest = this.createBodyRequest(request, HttpMethodName.POST, TOPN_PATH);
        return this.invokeHttpClient(internalRequest, TsdbDimensionTopResult.class);
    }
}

