/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bes.model;

import com.baidubce.services.bes.model.AbstractBesRequest;
import com.baidubce.services.bes.model.BesConfigTuple;
import com.baidubce.services.bes.model.DiskSlotInfo;
import com.baidubce.services.bes.model.ModuleType;
import com.baidubce.services.bes.model.PaymentType;
import com.baidubce.services.bes.model.SlotType;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import javax.validation.constraints.NotNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BesResizeClusterRequest
extends AbstractBesRequest {
    @JsonProperty
    private String name;
    @JsonProperty
    private List<ModuleDesc> modules;
    @NotNull
    @JsonProperty
    private List<BesConfigTuple> configs;
    @JsonProperty
    private String paymentType;
    @JsonProperty
    private String clusterId;
    @JsonProperty
    private String region;

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public List<ModuleDesc> getModules() {
        return this.modules;
    }

    public void setModules(List<ModuleDesc> modules) {
        this.modules = modules;
    }

    public List<BesConfigTuple> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<BesConfigTuple> configs) {
        this.configs = configs;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.setPaymentType(paymentType.getPaymentType());
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public String toJson(String region) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonGenerator jsonGenerator = JsonUtils.jsonGeneratorOf(stringWriter);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("clusterId", this.clusterId);
        jsonGenerator.writeStringField("name", this.name);
        jsonGenerator.writeStringField("region", region);
        jsonGenerator.writeStringField("paymentType", this.paymentType);
        jsonGenerator.writeArrayFieldStart("modules");
        for (ModuleDesc module : this.modules) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("slotType", module.getSlotType());
            jsonGenerator.writeNumberField("desireInstanceNum", module.getDesireInstanceNum());
            jsonGenerator.writeStringField("version", module.getVersion());
            jsonGenerator.writeStringField("type", module.getType());
            if (module.getDiskSlotInfo() != null) {
                jsonGenerator.writeObjectFieldStart("diskSlotInfo");
                jsonGenerator.writeStringField("type", module.getDiskSlotInfo().getType());
                jsonGenerator.writeNumberField("size", module.getDiskSlotInfo().getSize());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
        jsonGenerator.close();
        return stringWriter.toString();
    }

    public static class ModuleDesc {
        @JsonProperty
        private String type;
        @JsonProperty
        private String version;
        @JsonProperty(value="slot_type")
        private String slotType;
        @JsonProperty
        private int desireInstanceNum;
        @JsonProperty
        private DiskSlotInfo diskSlotInfo;

        public DiskSlotInfo getDiskSlotInfo() {
            return this.diskSlotInfo;
        }

        public void setDiskSlotInfo(DiskSlotInfo diskSlotInfo) {
            this.diskSlotInfo = diskSlotInfo;
        }

        public String getType() {
            return this.type;
        }

        public void setType(ModuleType type) {
            this.setType(type.getModuleType());
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getSlotType() {
            return this.slotType;
        }

        public void setSlotType(SlotType slotType) {
            this.setSlotType(slotType.getSlotType());
        }

        public void setSlotType(String slotType) {
            this.slotType = slotType;
        }

        public int getDesireInstanceNum() {
            return this.desireInstanceNum;
        }

        public void setDesireInstanceNum(int desireInstanceNum) {
            this.desireInstanceNum = desireInstanceNum;
        }
    }
}

