/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.eip;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.eip.model.AutoRenewEipRequest;
import com.baidubce.services.eip.model.Billing;
import com.baidubce.services.eip.model.BindEipRequest;
import com.baidubce.services.eip.model.CreateEipRequest;
import com.baidubce.services.eip.model.CreateEipResponse;
import com.baidubce.services.eip.model.DirectEipRequest;
import com.baidubce.services.eip.model.ListEipsRequest;
import com.baidubce.services.eip.model.ListEipsResponse;
import com.baidubce.services.eip.model.ListRecycleEipsRequest;
import com.baidubce.services.eip.model.ListRecycleEipsResponse;
import com.baidubce.services.eip.model.OptionalReleaseEipRequest;
import com.baidubce.services.eip.model.PurchaseReservedEipRequest;
import com.baidubce.services.eip.model.RecycleOperateEipRequest;
import com.baidubce.services.eip.model.ReleaseEipRequest;
import com.baidubce.services.eip.model.ResizeEipRequest;
import com.baidubce.services.eip.model.StopAutoRenewEipRequest;
import com.baidubce.services.eip.model.UnbindEipRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;

public class EipClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String PREFIX = "eip";
    private static final String CLIENT_TOKEN_IDENTIFY = "clientToken";
    private static HttpResponseHandler[] eipHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public EipClient() {
        this(new BceClientConfiguration());
    }

    public EipClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, eipHandlers);
    }

    public CreateEipResponse createEip(int bandwidthInMbps) {
        return this.createEip(new CreateEipRequest().withBandwidthInMbps(bandwidthInMbps));
    }

    public CreateEipResponse createEip(CreateEipRequest request) {
        Validate.checkNotNull(request.getBandwidthInMbps(), "bandwidthInMbps should not be null");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBilling());
        }
        Validate.checkNotNull(request.getBandwidthInMbps(), "bandwidthInMbps should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateEipResponse.class);
    }

    public void resizeEip(String eip, int newBandwidthInMbps) {
        this.resizeEip(new ResizeEipRequest().withEip(eip).withNewBandwidthInMbps(newBandwidthInMbps));
    }

    public void resizeEip(ResizeEipRequest request) {
        Validate.checkNotNull(request.getNewBandwidthInMbps(), "newBandwidthInMbps should not be null");
        Validate.checkStringNotEmpty(request.getEip(), "eip should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getEip());
        internalRequest.addParameter("resize", null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void purchaseReservedEipInMonth(String eip, int reservationLength) {
        Billing billing = new Billing();
        billing.setReservation(new Billing.Reservation().withReservationLength(reservationLength));
        this.purchaseReservedEip(new PurchaseReservedEipRequest().withEip(eip).withBilling(billing));
    }

    public void purchaseReservedEip(String eip, int reservationLength, String reservationTimeUnit) {
        Billing billing = new Billing();
        billing.setReservation(new Billing.Reservation().withReservationLength(reservationLength).withReservationTimeUnit(reservationTimeUnit));
        this.purchaseReservedEip(new PurchaseReservedEipRequest().withEip(eip).withBilling(billing));
    }

    public void purchaseReservedEip(PurchaseReservedEipRequest request) {
        Validate.checkStringNotEmpty(request.getEip(), "eip should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultReservation());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getEip());
        internalRequest.addParameter("purchaseReserved", null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void startAutoRenew(AutoRenewEipRequest request) {
        Validate.checkStringNotEmpty(request.getEip(), "eip should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getEip());
        internalRequest.addParameter("startAutoRenew", null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void stopAutoRenew(StopAutoRenewEipRequest request) {
        Validate.checkStringNotEmpty(request.getEip(), "eip should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getEip());
        internalRequest.addParameter("stopAutoRenew", null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void directEip(DirectEipRequest request) {
        Validate.checkStringNotEmpty(request.getEip(), "eip should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getEip());
        internalRequest.addParameter("direct", null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        internalRequest.addHeader("Content-Length", "0");
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unDirectEip(DirectEipRequest request) {
        Validate.checkStringNotEmpty(request.getEip(), "eip should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getEip());
        internalRequest.addParameter("unDirect", null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        internalRequest.addHeader("Content-Length", "0");
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void bindEip(String eip, String instanceId, String instanceType) {
        this.bindEip(new BindEipRequest().withEip(eip).withInstanceId(instanceId).withInstanceType(instanceType));
    }

    public void bindEip(String eip, String instanceId, String instanceIp, String instanceType) {
        this.bindEip(new BindEipRequest().withEip(eip).withInstanceId(instanceId).withInstanceIp(instanceIp).withInstanceType(instanceType));
    }

    public void bindEip(BindEipRequest request) {
        Validate.checkStringNotEmpty(request.getEip(), "eip should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getEip());
        internalRequest.addParameter("bind", null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unbindEip(String eip) {
        this.unbindEip(new UnbindEipRequest().withEip(eip));
    }

    public void unbindEip(UnbindEipRequest request) {
        Validate.checkStringNotEmpty(request.getEip(), "eip should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, request.getEip());
        internalRequest.addParameter("unbind", null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        internalRequest.addHeader("Content-Length", "0");
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void releaseEip(String eip) {
        this.releaseEip(new ReleaseEipRequest().withEip(eip));
    }

    public void releaseEip(ReleaseEipRequest request) {
        Validate.checkStringNotEmpty(request.getEip(), "eip should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, request.getEip());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListEipsResponse listEips() {
        ListEipsRequest request = new ListEipsRequest();
        return this.listEips(request);
    }

    public ListEipsResponse listEips(ListEipsRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, null);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() >= 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getEip())) {
            internalRequest.addParameter(PREFIX, request.getEip());
        }
        if (!Strings.isNullOrEmpty((String)request.getInstanceId())) {
            internalRequest.addParameter("instanceId", request.getInstanceId());
            if (Strings.isNullOrEmpty((String)request.getInstanceType())) {
                throw new IllegalArgumentException("there is not instanceType");
            }
        }
        if (!Strings.isNullOrEmpty((String)request.getInstanceType())) {
            internalRequest.addParameter("instanceType", request.getInstanceType());
        }
        return this.invokeHttpClient(internalRequest, ListEipsResponse.class);
    }

    public ListRecycleEipsResponse listRecycleEips(ListRecycleEipsRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "recycle");
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() >= 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getEip())) {
            internalRequest.addParameter(PREFIX, request.getEip());
        }
        if (!Strings.isNullOrEmpty((String)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        return this.invokeHttpClient(internalRequest, ListRecycleEipsResponse.class);
    }

    public void optionalReleaseEip(OptionalReleaseEipRequest request) {
        Validate.checkStringNotEmpty(request.getEip(), "eip should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, request.getEip());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        internalRequest.addParameter("releaseToRecycle", String.valueOf(request.isReleaseToRecycle()));
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void releaseEipFromRecycle(RecycleOperateEipRequest request) {
        Validate.checkStringNotEmpty(request.getEip(), "eip should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, "recycle/" + request.getEip());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void restoreEipFromRecycle(RecycleOperateEipRequest request) {
        Validate.checkStringNotEmpty(request.getEip(), "eip should not be empty");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateDefaultClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "recycle/" + request.getEip());
        internalRequest.addParameter("restore", null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, request.getClientToken());
        internalRequest.addHeader("Content-Length", "0");
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        path.add(PREFIX);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateDefaultClientToken() {
        return UUID.randomUUID().toString();
    }

    private Billing generateDefaultBilling() {
        Billing billing = new Billing();
        billing.setPaymentTiming("Postpaid");
        billing.setBillingMethod("ByBandwidth");
        return billing;
    }

    private Billing generateDefaultReservation() {
        Billing billing = new Billing();
        Billing.Reservation reservation = new Billing.Reservation();
        billing.setReservation(reservation);
        reservation.setReservationLength(1);
        return billing;
    }
}

