/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestoragehbaseclient.hbase;

import com.baidubce.services.tablestoragehbaseclient.adaptor.TableStorageAdaptor;
import com.baidubce.services.tablestoragehbaseclient.adaptor.TablestorageConfiguration;
import com.baidubce.services.tablestoragehbaseclient.hbase.TablestorageConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class TablestorageRegionLocator
implements RegionLocator {
    private static long MAX_REGION_CACHE_TIME_MS = 600000L;
    private TableStorageAdaptor adaptor;
    private final TableName tableName;
    private ServerName serverName;
    private List<HRegionLocation> regions;
    private long regionsLastReloadTimeMS;

    public TablestorageRegionLocator(TablestorageConnection connection, TableName tableName) {
        this.tableName = tableName;
        this.serverName = ServerName.valueOf((String)connection.getTablestorageConfiguration().getEndpoint(), (int)0, (long)0L);
        TablestorageConfiguration conf = connection.getTablestorageConfiguration();
        this.adaptor = new TableStorageAdaptor(conf.getEndpoint(), conf.getInstanceName(), conf.getAccessKeyId(), conf.getSecretAccessKey());
        this.regions = null;
        this.regionsLastReloadTimeMS = 0L;
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.getRegionLocation(row, false);
    }

    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        for (HRegionLocation region : this.getRegions(reload)) {
            if (!region.getRegionInfo().containsRow(row)) continue;
            return region;
        }
        throw new IOException("Region not found, row: " + Bytes.toStringBinary((byte[])row));
    }

    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        return this.getRegions(false);
    }

    public byte[][] getStartKeys() throws IOException {
        return this.adaptor.getStartKeys(this.tableName.getNameAsString());
    }

    public byte[][] getEndKeys() throws IOException {
        return this.adaptor.getEndKeys(this.tableName.getNameAsString());
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.adaptor.getStartEndKeys(this.tableName.getNameAsString());
    }

    public TableName getName() {
        return this.tableName;
    }

    public void close() throws IOException {
        this.adaptor.close();
    }

    private List<HRegionLocation> getRegions(boolean reload) throws IOException {
        if (!reload && this.regions != null && this.regionsLastReloadTimeMS + MAX_REGION_CACHE_TIME_MS > System.currentTimeMillis()) {
            return this.regions;
        }
        this.regions = new ArrayList<HRegionLocation>();
        Pair<byte[][], byte[][]> startEndKeys = this.adaptor.getStartEndKeys(this.tableName.getNameAsString());
        byte[][] startKeys = (byte[][])startEndKeys.getFirst();
        byte[][] endKeys = (byte[][])startEndKeys.getSecond();
        for (int i = 0; i < startKeys.length; ++i) {
            HRegionInfo regionInfo = new HRegionInfo(this.tableName, startKeys[i], endKeys[i]);
            HRegionLocation region = new HRegionLocation(regionInfo, this.serverName, (long)i);
            this.regions.add(region);
        }
        this.regionsLastReloadTimeMS = System.currentTimeMillis();
        return this.regions;
    }
}

