/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator.druid;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.logging.CommonsLogFilter;
import com.alibaba.druid.filter.logging.Log4j2Filter;
import com.alibaba.druid.filter.logging.Log4jFilter;
import com.alibaba.druid.filter.logging.Slf4jLogFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceProperty;
import com.baomidou.dynamic.datasource.creator.druid.DruidConfig;
import com.baomidou.dynamic.datasource.creator.druid.DruidConfigUtil;
import com.baomidou.dynamic.datasource.creator.druid.DruidLogConfigUtil;
import com.baomidou.dynamic.datasource.creator.druid.DruidStatConfigUtil;
import com.baomidou.dynamic.datasource.creator.druid.DruidWallConfigUtil;
import com.baomidou.dynamic.datasource.exception.ErrorCreateDataSourceException;
import com.baomidou.dynamic.datasource.toolkit.DsStrUtils;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidDataSourceCreator
implements DataSourceCreator {
    private static final Logger log = LoggerFactory.getLogger(DruidDataSourceCreator.class);
    private static final Set<String> PARAMS = new HashSet<String>();
    private static Method configMethod = null;
    private DruidConfig gConfig;

    private static void fetchMethod() {
        Class<DruidDataSource> aClass = DruidDataSource.class;
        try {
            configMethod = aClass.getMethod("configFromPropeties", Properties.class);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                configMethod = aClass.getMethod("configFromPropety", Properties.class);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException("Druid does not has 'configFromPropeties' or 'configFromPropety' method!");
            }
        }
    }

    @Override
    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUsername(dataSourceProperty.getUsername());
        dataSource.setPassword(dataSourceProperty.getPassword());
        dataSource.setUrl(dataSourceProperty.getUrl());
        dataSource.setName(dataSourceProperty.getPoolName());
        String driverClassName = dataSourceProperty.getDriverClassName();
        if (DsStrUtils.hasText(driverClassName)) {
            dataSource.setDriverClassName(driverClassName);
        }
        DruidConfig config = dataSourceProperty.getDruid();
        Properties properties = DruidConfigUtil.mergeConfig(this.gConfig, config);
        List<Filter> proxyFilters = this.initFilters(dataSourceProperty, properties.getProperty("druid.filters"));
        dataSource.setProxyFilters(proxyFilters);
        try {
            configMethod.invoke((Object)dataSource, properties);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataSource.setConnectProperties(config.getConnectionProperties());
        for (String param : PARAMS) {
            DruidConfigUtil.setValue(dataSource, param, this.gConfig, config);
        }
        if (Boolean.FALSE.equals(dataSourceProperty.getLazy())) {
            try {
                dataSource.init();
            }
            catch (SQLException e) {
                throw new ErrorCreateDataSourceException("druid create error", e);
            }
        }
        return dataSource;
    }

    private List<Filter> initFilters(DataSourceProperty dataSourceProperty, String filters) {
        ArrayList<Filter> proxyFilters = new ArrayList<Filter>(2);
        if (DsStrUtils.hasText(filters)) {
            String[] filterItems;
            String[] stringArray = filterItems = filters.split(",");
            int n = stringArray.length;
            block16: for (int i = 0; i < n; ++i) {
                String filter;
                switch (filter = stringArray[i]) {
                    case "stat": {
                        proxyFilters.add((Filter)DruidStatConfigUtil.toStatFilter(dataSourceProperty.getDruid().getStat(), this.gConfig.getStat()));
                        continue block16;
                    }
                    case "wall": {
                        WallConfig wallConfig = DruidWallConfigUtil.toWallConfig(dataSourceProperty.getDruid().getWall(), this.gConfig.getWall());
                        WallFilter wallFilter = new WallFilter();
                        wallFilter.setConfig(wallConfig);
                        proxyFilters.add((Filter)wallFilter);
                        continue block16;
                    }
                    case "slf4j": {
                        proxyFilters.add((Filter)DruidLogConfigUtil.initFilter(Slf4jLogFilter.class, dataSourceProperty.getDruid().getSlf4j(), this.gConfig.getSlf4j()));
                        continue block16;
                    }
                    case "commons-log": {
                        proxyFilters.add((Filter)DruidLogConfigUtil.initFilter(CommonsLogFilter.class, dataSourceProperty.getDruid().getCommonsLog(), this.gConfig.getCommonsLog()));
                        continue block16;
                    }
                    case "log4j": {
                        proxyFilters.add((Filter)DruidLogConfigUtil.initFilter(Log4jFilter.class, dataSourceProperty.getDruid().getLog4j(), this.gConfig.getLog4j()));
                        continue block16;
                    }
                    case "log4j2": {
                        proxyFilters.add((Filter)DruidLogConfigUtil.initFilter(Log4j2Filter.class, dataSourceProperty.getDruid().getLog4j2(), this.gConfig.getLog4j2()));
                        continue block16;
                    }
                    default: {
                        log.warn("dynamic-datasource current not support [{}]", (Object)filter);
                    }
                }
            }
        }
        return proxyFilters;
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null || "com.alibaba.druid.pool.DruidDataSource".equals(type.getName());
    }

    public DruidDataSourceCreator() {
    }

    public DruidDataSourceCreator(DruidConfig gConfig) {
        this.gConfig = gConfig;
    }

    static {
        DruidDataSourceCreator.fetchMethod();
        PARAMS.add("defaultCatalog");
        PARAMS.add("defaultAutoCommit");
        PARAMS.add("defaultReadOnly");
        PARAMS.add("defaultTransactionIsolation");
        PARAMS.add("testOnReturn");
        PARAMS.add("validationQueryTimeout");
        PARAMS.add("sharePreparedStatements");
        PARAMS.add("connectionErrorRetryAttempts");
        PARAMS.add("breakAfterAcquireFailure");
        PARAMS.add("removeAbandonedTimeoutMillis");
        PARAMS.add("removeAbandoned");
        PARAMS.add("logAbandoned");
        PARAMS.add("queryTimeout");
        PARAMS.add("transactionQueryTimeout");
        PARAMS.add("timeBetweenConnectErrorMillis");
        PARAMS.add("connectTimeout");
        PARAMS.add("socketTimeout");
    }
}

