/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.plugin;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.ds.GroupDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.support.HealthCheckAdapter;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MasterSlaveAutoRoutingPlugin
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MasterSlaveAutoRoutingPlugin.class);
    @Autowired
    protected DataSource dynamicDataSource;
    @Autowired
    private DynamicDataSourceProperties properties;
    @Lazy
    @Autowired(required=false)
    private HealthCheckAdapter healthCheckAdapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        String pushedDataSource = null;
        try {
            String dataSource = this.getDataSource(ms);
            pushedDataSource = DynamicDataSourceContextHolder.push(dataSource);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (pushedDataSource != null) {
                DynamicDataSourceContextHolder.poll();
            }
        }
    }

    public String getDataSource(MappedStatement mappedStatement) {
        String currentDataSource = SqlCommandType.SELECT == mappedStatement.getSqlCommandType() ? "slave" : "master";
        String dataSource = null;
        if (this.properties.isHealth()) {
            boolean health;
            GroupDataSource groupDataSource;
            Map<String, GroupDataSource> currentGroupDataSources;
            DynamicRoutingDataSource dynamicRoutingDataSource = (DynamicRoutingDataSource)((Object)this.dynamicDataSource);
            if ("slave".equalsIgnoreCase(currentDataSource)) {
                currentGroupDataSources = dynamicRoutingDataSource.getCurrentGroupDataSources();
                groupDataSource = currentGroupDataSources.get("slave");
                String dsKey = groupDataSource.determineDsKey();
                boolean health2 = this.healthCheckAdapter.getHealth(dsKey);
                if (health2) {
                    dataSource = dsKey;
                } else {
                    log.warn("\u4ece\u5e93\u65e0\u6cd5\u8fde\u63a5, \u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u914d\u7f6e, key: {}", (Object)dsKey);
                }
            }
            if (dataSource == null && !(health = this.healthCheckAdapter.getHealth(dataSource = (groupDataSource = (currentGroupDataSources = dynamicRoutingDataSource.getCurrentGroupDataSources()).get("master")).determineDsKey()))) {
                log.warn("\u4e3b\u5e93\u65e0\u6cd5\u8fde\u63a5, \u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u914d\u7f6e, key: {}", (Object)dataSource);
            }
        } else {
            dataSource = currentDataSource;
        }
        return dataSource;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

