/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.support;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.support.HealthCheckAdapter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class DbHealthIndicator
extends AbstractHealthIndicator {
    private final String validQuery;
    private final HealthCheckAdapter healthCheckAdapter;
    private final DataSource dataSource;

    public DbHealthIndicator(DataSource dataSource, String validQuery, HealthCheckAdapter healthCheckAdapter) {
        this.dataSource = dataSource;
        this.validQuery = validQuery;
        this.healthCheckAdapter = healthCheckAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        if (this.dataSource instanceof DynamicRoutingDataSource) {
            Map<String, DataSource> dataSourceMap = ((DynamicRoutingDataSource)((Object)this.dataSource)).getDataSources();
            Boolean available = null;
            Boolean disable = null;
            for (Map.Entry<String, DataSource> dataSource : dataSourceMap.entrySet()) {
                Boolean resultAvailable = false;
                try {
                    resultAvailable = this.queryAvailable(dataSource.getValue());
                }
                catch (Throwable throwable) {}
                continue;
                finally {
                    this.healthCheckAdapter.putHealth(dataSource.getKey(), resultAvailable);
                    builder.withDetail(dataSource.getKey(), (Object)resultAvailable);
                    if (resultAvailable.booleanValue()) {
                        available = true;
                        continue;
                    }
                    disable = true;
                }
            }
            if (available != null) {
                if (disable != null) {
                    builder.status(Status.OUT_OF_SERVICE);
                } else {
                    builder.status(Status.UP);
                }
            } else {
                builder.status(Status.DOWN);
            }
        }
    }

    private Boolean queryAvailable(DataSource dataSource) {
        List results = new JdbcTemplate(dataSource).query(this.validQuery, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet resultSet, int i) throws SQLException {
                ResultSetMetaData metaData = resultSet.getMetaData();
                int columns = metaData.getColumnCount();
                if (columns != 1) {
                    throw new IncorrectResultSetColumnCountException(1, columns);
                }
                return (Integer)JdbcUtils.getResultSetValue((ResultSet)resultSet, (int)1, Integer.class);
            }
        });
        return (Integer)DataAccessUtils.requiredSingleResult((Collection)results) == 1;
    }
}

