/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.tx;

import com.baomidou.dynamic.datasource.tx.ConnectionFactory;
import com.baomidou.dynamic.datasource.tx.TransactionContext;
import java.security.SecureRandom;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class LocalTxUtil {
    private static final Logger log = LoggerFactory.getLogger(LocalTxUtil.class);
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM_HOLDER = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };

    public static UUID randomUUID() {
        int i;
        SecureRandom ng = SECURE_RANDOM_HOLDER.get();
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public static String startTransaction() {
        String xid = TransactionContext.getXID();
        if (!StringUtils.isEmpty((Object)xid)) {
            log.debug("dynamic-datasource exist local tx [{}]", (Object)xid);
        } else {
            xid = LocalTxUtil.randomUUID().toString();
            TransactionContext.bind(xid);
            log.debug("dynamic-datasource start local tx [{}]", (Object)xid);
        }
        return xid;
    }

    public static void commit(String xid) throws Exception {
        boolean hasSavepoint = ConnectionFactory.hasSavepoint(xid);
        try {
            ConnectionFactory.notify(xid, true);
        }
        finally {
            if (!hasSavepoint) {
                log.debug("dynamic-datasource commit local tx [{}]", (Object)TransactionContext.getXID());
                TransactionContext.remove();
            }
        }
    }

    public static void rollback(String xid) throws Exception {
        boolean hasSavepoint = ConnectionFactory.hasSavepoint(xid);
        try {
            ConnectionFactory.notify(xid, false);
        }
        finally {
            if (!hasSavepoint) {
                log.debug("dynamic-datasource rollback local tx [{}]", (Object)TransactionContext.getXID());
                TransactionContext.remove();
            }
        }
    }
}

