/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.lock.executor;

import com.baomidou.lock.executor.AbstractLockExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperLockExecutor
extends AbstractLockExecutor<InterProcessMutex> {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperLockExecutor.class);
    private final CuratorFramework curatorFramework;

    public InterProcessMutex acquire(String lockKey, String lockValue, long expire, long acquireTimeout) {
        if (!CuratorFrameworkState.STARTED.equals((Object)this.curatorFramework.getState())) {
            log.warn("instance must be started before calling this method");
            return null;
        }
        String nodePath = "/curator/lock4j/%s";
        try {
            InterProcessMutex mutex = new InterProcessMutex(this.curatorFramework, String.format(nodePath, lockKey));
            boolean locked = mutex.acquire(acquireTimeout, TimeUnit.MILLISECONDS);
            return (InterProcessMutex)this.obtainLockInstance(locked, mutex);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean releaseLock(String key, String value, InterProcessMutex lockInstance) {
        try {
            lockInstance.release();
        }
        catch (Exception e) {
            log.warn("zookeeper lock release error", (Throwable)e);
            return false;
        }
        return true;
    }

    public ZookeeperLockExecutor(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }
}

