/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.lock.spring.boot.autoconfigure;

import com.baomidou.lock.condition.ZookeeperCondition;
import com.baomidou.lock.executor.ZookeeperLockExecutor;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;

@Conditional(value={ZookeeperCondition.class})
@ConfigurationProperties(prefix="spring.coordinate.zookeeper")
class ZookeeperLockAutoConfiguration {
    private String zkServers;
    private int sessionTimeout = 30000;
    private int connectionTimeout = 5000;
    private int baseSleepTimeMs = 1000;
    private int maxRetries = 3;

    @Bean(initMethod="start", destroyMethod="close")
    @ConditionalOnMissingBean(value={CuratorFramework.class})
    public CuratorFramework curatorFramework() {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(this.baseSleepTimeMs, this.maxRetries);
        return CuratorFrameworkFactory.builder().connectString(this.zkServers).sessionTimeoutMs(this.sessionTimeout).connectionTimeoutMs(this.connectionTimeout).retryPolicy((RetryPolicy)retryPolicy).build();
    }

    @Bean
    @Order(value=300)
    public ZookeeperLockExecutor zookeeperLockExecutor(CuratorFramework curatorFramework) {
        return new ZookeeperLockExecutor(curatorFramework);
    }

    public String getZkServers() {
        return this.zkServers;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getBaseSleepTimeMs() {
        return this.baseSleepTimeMs;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setZkServers(String zkServers) {
        this.zkServers = zkServers;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setBaseSleepTimeMs(int baseSleepTimeMs) {
        this.baseSleepTimeMs = baseSleepTimeMs;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZookeeperLockAutoConfiguration)) {
            return false;
        }
        ZookeeperLockAutoConfiguration other = (ZookeeperLockAutoConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSessionTimeout() != other.getSessionTimeout()) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getBaseSleepTimeMs() != other.getBaseSleepTimeMs()) {
            return false;
        }
        if (this.getMaxRetries() != other.getMaxRetries()) {
            return false;
        }
        String this$zkServers = this.getZkServers();
        String other$zkServers = other.getZkServers();
        return !(this$zkServers == null ? other$zkServers != null : !this$zkServers.equals(other$zkServers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZookeeperLockAutoConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSessionTimeout();
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getBaseSleepTimeMs();
        result = result * 59 + this.getMaxRetries();
        String $zkServers = this.getZkServers();
        result = result * 59 + ($zkServers == null ? 43 : $zkServers.hashCode());
        return result;
    }

    public String toString() {
        return "ZookeeperLockAutoConfiguration(zkServers=" + this.getZkServers() + ", sessionTimeout=" + this.getSessionTimeout() + ", connectionTimeout=" + this.getConnectionTimeout() + ", baseSleepTimeMs=" + this.getBaseSleepTimeMs() + ", maxRetries=" + this.getMaxRetries() + ")";
    }
}

